/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.internal.StreamUtils;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyPathTraverser;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileReader;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import ch.jalu.configme.resource.yaml.SnakeYamlNodeBuilder;
import ch.jalu.configme.resource.yaml.SnakeYamlNodeBuilderImpl;
import ch.jalu.configme.resource.yaml.SnakeYamlNodeContainer;
import ch.jalu.configme.resource.yaml.SnakeYamlNodeContainerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;

public class YamlFileResource
implements PropertyResource {
    private final Path path;
    @NotNull
    private final YamlFileResourceOptions options;

    public YamlFileResource(@NotNull Path path) {
        this(path, YamlFileResourceOptions.builder().build());
    }

    public YamlFileResource(@NotNull Path path, @NotNull YamlFileResourceOptions options) {
        this.path = path;
        this.options = options;
    }

    @Override
    @NotNull
    public PropertyReader createReader() {
        return new YamlFileReader(this.path, this.options.getCharset());
    }

    @Override
    public void exportProperties(@NotNull ConfigurationData configurationData) {
        SnakeYamlNodeContainer root = this.createNodeContainerForRoot(configurationData.getCommentsForSection(""));
        PropertyPathTraverser pathTraverser = new PropertyPathTraverser();
        SnakeYamlNodeBuilder nodeBuilder = this.createNodeBuilder();
        List<Property<?>> properties = configurationData.getProperties();
        for (Property<?> property : properties) {
            Object exportValue = this.getExportValue(property, configurationData);
            if (exportValue == null) continue;
            String path = property.getPath();
            List<PropertyPathTraverser.PathElement> pathElements = pathTraverser.getPathElements(path);
            this.createAndAddYamlNode(exportValue, path, pathElements, root, configurationData, nodeBuilder);
        }
        Node rootNode = properties.size() == 1 && "".equals(properties.get(0).getPath()) ? root.getRootValueNode() : root.convertToNode(nodeBuilder);
        try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(os, this.options.getCharset());){
            this.createSnakeYamlInstance().serialize(rootNode, (Writer)writer);
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + String.valueOf(this.path) + "'", e);
        }
    }

    protected void createAndAddYamlNode(@NotNull Object exportValue, @NotNull String path, @NotNull List<PropertyPathTraverser.PathElement> pathElements, @NotNull SnakeYamlNodeContainer rootContainer, @NotNull ConfigurationData configurationData, @NotNull SnakeYamlNodeBuilder nodeBuilder) {
        SnakeYamlNodeContainer container = rootContainer;
        for (PropertyPathTraverser.PathElement pathElement : pathElements) {
            if (pathElement.isEndOfPath()) {
                int emptyLines = this.options.getNumberOfEmptyLinesBefore(pathElement);
                container.putNode(pathElement.getName(), nodeBuilder.createYamlNode(exportValue, path, configurationData, emptyLines));
                continue;
            }
            container = container.getOrCreateChildContainer(pathElement.getName(), () -> this.getCommentsForPathElement(configurationData, pathElement));
        }
    }

    @NotNull
    protected List<String> getCommentsForPathElement(@NotNull ConfigurationData configurationData, @NotNull PropertyPathTraverser.PathElement pathElement) {
        return Stream.concat(StreamUtils.repeat("\n", this.options.getNumberOfEmptyLinesBefore(pathElement)), configurationData.getCommentsForSection(pathElement.getFullPath()).stream()).collect(Collectors.toList());
    }

    @NotNull
    protected final Path getPath() {
        return this.path;
    }

    @NotNull
    protected Yaml createSnakeYamlInstance() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        options.setPrettyFlow(true);
        options.setAllowUnicode(true);
        options.setProcessComments(true);
        options.setIndent(this.options.getIndentationSize());
        return new Yaml(options);
    }

    @NotNull
    protected final YamlFileResourceOptions getOptions() {
        return this.options;
    }

    @NotNull
    protected SnakeYamlNodeBuilder createNodeBuilder() {
        return new SnakeYamlNodeBuilderImpl();
    }

    @NotNull
    protected SnakeYamlNodeContainer createNodeContainerForRoot(@NotNull List<String> rootComments) {
        return new SnakeYamlNodeContainerImpl(rootComments);
    }

    @Nullable
    private <T> Object getExportValue(@NotNull Property<T> property, @NotNull ConfigurationData configurationData) {
        return property.toExportValue(configurationData.getValue(property));
    }
}

