/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.builder;

import ch.jalu.configme.properties.ListProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.builder.PropertyBuilderUtils;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class CollectionPropertyBuilder<E, C extends Collection<E>, P extends Property<? super C>> {
    private String path;
    private final C defaultValue;
    private final BiFunction<String, C, P> createPropertyFunction;

    public CollectionPropertyBuilder(@NotNull BiFunction<String, C, P> createPropertyFunction, @NotNull C defaultValue) {
        this.createPropertyFunction = createPropertyFunction;
        this.defaultValue = defaultValue;
    }

    @NotNull
    public static <E> CollectionPropertyBuilder<E, List<E>, ListProperty<E>> listBuilder(@NotNull PropertyType<E> entryType) {
        return new CollectionPropertyBuilder((path, defVal) -> new ListProperty((String)path, entryType, defVal), new ArrayList());
    }

    @NotNull
    public static <E> CollectionPropertyBuilder<E, Set<E>, SetProperty<E>> setBuilder(@NotNull PropertyType<E> entryType) {
        return new CollectionPropertyBuilder((path, defVal) -> new SetProperty((String)path, entryType, defVal), new LinkedHashSet());
    }

    @NotNull
    public CollectionPropertyBuilder<E, C, P> path(@NotNull String path) {
        this.path = path;
        return this;
    }

    @SafeVarargs
    @NotNull
    public final CollectionPropertyBuilder<E, C, P> defaultValue(E ... entries) {
        return this.defaultValue((Collection<? extends E>)Arrays.asList(entries));
    }

    @NotNull
    public CollectionPropertyBuilder<E, C, P> defaultValue(@NotNull Collection<? extends E> entries) {
        PropertyBuilderUtils.verifyDefaultValueIsEmpty(this.defaultValue.isEmpty());
        this.defaultValue.addAll(entries);
        return this;
    }

    @NotNull
    public CollectionPropertyBuilder<E, C, P> addToDefaultValue(@NotNull E entry) {
        this.defaultValue.add(entry);
        return this;
    }

    @NotNull
    public P build() {
        PropertyBuilderUtils.requireNonNullPath(this.path);
        return (P)((Property)this.createPropertyFunction.apply(this.path, this.defaultValue));
    }
}

