/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeBasedProperty<T>
extends BaseProperty<T> {
    private final PropertyType<T> type;

    public TypeBasedProperty(@NotNull String path, @NotNull PropertyType<T> type, @NotNull T defaultValue) {
        super(path, defaultValue);
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    @Nullable
    protected T getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        return this.type.convert(reader.getObject(this.getPath()), errorRecorder);
    }

    @Override
    @Nullable
    public Object toExportValue(@NotNull T value) {
        return this.type.toExportValue(value);
    }

    @NotNull
    public PropertyType<T> getType() {
        return this.type;
    }
}

