/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.utils;

import com.ryderbelserion.fusion.core.FusionConfig;
import com.ryderbelserion.fusion.core.FusionCore;
import com.ryderbelserion.fusion.core.api.interfaces.IStringUtils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class StringUtils
implements IStringUtils {
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final Pattern ANGLE_PATTERN = Pattern.compile("[<>]");
    private final FusionCore fusion;
    private final FusionConfig config;

    public StringUtils(@NotNull FusionCore fusion) {
        this.fusion = fusion;
        this.config = this.fusion.getConfig();
    }

    @NotNull
    public String toString(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder(list.size());
        for (String line : list) {
            message.append(line).append("\n");
        }
        return this.fusion.chomp(message.toString());
    }

    @Override
    public String replaceAngleBrackets(@NotNull String input) {
        return ANGLE_PATTERN.matcher(input).replaceAll("");
    }

    @Override
    public String replaceBrackets(@NotNull String input) {
        return BRACKET_PATTERN.matcher(input).replaceAll("<$1>");
    }

    @Override
    @NotNull
    public Optional<Number> tryParseInt(@NotNull String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public Optional<Boolean> tryParseBoolean(@NotNull String value) {
        try {
            return Optional.of(Boolean.parseBoolean(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public String fromInteger(int number) {
        return NumberFormat.getIntegerInstance(Locale.US).format(number);
    }

    @Override
    @NotNull
    public String fromDouble(double number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    @Override
    @NotNull
    public String format(double value) {
        DecimalFormat decimalFormat = new DecimalFormat(this.config.getNumberFormat());
        decimalFormat.setRoundingMode(this.getRoundingMode());
        return decimalFormat.format(value);
    }

    @Override
    @NotNull
    public RoundingMode getRoundingMode() {
        return RoundingMode.valueOf(this.config.getRoundingFormat().toUpperCase());
    }
}

