/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ToolEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent event) {
        if (Objects.equals(event.getHand(), EquipmentSlot.HAND)) {
            this.updateEffects(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTelepathy(BlockDropItemEvent event) {
        ItemStack tool;
        Player player = event.getPlayer();
        if (!EnchantUtils.isEventActive(CEnchantments.TELEPATHY, (Entity)player, tool = this.methods.getItemInHand(player), this.enchantmentBookSettings.getEnchantments(tool))) {
            return;
        }
        event.setCancelled(true);
        this.methods.addItemToInventory(player, event.getItems());
    }

    private void updateEffects(Player player) {
        ItemStack item = this.methods.getItemInHand(player);
        Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(item);
        int potionTime = 100;
        if (EnchantUtils.isEventActive(CEnchantments.HASTE, (Entity)player, item, enchantments)) {
            int power = enchantments.get(CEnchantments.HASTE.getEnchantment());
            player.removePotionEffect(PotionEffectType.HASTE);
            player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, potionTime, power - 1));
        }
        if (EnchantUtils.isEventActive(CEnchantments.OXYGENATE, (Entity)player, item, enchantments)) {
            player.removePotionEffect(PotionEffectType.WATER_BREATHING);
            player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, potionTime, 5));
        }
    }
}

