/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.controllers;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BossBarController {
    private final HashMap<UUID, BossBar> bossBars = new HashMap();
    private final CrazyEnchantments plugin;

    public BossBarController(CrazyEnchantments plugin) {
        this.plugin = plugin;
    }

    public boolean hasBossBar(Player player) {
        return this.bossBars.containsKey(player.getUniqueId());
    }

    public BossBar getBossBar(Player player) {
        return this.bossBars.get(player.getUniqueId());
    }

    private void createBossBars(final Player player, Component displayText, float progress) {
        if (this.hasBossBar(player)) {
            return;
        }
        BossBar bossBar = BossBar.bossBar((Component)displayText, (float)progress, (BossBar.Color)BossBar.Color.RED, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        this.bossBars.put(player.getUniqueId(), bossBar);
        player.showBossBar(bossBar);
        new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                BossBarController.this.removeBossBar(player);
            }
        }.runDelayed(600L);
    }

    public void updateBossBar(Player player, Component text, float progress) {
        if (!this.hasBossBar(player)) {
            this.createBossBars(player, text, progress);
        } else {
            this.bossBars.replace(player.getUniqueId(), this.getBossBar(player).name(text).progress(progress));
        }
        player.showBossBar(this.getBossBar(player));
    }

    public void updateBossBar(Player player, String text, float progress) {
        this.updateBossBar(player, (Component)ColorUtils.legacyTranslateColourCodes(text), progress);
    }

    public void updateBossBarGradually(Player player, String text, float progress, int intervals) {
        TextComponent newText = ColorUtils.legacyTranslateColourCodes(text);
        if (!this.hasBossBar(player)) {
            this.createBossBars(player, (Component)newText, progress);
        } else {
            BossBar bossBar = this.getBossBar(player).name((Component)newText);
            float from = bossBar.progress();
            float difference = (progress - from) / (float)intervals;
            if (from != progress) {
                for (int i = 0; i < intervals && !((from += difference) > 1.0f) && !(from < 0.0f); ++i) {
                    bossBar.progress(from);
                }
            }
            bossBar.progress(progress);
            this.bossBars.replace(player.getUniqueId(), bossBar);
        }
        player.showBossBar(this.getBossBar(player));
    }

    public void removeBossBar(Player player) {
        if (!this.hasBossBar(player)) {
            return;
        }
        player.hideBossBar(this.getBossBar(player));
        this.bossBars.remove(player.getUniqueId());
    }

    public void removeAllBossBars() {
        if (this.bossBars.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, BossBar> entry : this.bossBars.entrySet()) {
            Player player = this.plugin.getServer().getPlayer(entry.getKey());
            assert (player != null);
            player.hideBossBar(entry.getValue());
        }
        this.bossBars.clear();
    }
}

