/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.utils;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.managers.WingsManager;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.support.interfaces.claims.WorldGuardVersion;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WingsUtils {
    @NotNull
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private static final Server server = plugin.getServer();
    @NotNull
    private static final Starter starter = plugin.getStarter();
    private static final EnchantmentBookSettings settings = starter.getEnchantmentBookSettings();
    @NotNull
    private static final PluginSupport pluginSupport = starter.getPluginSupport();
    @NotNull
    private static final WingsManager wingsManager = starter.getWingsManager();

    public static void startWings() {
        if (!wingsManager.isWingsEnabled()) {
            wingsManager.endWingsTask();
        }
        wingsManager.setWingsTask(new FoliaScheduler((JavaPlugin)plugin, Scheduler.async_scheduler, TimeUnit.MILLISECONDS){

            @Override
            public void run() {
                for (UUID uuid : wingsManager.getFlyingPlayers()) {
                    final Player player = server.getPlayer(uuid);
                    if (player == null) {
                        return;
                    }
                    new FoliaScheduler(this, plugin, null, (Entity)player){

                        @Override
                        public void run() {
                            if (player.isFlying() && player.getEquipment().getBoots() != null && settings.getEnchantments(player.getEquipment().getBoots()).containsKey(CEnchantments.WINGS.getEnchantment())) {
                                Location location = player.getLocation().subtract(0.0, 0.25, 0.0);
                                if (wingsManager.isCloudsEnabled()) {
                                    player.getWorld().spawnParticle(Particle.CLOUD, location, 100, 0.25, 0.0, 0.25, 0.0);
                                }
                            }
                        }
                    }.runNextTick();
                }
            }
        }.runAtFixedRate(50L, 50L));
    }

    public static void checkArmor(ItemStack newArmorPiece, boolean newArmor, ItemStack oldArmorPiece, Player player) {
        CEnchantments wings = CEnchantments.WINGS;
        if (newArmor) {
            if (starter.getEnchantmentBookSettings().getEnchantments(newArmorPiece).containsKey(wings.getEnchantment()) && WingsUtils.checkRegion(player) && WingsUtils.checkGameMode(player)) {
                player.setAllowFlight(true);
            }
            return;
        }
        if (starter.getEnchantmentBookSettings().getEnchantments(oldArmorPiece).containsKey(wings.getEnchantment()) && WingsUtils.checkGameMode(player)) {
            player.setAllowFlight(false);
        }
    }

    public static boolean checkGameMode(Player player) {
        return player.getGameMode() == GameMode.SURVIVAL;
    }

    private static boolean inWingsRegion(Player player) {
        if (!PluginSupport.SupportedPlugins.WORLDGUARD.isPluginLoaded()) {
            return true;
        }
        WorldGuardVersion worldGuardVersion = starter.getPluginSupport().getWorldGuardUtils().getWorldGuardSupport();
        for (String region : wingsManager.getRegions()) {
            if (worldGuardVersion.inRegion(region, player.getLocation())) {
                return true;
            }
            if (wingsManager.canOwnersFly() && worldGuardVersion.isOwner(player)) {
                return true;
            }
            if (!wingsManager.canMembersFly() || !worldGuardVersion.isMember(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRegion(Player player) {
        return wingsManager.inLimitlessFlightWorld(player) || !wingsManager.inBlacklistedWorld(player) && (pluginSupport.inTerritory(player) || WingsUtils.inWingsRegion(player) || wingsManager.inWhitelistedWorld(player));
    }

    public static boolean isEnemiesNearby(Player player) {
        if (wingsManager.isEnemyCheckEnabled() && !wingsManager.inLimitlessFlightWorld(player)) {
            for (Player otherPlayer : WingsUtils.getNearbyPlayers(player, wingsManager.getEnemyRadius())) {
                if (player.hasPermission("crazyenchantments.bypass.wings") && pluginSupport.isFriendly((Entity)player, (Entity)otherPlayer)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<Player> getNearbyPlayers(Player player, int radius) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(entity instanceof Player)) continue;
            players.add((Player)entity);
        }
        return players;
    }
}

