/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.utils;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.events.EnchantmentUseEvent;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class EnchantUtils {
    @NotNull
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);

    public static Category getHighestEnchantmentCategory(CEnchantment enchantment) {
        Category topCategory = null;
        int rarity = 0;
        for (Category category : enchantment.getCategories()) {
            if (category.getRarity() < rarity) continue;
            rarity = category.getRarity();
            topCategory = category;
        }
        return topCategory;
    }

    public static boolean isEventActive(CEnchantments enchant, Entity damager, ItemStack item, Map<CEnchantment, Integer> enchants) {
        return EnchantUtils.isEventActive(enchant, damager, item, enchants, 1.0);
    }

    public static boolean isEventActive(CEnchantments enchant, Entity damager, ItemStack item, Map<CEnchantment, Integer> enchants, double multiplier) {
        return EnchantUtils.isActive((Player)damager, enchant, enchants, multiplier) && EnchantUtils.normalEnchantEvent(enchant, damager, item);
    }

    public static boolean isMassBlockBreakActive(Player player, CEnchantments enchant, Map<CEnchantment, Integer> enchants) {
        return EnchantUtils.isActive(player, enchant, enchants, 1.0);
    }

    private static boolean isActive(Player player, CEnchantments enchant, Map<CEnchantment, Integer> enchants) {
        return EnchantUtils.isActive(player, enchant, enchants, 1.0);
    }

    private static boolean isActive(Player player, CEnchantments enchant, Map<CEnchantment, Integer> enchants, double multiplier) {
        return enchants.containsKey(enchant.getEnchantment()) && (player.isOp() || (!enchant.hasChanceSystem() || enchant.chanceSuccessful(enchants.get(enchant.getEnchantment()), multiplier)) && !player.hasPermission("crazyenchantments.%s.deny".formatted(enchant.getName())));
    }

    public static boolean normalEnchantEvent(CEnchantments enchant, Entity damager, ItemStack item) {
        EnchantmentUseEvent useEvent = new EnchantmentUseEvent((Player)damager, enchant.getEnchantment(), item);
        plugin.getServer().getPluginManager().callEvent((Event)useEvent);
        return !useEvent.isCancelled();
    }

    public static boolean isAuraActive(Player player, CEnchantments enchant, Map<CEnchantment, Integer> enchants) {
        if (plugin.getStarter().getCrazyManager().getCEPlayer(player.getUniqueId()).onEnchantCooldown(enchant, 60)) {
            return false;
        }
        return EnchantUtils.isActive(player, enchant, enchants);
    }

    public static boolean isArmorEventActive(Player player, CEnchantments enchant, ItemStack item) {
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission("crazyenchantments.%s.deny".formatted(enchant.getName()))) {
            return false;
        }
        return EnchantUtils.normalEnchantEvent(enchant, (Entity)player, item);
    }

    public static boolean isMoveEventActive(CEnchantments enchant, Player player, Map<CEnchantment, Integer> enchants) {
        if (!EnchantUtils.isActive(player, enchant, enchants)) {
            return false;
        }
        return !plugin.getStarter().getCrazyManager().getCEPlayer(player.getUniqueId()).onEnchantCooldown(enchant, 20);
    }
}

