/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.utils;

import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ColorUtils {
    public static void color(List<Color> colors, String colorString) {
        if (colorString.contains(", ")) {
            for (String key : colorString.split(", ")) {
                Color color = ColorUtils.getColor(key);
                if (color == null) continue;
                colors.add(color);
            }
        } else {
            Color color = ColorUtils.getColor(colorString);
            if (color != null) {
                colors.add(color);
            }
        }
    }

    public static Color getColor(String color) {
        return switch (color.toUpperCase()) {
            case "AQUA" -> Color.AQUA;
            case "BLACK" -> Color.BLACK;
            case "BLUE" -> Color.BLUE;
            case "FUCHSIA" -> Color.FUCHSIA;
            case "GRAY" -> Color.GRAY;
            case "GREEN" -> Color.GREEN;
            case "LIME" -> Color.LIME;
            case "MAROON" -> Color.MAROON;
            case "NAVY" -> Color.NAVY;
            case "OLIVE" -> Color.OLIVE;
            case "ORANGE" -> Color.ORANGE;
            case "PURPLE" -> Color.PURPLE;
            case "RED" -> Color.RED;
            case "SILVER" -> Color.SILVER;
            case "TEAL" -> Color.TEAL;
            case "YELLOW" -> Color.YELLOW;
            default -> Color.WHITE;
        };
    }

    public static String color(String message) {
        Matcher matcher = Pattern.compile("#[a-fA-F\\d]{6}").matcher(message);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)matcher.group()).toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    public static void sendMessage(CommandSender commandSender, String message, boolean prefixToggle) {
        if (message == null || message.isEmpty()) {
            return;
        }
        String prefix = ColorUtils.getPrefix();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (!prefix.isEmpty() && prefixToggle) {
                player.sendMessage(ColorUtils.color(message.replaceAll("%prefix%", Matcher.quoteReplacement(prefix))).replaceAll("%Prefix%", Matcher.quoteReplacement(prefix)));
            } else {
                player.sendMessage(ColorUtils.color(message));
            }
            return;
        }
        if (!prefix.isEmpty() && prefixToggle) {
            commandSender.sendMessage(ColorUtils.color(message.replaceAll("%prefix%", Matcher.quoteReplacement(prefix))).replaceAll("%Prefix%", Matcher.quoteReplacement(prefix)));
        } else {
            commandSender.sendMessage(ColorUtils.color(message));
        }
    }

    public static String getPrefix() {
        return ColorUtils.color(FileManager.Files.CONFIG.getFile().getString("Settings.Prefix"));
    }

    public static String getPrefix(String msg) {
        return ColorUtils.color(ColorUtils.getPrefix() + msg);
    }

    public static String sanitizeColor(String msg) {
        return ColorUtils.sanitizeFormat(ColorUtils.color(msg));
    }

    public static String sanitizeFormat(String string) {
        return net.md_5.bungee.api.chat.TextComponent.toLegacyText((BaseComponent[])net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)string));
    }

    public static String removeColor(String msg) {
        return ChatColor.stripColor((String)msg);
    }

    public static TextComponent legacyTranslateColourCodes(String input) {
        return (TextComponent)LegacyComponentSerializer.legacyAmpersand().deserialize(input).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static String toLegacy(Component text) {
        return LegacyComponentSerializer.legacyAmpersand().serialize(text).replaceAll("\u00a7", "&").replaceAll("&&", "&");
    }

    public static String toPlainText(Component text) {
        return PlainTextComponentSerializer.plainText().serialize(text);
    }

    public static ItemBuilder getRandomPaneColor() {
        Random random = new Random();
        List<String> colors = Arrays.asList("WHITE_STAINED_GLASS_PANE", "ORANGE_STAINED_GLASS_PANE", "MAGENTA_STAINED_GLASS_PANE", "LIGHT_BLUE_STAINED_GLASS_PANE", "YELLOW_STAINED_GLASS_PANE", "LIME_STAINED_GLASS_PANE", "PINK_STAINED_GLASS_PANE", "GRAY_STAINED_GLASS_PANE", "CYAN_STAINED_GLASS_PANE", "PURPLE_STAINED_GLASS_PANE", "BLUE_STAINED_GLASS_PANE", "BROWN_STAINED_GLASS_PANE", "GREEN_STAINED_GLASS_PANE", "RED_STAINED_GLASS_PANE", "BLACK_STAINED_GLASS_PANE");
        return new ItemBuilder().setMaterial(colors.get(random.nextInt(colors.size())));
    }

    public static String stripStringColour(String s) {
        return s.replaceAll("([&\u00a7]?#[0-9a-fA-F]{6}|[&\u00a7][1-9a-fA-Fk-or])", "");
    }
}

