/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.objects.gkitz;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GKitzItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class GKitz {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final CrazyManager crazyManager = this.plugin.getStarter().getCrazyManager();
    private final int slot;
    private final String name;
    private final String cooldown;
    private final boolean autoEquip;
    private final ItemStack displayItem;
    private final List<String> commands;
    private final List<ItemStack> preview;
    private final List<String> itemStrings;

    public GKitz(String name, int slot, String cooldown, ItemStack displayItem, List<ItemStack> preview, List<String> commands, List<String> itemStrings, boolean autoEquip) {
        this.name = name;
        this.slot = slot;
        this.preview = preview;
        this.cooldown = cooldown;
        this.commands = commands;
        this.autoEquip = autoEquip;
        this.displayItem = displayItem;
        this.itemStrings = itemStrings;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getCooldown() {
        return this.cooldown;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public List<ItemStack> getPreviewItems() {
        return this.preview;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getItemStrings() {
        return this.itemStrings;
    }

    public boolean canAutoEquip() {
        return this.autoEquip;
    }

    public List<ItemStack> getKitItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String itemString : this.itemStrings) {
            itemString = this.crazyManager.getNewItemString(itemString);
            GKitzItem item = new GKitzItem(ItemBuilder.convertString(itemString));
            for (String option : itemString.split(", ")) {
                try {
                    CEnchantment enchantment = this.crazyManager.getEnchantmentFromName(option.split(":")[0]);
                    String level = option.split(":")[1];
                    if (enchantment == null) continue;
                    if (level.contains("-")) {
                        int randomLevel = this.crazyManager.pickLevel(Integer.parseInt(level.split("-")[0]), Integer.parseInt(level.split("-")[1]));
                        if (randomLevel <= 0) continue;
                        item.addCEEnchantment(enchantment, randomLevel);
                        continue;
                    }
                    item.addCEEnchantment(enchantment, Integer.parseInt(level));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            items.add(item.build());
        }
        return items;
    }
}

