/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.objects;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GKitz;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GkitCoolDown;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CEPlayer {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Server server = this.plugin.getServer();
    @NotNull
    private final Methods methods = this.plugin.getStarter().getMethods();
    private final Player player;
    private final List<GkitCoolDown> gkitCoolDowns;
    private Double rageMultiplier;
    private boolean hasRage;
    private int rageLevel;
    private ScheduledTask rageTask;
    private final Set<CEnchantments> onCooldown = new HashSet<CEnchantments>();

    public CEPlayer(Player player, List<GkitCoolDown> gkitCoolDowns) {
        this.player = player;
        this.gkitCoolDowns = gkitCoolDowns;
        this.hasRage = false;
        this.rageLevel = 0;
        this.rageMultiplier = 0.0;
        this.rageTask = null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void giveGKit(final GKitz kit) {
        block12: for (ItemStack item : kit.getKitItems()) {
            if (kit.canAutoEquip()) {
                switch (item.getType().toString().contains("_") ? item.getType().toString().toLowerCase().split("_")[1] : "No") {
                    case "helmet": {
                        if (this.player.getEquipment().getHelmet() != null) break;
                        this.player.getEquipment().setHelmet(item);
                        continue block12;
                    }
                    case "chestplate": {
                        if (this.player.getEquipment().getChestplate() != null) break;
                        this.player.getEquipment().setChestplate(item);
                        continue block12;
                    }
                    case "leggings": {
                        if (this.player.getEquipment().getLeggings() != null) break;
                        this.player.getEquipment().setLeggings(item);
                        continue block12;
                    }
                    case "boots": {
                        if (this.player.getEquipment().getBoots() != null) break;
                        this.player.getEquipment().setBoots(item);
                        continue block12;
                    }
                }
            }
            this.methods.addItemToInventory(this.player, item);
        }
        new FoliaScheduler(this.plugin, Scheduler.global_scheduler){

            @Override
            public void run() {
                String name = CEPlayer.this.player.getName();
                ConsoleCommandSender sender = CEPlayer.this.server.getConsoleSender();
                for (String cmd : kit.getCommands()) {
                    CEPlayer.this.server.dispatchCommand((CommandSender)sender, cmd.replace("%Player%", name).replace("%player%", name));
                }
            }
        }.runNow();
    }

    public boolean hasGkitPermission(GKitz kit) {
        return this.player.hasPermission("crazyenchantments.bypass.gkitz") || this.player.hasPermission("crazyenchantments.gkitz." + kit.getName().toLowerCase());
    }

    public boolean canUseGKit(GKitz kit) {
        if (this.player.hasPermission("crazyenchantments.bypass.gkitz")) {
            return true;
        }
        if (this.player.hasPermission("crazyenchantments.gkitz." + kit.getName().toLowerCase())) {
            for (GkitCoolDown gkitCooldown : this.getCoolDowns()) {
                if (gkitCooldown.getGKitz() != kit) continue;
                return gkitCooldown.isCoolDownOver();
            }
        } else {
            return false;
        }
        return true;
    }

    public List<GkitCoolDown> getCoolDowns() {
        return this.gkitCoolDowns;
    }

    public GkitCoolDown getCoolDown(GKitz kit) {
        for (GkitCoolDown gkitCoolDown : this.gkitCoolDowns) {
            if (gkitCoolDown.getGKitz() != kit) continue;
            return gkitCoolDown;
        }
        return null;
    }

    public void addCoolDown(GkitCoolDown gkitCoolDown) {
        ArrayList<GkitCoolDown> playerGkitCoolDowns = new ArrayList<GkitCoolDown>();
        for (GkitCoolDown c : this.getCoolDowns()) {
            if (!c.getGKitz().getName().equalsIgnoreCase(gkitCoolDown.getGKitz().getName())) continue;
            playerGkitCoolDowns.add(c);
        }
        this.gkitCoolDowns.removeAll(playerGkitCoolDowns);
        this.gkitCoolDowns.add(gkitCoolDown);
    }

    public void addCoolDown(GKitz kit) {
        Calendar coolDown = Calendar.getInstance();
        for (String i : kit.getCooldown().toLowerCase().split(" ")) {
            if (i.contains("d")) {
                coolDown.add(5, Integer.parseInt(i.replace("d", "")));
            }
            if (i.contains("h")) {
                coolDown.add(10, Integer.parseInt(i.replace("h", "")));
            }
            if (i.contains("m")) {
                coolDown.add(12, Integer.parseInt(i.replace("m", "")));
            }
            if (!i.contains("s")) continue;
            coolDown.add(13, Integer.parseInt(i.replace("s", "")));
        }
        this.addCoolDown(new GkitCoolDown(kit, coolDown));
    }

    public void removeCoolDown(GkitCoolDown gkitCoolDown) {
        this.gkitCoolDowns.remove(gkitCoolDown);
    }

    public void removeCoolDown(GKitz kit) {
        ArrayList<GkitCoolDown> playerGkitCoolDowns = new ArrayList<GkitCoolDown>();
        for (GkitCoolDown gkitCoolDown : this.getCoolDowns()) {
            if (!gkitCoolDown.getGKitz().getName().equalsIgnoreCase(kit.getName())) continue;
            playerGkitCoolDowns.add(gkitCoolDown);
        }
        this.gkitCoolDowns.removeAll(playerGkitCoolDowns);
    }

    public Double getRageMultiplier() {
        return this.rageMultiplier;
    }

    public void setRageMultiplier(Double rageMultiplier) {
        this.rageMultiplier = rageMultiplier;
    }

    public boolean hasRage() {
        return this.hasRage;
    }

    public void setRage(boolean hasRage) {
        this.hasRage = hasRage;
    }

    public int getRageLevel() {
        return this.rageLevel;
    }

    public void setRageLevel(int rageLevel) {
        this.rageLevel = rageLevel;
    }

    public ScheduledTask getRageTask() {
        return this.rageTask;
    }

    public void setRageTask(ScheduledTask rageTask) {
        this.rageTask = rageTask;
    }

    public boolean onEnchantCooldown(final CEnchantments enchant, int delay) {
        if (this.onCooldown.contains((Object)enchant)) {
            return true;
        }
        this.onCooldown.add(enchant);
        new FoliaScheduler(this.plugin, Scheduler.async_scheduler, TimeUnit.MILLISECONDS){

            @Override
            public void run() {
                CEPlayer.this.onCooldown.remove((Object)enchant);
            }
        }.runDelayed((long)delay * 50L);
        return false;
    }
}

