/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.objects;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.EnchantedBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CEBook {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private CEnchantment enchantment;
    private int amount;
    private int level;
    private boolean glowing;
    private int destroyRate;
    private int successRate;

    public CEBook(CEnchantment enchantment) {
        this(enchantment, 1, 1);
    }

    public CEBook(CEnchantment enchantment, int level) {
        this(enchantment, level, 1);
    }

    public CEBook(CEnchantment enchantment, int level, int amount) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.glowing = config.getBoolean("Settings.Enchantment-Book-Glowing", true);
        int successMax = config.getInt("Settings.BlackScroll.SuccessChance.Max", 100);
        int successMin = config.getInt("Settings.BlackScroll.SuccessChance.Min", 15);
        int destroyMax = config.getInt("Settings.BlackScroll.DestroyChance.Max", 100);
        int destroyMin = config.getInt("Settings.BlackScroll.DestroyChance.Min", 15);
        this.destroyRate = this.methods.percentPick(destroyMax, destroyMin);
        this.successRate = this.methods.percentPick(successMax, successMin);
    }

    public CEBook(CEnchantment enchantment, int level, Category category) {
        this(enchantment, level, 1, category);
    }

    public CEBook(CEnchantment enchantment, int level, int amount, Category category) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        this.glowing = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Enchantment-Book-Glowing", true);
        this.destroyRate = this.methods.percentPick(category.getMaxDestroyRate(), category.getMinDestroyRate());
        this.successRate = this.methods.percentPick(category.getMaxSuccessRate(), category.getMinSuccessRate());
    }

    public CEBook(CEnchantment enchantment, int level, int amount, int destroyRate, int successRate) {
        this.enchantment = enchantment;
        this.amount = amount;
        this.level = level;
        this.glowing = FileManager.Files.CONFIG.getFile().getBoolean("Settings.Enchantment-Book-Glowing", true);
        this.destroyRate = destroyRate;
        this.successRate = successRate;
    }

    public CEnchantment getEnchantment() {
        return this.enchantment;
    }

    public CEBook setEnchantment(CEnchantment enchantment) {
        this.enchantment = enchantment;
        return this;
    }

    public boolean getGlowing() {
        return this.glowing;
    }

    public CEBook setGlowing(boolean toggle) {
        this.glowing = toggle;
        return this;
    }

    public int getAmount() {
        return this.amount;
    }

    public CEBook setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public CEBook setLevel(int level) {
        this.level = level;
        return this;
    }

    public int getDestroyRate() {
        return this.starter.getCrazyManager().getCEFailureOverride() == -1 ? this.destroyRate : this.starter.getCrazyManager().getCEFailureOverride();
    }

    public CEBook setDestroyRate(int destroyRate) {
        this.destroyRate = destroyRate;
        return this;
    }

    public int getSuccessRate() {
        return this.starter.getCrazyManager().getCESuccessOverride() == -1 ? this.successRate : this.starter.getCrazyManager().getCESuccessOverride();
    }

    public CEBook setSuccessRate(int successRate) {
        this.successRate = successRate;
        return this;
    }

    public ItemBuilder getItemBuilder() {
        String name = this.enchantment.getCustomName() + " " + NumberUtils.convertLevelString(this.level);
        ArrayList<String> lore = new ArrayList<String>();
        for (String bookLine : FileManager.Files.CONFIG.getFile().getStringList("Settings.EnchantmentBookLore")) {
            if (bookLine.contains("%Description%") || bookLine.contains("%description%")) {
                for (String enchantmentLine : this.enchantment.getInfoDescription()) {
                    lore.add(ColorUtils.color(enchantmentLine));
                }
                continue;
            }
            lore.add(ColorUtils.color(bookLine).replace("%Destroy_Rate%", String.valueOf(this.destroyRate)).replace("%destroy_rate%", String.valueOf(this.destroyRate)).replace("%Success_Rate%", String.valueOf(this.successRate)).replace("%success_rate%", String.valueOf(this.successRate)));
        }
        return this.enchantmentBookSettings.getNormalBook().setAmount(this.amount).setName(name).setLore(lore).setGlow(this.glowing);
    }

    public ItemStack buildBook() {
        return this.getItemBuilder().addKey(DataKeys.stored_enchantments.getNamespacedKey(), Methods.getGson().toJson((Object)new EnchantedBook(this.enchantment.getName(), this.successRate, this.destroyRate, this.level), (Type)((Object)EnchantedBook.class))).build();
    }

    public boolean roleSuccess() {
        return this.methods.randomPicker(this.getSuccessRate(), 100);
    }

    public boolean roleDestroy() {
        return this.methods.randomPicker(this.getDestroyRate(), 100);
    }
}

