/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.managers;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.ShopOption;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.LostBook;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ShopManager {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private String inventoryName;
    private int inventorySize;
    private boolean enchantmentTableShop;
    private final Map<ItemBuilder, Integer> customizerItems = new HashMap<ItemBuilder, Integer>();
    private final Map<ItemBuilder, Integer> shopItems = new HashMap<ItemBuilder, Integer>();

    public void load() {
        this.customizerItems.clear();
        this.shopItems.clear();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        this.inventoryName = ColorUtils.color(config.getString("Settings.InvName"));
        this.inventorySize = config.getInt("Settings.GUISize");
        this.enchantmentTableShop = config.getBoolean("Settings.EnchantmentOptions.Right-Click-Enchantment-Table");
        for (String customItemString : config.getStringList("Settings.GUICustomization")) {
            int slot = 0;
            for (String option : customItemString.split(", ")) {
                if (!option.contains("Slot:")) continue;
                option = option.replace("Slot:", "");
                slot = Integer.parseInt(option);
                break;
            }
            if (slot > this.inventorySize || slot <= 0) continue;
            this.customizerItems.put(ItemBuilder.convertString(customItemString), --slot);
        }
        for (Category category : this.enchantmentBookSettings.getCategories()) {
            LostBook lostBook;
            if (category.isInGUI()) {
                if (category.getSlot() > this.inventorySize) continue;
                this.shopItems.put(category.getDisplayItem(), category.getSlot());
            }
            if (!(lostBook = category.getLostBook()).isInGUI() || lostBook.getSlot() > this.inventorySize) continue;
            this.shopItems.put(lostBook.getDisplayItem(), lostBook.getSlot());
        }
        for (Iterator<Object> iterator : ShopOption.values()) {
            if (!((ShopOption)((Object)iterator)).isInGUI() || ((ShopOption)((Object)iterator)).getSlot() > this.inventorySize) continue;
            this.shopItems.put(((ShopOption)((Object)iterator)).getItemBuilder(), ((ShopOption)((Object)iterator)).getSlot());
        }
    }

    public Map<ItemBuilder, Integer> getShopItems() {
        return Collections.unmodifiableMap(this.shopItems);
    }

    public Map<ItemBuilder, Integer> getCustomizerItems() {
        return Collections.unmodifiableMap(this.customizerItems);
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public boolean isEnchantmentTableShop() {
        return this.enchantmentTableShop;
    }
}

