/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.builders;

import com.nexomc.nexo.api.NexoItems;
import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.enums.ItemState;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.core.api.support.ModSupport;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.builders.types.PatternBuilder;
import com.ryderbelserion.fusion.paper.builders.types.PotionBuilder;
import com.ryderbelserion.fusion.paper.builders.types.SkullBuilder;
import com.ryderbelserion.fusion.paper.builders.types.SpawnerBuilder;
import com.ryderbelserion.fusion.paper.builders.types.custom.CustomBuilder;
import com.ryderbelserion.fusion.paper.builders.types.fireworks.FireworkBuilder;
import com.ryderbelserion.fusion.paper.builders.types.fireworks.FireworkStarBuilder;
import com.ryderbelserion.fusion.paper.builders.types.tools.ToolBuilder;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import com.ryderbelserion.fusion.paper.utils.ItemUtils;
import dev.lone.itemsadder.api.CustomStack;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.MapItemColor;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.persistence.PersistentDataContainerView;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public abstract class BaseItemBuilder<B extends BaseItemBuilder<B>> {
    private static final Set<String> armor = new HashSet<String>(){
        {
            this.add(ItemType.CHAINMAIL_HELMET.key().asString());
            this.add(ItemType.CHAINMAIL_CHESTPLATE.key().asString());
            this.add(ItemType.CHAINMAIL_LEGGINGS.key().asString());
            this.add(ItemType.CHAINMAIL_BOOTS.key().asString());
            this.add(ItemType.IRON_HELMET.key().asString());
            this.add(ItemType.IRON_CHESTPLATE.key().asString());
            this.add(ItemType.IRON_LEGGINGS.key().asString());
            this.add(ItemType.IRON_BOOTS.key().asString());
            this.add(ItemType.DIAMOND_HELMET.key().asString());
            this.add(ItemType.DIAMOND_CHESTPLATE.key().asString());
            this.add(ItemType.DIAMOND_LEGGINGS.key().asString());
            this.add(ItemType.DIAMOND_BOOTS.key().asString());
            this.add(ItemType.GOLDEN_HELMET.key().asString());
            this.add(ItemType.GOLDEN_CHESTPLATE.key().asString());
            this.add(ItemType.GOLDEN_LEGGINGS.key().asString());
            this.add(ItemType.GOLDEN_BOOTS.key().asString());
            this.add(ItemType.NETHERITE_HELMET.key().asString());
            this.add(ItemType.NETHERITE_CHESTPLATE.key().asString());
            this.add(ItemType.NETHERITE_LEGGINGS.key().asString());
            this.add(ItemType.NETHERITE_BOOTS.key().asString());
            this.add(ItemType.TURTLE_HELMET.key().asString());
            this.addAll(leather_items);
        }
    };
    private static final Set<String> tools = new HashSet<String>(){
        {
            this.add(ItemType.WOODEN_SWORD.key().asString());
            this.add(ItemType.WOODEN_PICKAXE.key().asString());
            this.add(ItemType.WOODEN_AXE.key().asString());
            this.add(ItemType.WOODEN_HOE.key().asString());
            this.add(ItemType.WOODEN_SHOVEL.key().asString());
            this.add(ItemType.STONE_SWORD.key().asString());
            this.add(ItemType.STONE_PICKAXE.key().asString());
            this.add(ItemType.STONE_AXE.key().asString());
            this.add(ItemType.STONE_HOE.key().asString());
            this.add(ItemType.STONE_SHOVEL.key().asString());
            this.add(ItemType.IRON_SWORD.key().asString());
            this.add(ItemType.IRON_PICKAXE.key().asString());
            this.add(ItemType.IRON_AXE.key().asString());
            this.add(ItemType.IRON_HOE.key().asString());
            this.add(ItemType.IRON_SHOVEL.key().asString());
            this.add(ItemType.DIAMOND_SWORD.key().asString());
            this.add(ItemType.DIAMOND_PICKAXE.key().asString());
            this.add(ItemType.DIAMOND_AXE.key().asString());
            this.add(ItemType.DIAMOND_HOE.key().asString());
            this.add(ItemType.DIAMOND_SHOVEL.key().asString());
            this.add(ItemType.GOLDEN_SWORD.key().asString());
            this.add(ItemType.GOLDEN_PICKAXE.key().asString());
            this.add(ItemType.GOLDEN_AXE.key().asString());
            this.add(ItemType.GOLDEN_HOE.key().asString());
            this.add(ItemType.GOLDEN_SHOVEL.key().asString());
            this.add(ItemType.NETHERITE_SWORD.key().asString());
            this.add(ItemType.NETHERITE_PICKAXE.key().asString());
            this.add(ItemType.NETHERITE_AXE.key().asString());
            this.add(ItemType.NETHERITE_HOE.key().asString());
            this.add(ItemType.NETHERITE_SHOVEL.key().asString());
        }
    };
    private static final Set<String> leather_items = new HashSet<String>(){
        {
            this.add(ItemType.LEATHER_HELMET.key().asString());
            this.add(ItemType.LEATHER_CHESTPLATE.key().asString());
            this.add(ItemType.LEATHER_LEGGINGS.key().asString());
            this.add(ItemType.LEATHER_BOOTS.key().asString());
            this.add(ItemType.LEATHER_HORSE_ARMOR.key().asString());
        }
    };
    private static final Set<String> potions = new HashSet<String>(){
        {
            this.add(ItemType.POTION.key().asString());
            this.add(ItemType.SPLASH_POTION.key().asString());
            this.add(ItemType.LINGERING_POTION.key().asString());
        }
    };
    protected final FusionPaper fusion = (FusionPaper)FusionProvider.getInstance();
    protected ItemStack itemStack;
    protected ItemType itemType;
    private DataComponentType.Valued<Component> type = DataComponentTypes.ITEM_NAME;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private List<String> displayLore = new ArrayList<String>();
    private String displayName = "";

    public BaseItemBuilder(@NotNull ItemType itemType, int amount, @NotNull Consumer<BaseItemBuilder> consumer) {
        this.itemStack = itemType.createItemStack(Math.min(amount, 1));
        this.itemType = itemType;
        consumer.accept(this);
    }

    public BaseItemBuilder(@NotNull ItemType itemType, @NotNull Consumer<BaseItemBuilder> consumer) {
        this(itemType, 1, consumer);
    }

    public BaseItemBuilder(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemType = this.itemStack.getType().asItemType();
    }

    public BaseItemBuilder(@NotNull String itemStack) {
        this.setItem(itemStack);
    }

    public B build() {
        return (B)this;
    }

    @NotNull
    public ItemStack asItemStack(@NotNull Audience audience) {
        List<String> lore;
        if (!this.displayName.isEmpty()) {
            this.itemStack.setData(this.type, (Object)this.fusion.parse(audience, this.displayName, this.placeholders));
        }
        if (!(lore = this.displayLore).isEmpty()) {
            ArrayList components = new ArrayList(lore.size());
            lore.forEach(line -> components.add(this.fusion.parse(audience, (String)line, this.placeholders)));
            this.itemStack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(components));
        }
        this.build();
        return this.itemStack;
    }

    @NotNull
    public ItemStack asItemStack() {
        return this.asItemStack(Audience.empty());
    }

    @NotNull
    public B withDisplayName(@NotNull String displayName, @NotNull ItemState itemState) {
        this.displayName = displayName;
        this.type = switch (itemState) {
            default -> throw new MatchException(null, null);
            case ItemState.ITEM_NAME -> DataComponentTypes.ITEM_NAME;
            case ItemState.CUSTOM_NAME -> DataComponentTypes.CUSTOM_NAME;
        };
        return (B)this;
    }

    @NotNull
    public B withDisplayName(@NotNull String displayName) {
        return this.withDisplayName(displayName, ItemState.ITEM_NAME);
    }

    @NotNull
    public B withDisplayLore(@NotNull List<String> displayLore) {
        this.displayLore = displayLore;
        return (B)this;
    }

    @NotNull
    public B addDisplayLore(@NotNull String displayLore) {
        if (displayLore.isEmpty()) {
            return (B)this;
        }
        this.displayLore.add(displayLore);
        return (B)this;
    }

    @NotNull
    public B withCustomItem(@NotNull String itemStack) {
        String plugin = this.fusion.getConfig().getItemsPlugin();
        switch (plugin.toLowerCase()) {
            case "nexo": {
                if (this.fusion.isModReady(ModSupport.nexo)) {
                    this.getNexo(itemStack);
                    return (B)this;
                }
                this.setItem(itemStack);
                break;
            }
            case "oraxen": {
                if (this.fusion.isModReady(ModSupport.oraxen)) {
                    this.getOraxen(itemStack);
                    return (B)this;
                }
                this.setItem(itemStack);
                break;
            }
            case "itemsadder": {
                if (this.fusion.isModReady(ModSupport.items_adder)) {
                    this.getItemsAdder(itemStack);
                    return (B)this;
                }
                this.setItem(itemStack);
                break;
            }
            case "none": {
                this.setItem(itemStack);
                break;
            }
            default: {
                if (this.fusion.isModReady(ModSupport.nexo)) {
                    this.getNexo(itemStack);
                    return (B)this;
                }
                if (this.fusion.isModReady(ModSupport.items_adder)) {
                    this.getItemsAdder(itemStack);
                    return (B)this;
                }
                if (this.fusion.isModReady(ModSupport.oraxen)) {
                    this.getOraxen(itemStack);
                    return (B)this;
                }
                this.setItem(itemStack);
            }
        }
        return (B)this;
    }

    @NotNull
    public B withBase64(@NotNull String itemStack) {
        if (itemStack.isEmpty()) {
            return (B)this;
        }
        try {
            this.itemStack = ItemUtils.fromBase64(itemStack);
        }
        catch (Exception exception) {
            ItemType.Typed stone = ItemType.STONE;
            this.itemStack = stone.createItemStack();
            this.itemType = stone;
        }
        this.itemType = this.itemStack.getType().asItemType();
        return (B)this;
    }

    @NotNull
    public B withType(@NotNull ItemType itemType, int amount) {
        ItemStack itemStack = itemType.createItemStack(Math.max(amount, 1));
        this.itemStack = this.itemStack == null ? itemStack : this.itemStack.withType(itemStack.getType());
        this.itemStack.setAmount(itemStack.getAmount());
        this.itemType = itemType;
        return (B)this;
    }

    @NotNull
    public B withType(@NotNull ItemType itemType) {
        return this.withType(itemType, 1);
    }

    @NotNull
    public B addFoodComponent(@NotNull Consumer<FoodProperties.Builder> consumer) {
        if (!this.itemStack.hasData((DataComponentType)DataComponentTypes.CONSUMABLE)) {
            return (B)this;
        }
        FoodProperties.Builder foodProperties = FoodProperties.food();
        consumer.accept(foodProperties);
        this.itemStack.setData(DataComponentTypes.FOOD, (DataComponentBuilder)foodProperties);
        return (B)this;
    }

    @NotNull
    public B setAmount(int amount) {
        this.itemStack.setAmount(Math.max(amount, 1));
        return (B)this;
    }

    @NotNull
    public B addEnchantments(@NotNull Map<String, Integer> enchantments) {
        for (Map.Entry<String, Integer> entry : enchantments.entrySet()) {
            this.addEnchantment(entry.getKey(), entry.getValue());
        }
        return (B)this;
    }

    @NotNull
    public B addEnchantment(@NotNull String enchant, int level) {
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        ItemEnchantments.Builder builder = ItemEnchantments.itemEnchantments();
        if (this.isBook() && this.itemStack.hasData((DataComponentType)DataComponentTypes.STORED_ENCHANTMENTS)) {
            ItemEnchantments enchantments = (ItemEnchantments)this.itemStack.getData(DataComponentTypes.STORED_ENCHANTMENTS);
            if (enchantments != null) {
                builder.addAll(enchantments.enchantments());
            }
        } else {
            Map enchantments = this.itemStack.getEnchantments();
            if (!enchantments.isEmpty()) {
                builder.addAll(enchantments);
            }
        }
        builder.add(enchantment, level);
        this.itemStack.setData(this.isBook() ? DataComponentTypes.STORED_ENCHANTMENTS : DataComponentTypes.ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        return (B)this;
    }

    @NotNull
    public B removeEnchantment(@NotNull String enchant) {
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        this.itemStack.removeEnchantment(enchantment);
        return (B)this;
    }

    @NotNull
    public String getPlainName() {
        Component customName;
        TextComponent component = Component.empty();
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.ITEM_NAME)) {
            Component itemName = (Component)this.itemStack.getData(DataComponentTypes.ITEM_NAME);
            if (itemName != null) {
                component = itemName;
            }
        } else if (this.itemStack.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME) && (customName = (Component)this.itemStack.getData(DataComponentTypes.CUSTOM_NAME)) != null) {
            component = customName;
        }
        return (String)PlainTextComponentSerializer.plainText().serializeOr((Component)component, (Object)"");
    }

    @NotNull
    public List<String> getPlainLore() {
        ItemLore lore;
        ArrayList<String> plainLore = new ArrayList<String>();
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.LORE) && (lore = (ItemLore)this.itemStack.getData(DataComponentTypes.LORE)) != null) {
            lore.lines().forEach(line -> plainLore.add(PlainTextComponentSerializer.plainText().serialize(line)));
        }
        return plainLore;
    }

    @NotNull
    public B addEnchantGlint(boolean isGlowing) {
        if (!isGlowing && this.itemStack.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            this.itemStack.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
            return (B)this;
        }
        this.itemStack.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return (B)this;
    }

    @NotNull
    public B removeEnchantGlint() {
        if (!this.itemStack.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            return (B)this;
        }
        this.itemStack.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        return (B)this;
    }

    @NotNull
    public B hideToolTip() {
        this.itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)this.builder().hideTooltip(true).build()));
        return (B)this;
    }

    @NotNull
    public B showToolTip() {
        if (!this.itemStack.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY)) {
            return (B)this;
        }
        this.itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)this.builder().hideTooltip(false).build()));
        return (B)this;
    }

    @NotNull
    public B hideComponents(@NotNull List<String> components) {
        for (String component : components) {
            this.hideComponent(component);
        }
        return (B)this;
    }

    @NotNull
    public B hideComponent(@NotNull String component) {
        TooltipDisplay components;
        if (component.isEmpty()) {
            return (B)this;
        }
        Optional<DataComponentType> type = ItemUtils.getDataComponentType(component);
        if (type.isEmpty()) {
            return (B)this;
        }
        TooltipDisplay.Builder display = TooltipDisplay.tooltipDisplay();
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) && (components = (TooltipDisplay)this.itemStack.getData(DataComponentTypes.TOOLTIP_DISPLAY)) != null) {
            display.hiddenComponents(components.hiddenComponents());
        }
        display.addHiddenComponents(new DataComponentType[]{type.get()});
        this.itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (DataComponentBuilder)display);
        return (B)this;
    }

    @NotNull
    public B setUnbreakable(boolean isUnbreakable) {
        if (isUnbreakable && !this.itemStack.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.itemStack.setData(DataComponentTypes.UNBREAKABLE);
            return (B)this;
        }
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.itemStack.unsetData((DataComponentType)DataComponentTypes.UNBREAKABLE);
        }
        return (B)this;
    }

    @NotNull
    public B setRepairCost(int repairCost) {
        if (repairCost == -1) {
            return (B)this;
        }
        this.itemStack.setData(DataComponentTypes.REPAIR_COST, (Object)repairCost);
        return (B)this;
    }

    @NotNull
    public B setTrim(@NotNull String pattern, @NotNull String material) {
        if (pattern.isEmpty() || material.isEmpty()) {
            return (B)this;
        }
        TrimMaterial trimMaterial = ItemUtils.getTrimMaterial(material);
        if (trimMaterial == null) {
            return (B)this;
        }
        TrimPattern trimPattern = ItemUtils.getTrimPattern(pattern);
        if (trimPattern == null) {
            return (B)this;
        }
        ItemArmorTrim.Builder builder = ItemArmorTrim.itemArmorTrim((ArmorTrim)new ArmorTrim(trimMaterial, trimPattern));
        this.itemStack.setData(DataComponentTypes.TRIM, (Object)((ItemArmorTrim)builder.build()));
        return (B)this;
    }

    @NotNull
    public B setColor(@NotNull String value) {
        if (value.isEmpty()) {
            return (B)this;
        }
        if (this.isMap()) {
            Color color;
            Color color2 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.itemStack.setData(DataComponentTypes.MAP_COLOR, (Object)((MapItemColor)MapItemColor.mapItemColor().color(color).build()));
            }
        } else if (this.isLeather()) {
            Color color;
            Color color3 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.itemStack.setData(DataComponentTypes.DYED_COLOR, (Object)((DyedItemColor)DyedItemColor.dyedItemColor().color(color).build()));
            }
        } else if (this.isShield()) {
            DyeColor color = ColorUtils.getDyeColor(value);
            this.itemStack.setData(DataComponentTypes.BASE_COLOR, (Object)color);
        }
        return (B)this;
    }

    @NotNull
    public B setItemDamage(int damage) {
        if (damage == -1) {
            return (B)this;
        }
        this.itemStack.setData(DataComponentTypes.DAMAGE, (Object)Math.min(damage, this.itemType.getMaxDurability()));
        return (B)this;
    }

    @NotNull
    public B withSkull(@NotNull String skull) {
        HeadDatabaseAPI api;
        if (skull.isEmpty()) {
            return (B)this;
        }
        Optional<HeadDatabaseAPI> key = this.fusion.getHeadDatabaseAPI();
        ItemStack itemStack = ItemType.PLAYER_HEAD.createItemStack();
        if (key.isPresent() && (api = key.get()).isHead(skull)) {
            itemStack = api.getItemHead(skull);
        }
        this.itemStack = itemStack;
        return (B)this;
    }

    @NotNull
    public B addPlaceholder(@NotNull String placeholder, @NotNull String value) {
        this.placeholders.put(placeholder, value);
        return (B)this;
    }

    @NotNull
    public B setPlaceholders(@NotNull Map<String, String> placeholders) {
        this.placeholders = placeholders;
        return (B)this;
    }

    @NotNull
    public B removePlaceholder(@NotNull String placeholder) {
        this.placeholders.remove(placeholder);
        return (B)this;
    }

    public boolean hasPlaceholder(@NotNull String placeholder) {
        return this.placeholders.containsKey(placeholder);
    }

    @NotNull
    public final B setPersistentDouble(@NotNull NamespacedKey key, double value) {
        this.itemStack.editPersistentDataContainer(container -> container.set(key, PersistentDataType.DOUBLE, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentInteger(@NotNull NamespacedKey key, int value) {
        this.itemStack.editPersistentDataContainer(container -> container.set(key, PersistentDataType.INTEGER, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentBoolean(@NotNull NamespacedKey key, boolean value) {
        this.itemStack.editPersistentDataContainer(container -> container.set(key, PersistentDataType.BOOLEAN, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentString(@NotNull NamespacedKey key, @NotNull String value) {
        this.itemStack.editPersistentDataContainer(container -> container.set(key, PersistentDataType.STRING, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentList(@NotNull NamespacedKey key, @NotNull List<String> values) {
        this.itemStack.editPersistentDataContainer(container -> container.set(key, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)values));
        return (B)this;
    }

    public final boolean getBoolean(@NotNull NamespacedKey key) {
        return (Boolean)this.getContainer().getOrDefault(key, PersistentDataType.BOOLEAN, (Object)false);
    }

    public final double getDouble(@NotNull NamespacedKey key) {
        return (Double)this.getContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
    }

    public final int getInteger(@NotNull NamespacedKey key) {
        return (Integer)this.getContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    @NotNull
    public final List<String> getList(@NotNull NamespacedKey key) {
        return (List)this.getContainer().getOrDefault(key, (PersistentDataType)PersistentDataType.LIST.strings(), Collections.emptyList());
    }

    @NotNull
    public final String getString(@NotNull NamespacedKey key) {
        return (String)this.getContainer().getOrDefault(key, PersistentDataType.STRING, (Object)"");
    }

    @NotNull
    public final B removePersistentKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return (B)this;
        }
        this.itemStack.editPersistentDataContainer(container -> {
            if (container.has(key)) {
                container.remove(key);
            }
        });
        return (B)this;
    }

    public final boolean hasKey(@NotNull NamespacedKey key) {
        return this.getContainer().has(key);
    }

    @NotNull
    public final PersistentDataContainerView getContainer() {
        return this.itemStack.getPersistentDataContainer();
    }

    @NotNull
    public final FireworkBuilder asFireworkBuilder() {
        if (!this.isFirework()) {
            throw new FusionException("This item type is not a firework rocket.");
        }
        return new FireworkBuilder(this.itemStack);
    }

    @NotNull
    public final FireworkStarBuilder asFireworkStarBuilder() {
        if (!this.isFireworkStar()) {
            throw new FusionException("This item type is not a firework star.");
        }
        return new FireworkStarBuilder(this.itemStack);
    }

    @NotNull
    public final PatternBuilder asPatternBuilder() {
        if (this.isShield() || this.isBanner()) {
            return new PatternBuilder(this.itemStack);
        }
        throw new FusionException("This item type is not a shield/banner.");
    }

    @NotNull
    public final SkullBuilder asSkullBuilder() {
        if (!this.isPlayerHead()) {
            throw new FusionException("This item type is not a skull.");
        }
        return new SkullBuilder(this.itemStack);
    }

    @NotNull
    public final PotionBuilder asPotionBuilder() {
        if (this.isPotion() || this.isTippedArrow()) {
            return new PotionBuilder(this.itemStack);
        }
        throw new FusionException("This item type is not a potion / tipped arrow.");
    }

    @NotNull
    public final SpawnerBuilder asSpawnerBuilder() {
        if (!this.isSpawner()) {
            throw new FusionException("This item type is not a spawner.");
        }
        return new SpawnerBuilder(this.itemStack);
    }

    @NotNull
    public final CustomBuilder asCustomBuilder() {
        return new CustomBuilder(this.itemStack);
    }

    @NotNull
    public final ToolBuilder asToolBuilder() {
        return new ToolBuilder(this.itemStack);
    }

    public void setItemToInventory(@NotNull Audience audience, @NotNull Inventory inventory, int slot) {
        inventory.setItem(slot, this.asItemStack(audience));
    }

    public void addItemToInventory(@NotNull Audience audience, @NotNull Inventory inventory) {
        inventory.addItem(new ItemStack[]{this.asItemStack(audience)});
    }

    public void setItemToInventory(@NotNull Inventory inventory, int slot) {
        this.setItemToInventory(Audience.empty(), inventory, slot);
    }

    public void addItemToInventory(@NotNull Inventory inventory) {
        this.addItemToInventory(Audience.empty(), inventory);
    }

    public final boolean isDyeable() {
        return this.isTippedArrow() || this.isShield() || this.isLeather() || this.isMap();
    }

    public final boolean isPlayerHead() {
        return this.asString().equalsIgnoreCase(ItemType.PLAYER_HEAD.key().asString());
    }

    public final boolean isFireworkStar() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_STAR.key().asString());
    }

    public final boolean isTippedArrow() {
        return this.asString().equalsIgnoreCase(ItemType.TIPPED_ARROW.key().asString());
    }

    public final boolean isFirework() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_ROCKET.key().asString());
    }

    public final boolean isSpawner() {
        return this.asString().equalsIgnoreCase(ItemType.SPAWNER.key().asString());
    }

    public final boolean isShield() {
        return this.asString().equalsIgnoreCase(ItemType.SHIELD.key().asString());
    }

    public final boolean isEdible() {
        return this.itemType.isEdible();
    }

    public final boolean isArmor() {
        return armor.contains(this.asString());
    }

    public final boolean isTool() {
        return tools.contains(this.asString());
    }

    public final boolean isLeather() {
        return leather_items.contains(this.asString());
    }

    public final boolean isPotion() {
        return potions.contains(this.asString());
    }

    public final boolean isBanner() {
        return this.getId().endsWith("_banner");
    }

    public final boolean isBook() {
        return this.asString().equalsIgnoreCase(ItemType.ENCHANTED_BOOK.key().asString());
    }

    public final boolean isMap() {
        return this.asString().equalsIgnoreCase(ItemType.FILLED_MAP.key().asString());
    }

    @NotNull
    public final String getTranslationKey() {
        return this.itemType.translationKey();
    }

    @NotNull
    public final ItemType getType() {
        return this.itemType;
    }

    @NotNull
    public final Key getKey() {
        return this.itemType.key();
    }

    public final String getNamespace() {
        return this.getKey().namespace();
    }

    public final String asString() {
        return this.getKey().asString();
    }

    public final String getId() {
        return this.getKey().value();
    }

    @NotNull
    private TooltipDisplay.Builder builder() {
        TooltipDisplay display;
        TooltipDisplay.Builder builder = TooltipDisplay.tooltipDisplay();
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) && (display = (TooltipDisplay)this.itemStack.getData(DataComponentTypes.TOOLTIP_DISPLAY)) != null) {
            builder.hideTooltip(display.hideTooltip());
            builder.hiddenComponents(display.hiddenComponents());
        }
        return builder;
    }

    private void getItemsAdder(@NotNull String itemStack) {
        if (!CustomStack.isInRegistry((String)itemStack)) {
            this.fusion.log("warn", "The id " + itemStack + " does not exist as an ItemsAdder item!", new Object[0]);
            return;
        }
        CustomStack builder = CustomStack.getInstance((String)itemStack);
        if (builder == null) {
            throw new FusionException("The id " + itemStack + " is not a valid ItemsAdder item!");
        }
        this.itemStack = builder.getItemStack();
        this.itemType = this.itemStack.getType().asItemType();
    }

    private void getOraxen(@NotNull String itemStack) {
        if (!OraxenItems.exists((String)itemStack)) {
            this.fusion.log("warn", "The id " + itemStack + " does not exist as an Oraxen item!", new Object[0]);
            return;
        }
        ItemBuilder builder = OraxenItems.getItemById((String)itemStack);
        if (builder == null) {
            throw new FusionException("The id " + itemStack + " is not a valid Oraxen item!");
        }
        this.itemStack = builder.build();
        this.itemType = this.itemStack.getType().asItemType();
    }

    private void getNexo(@NotNull String itemStack) {
        if (!NexoItems.exists((String)itemStack)) {
            this.fusion.log("warn", "The id " + itemStack + " does not exist as a Nexo item!", new Object[0]);
            return;
        }
        com.nexomc.nexo.items.ItemBuilder builder = NexoItems.itemFromId((String)itemStack);
        if (builder == null) {
            throw new FusionException("The id " + itemStack + " is not a valid Nexo item!");
        }
        this.itemStack = builder.build();
        this.itemType = this.itemStack.getType().asItemType();
    }

    private void setItem(@NotNull String itemStack) {
        ItemType itemType = ItemUtils.getItemType(itemStack);
        if (itemType == null) {
            this.withBase64(itemStack);
            return;
        }
        this.withType(itemType);
    }
}

