/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.ryderbelserion.fusion.core.FusionConfig;
import com.ryderbelserion.fusion.core.FusionCore;
import com.ryderbelserion.fusion.core.FusionKey;
import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.core.api.support.ModSupport;
import com.ryderbelserion.fusion.core.api.support.objects.Mod;
import com.ryderbelserion.fusion.core.files.enums.FileAction;
import com.ryderbelserion.fusion.core.files.enums.FileType;
import com.ryderbelserion.fusion.core.files.types.YamlCustomFile;
import com.ryderbelserion.fusion.paper.files.PaperFileManager;
import com.ryderbelserion.fusion.paper.structure.StructureRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionPaper
extends FusionCore {
    private final PaperFileManager fileManager = new PaperFileManager(this);
    private final PluginManager pluginManager;
    private final StructureRegistry registry;
    private final Server server;
    private HeadDatabaseAPI api;

    public FusionPaper(@NotNull JavaPlugin plugin) {
        super((FusionCore consumer) -> {
            consumer.setDataPath(plugin.getDataPath());
            consumer.setLogger(plugin.getComponentLogger());
        });
        this.server = plugin.getServer();
        this.pluginManager = this.server.getPluginManager();
        this.registry = new StructureRegistry(plugin, this.server.getStructureManager());
        this.init(consumer -> {
            this.config = new FusionConfig(this.fileManager.getYamlFile(this.dataPath.resolve("fusion.yml")));
        });
        FusionProvider.register(this);
        ModSupport.dependencies.forEach(dependency -> this.getModManager().addMod((FusionKey)dependency, new Mod()));
    }

    @Override
    @NotNull
    public final Component parse(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders, @NotNull List<TagResolver> tags) {
        ArrayList<TagResolver> resolvers = new ArrayList<TagResolver>(tags);
        com.ryderbelserion.fusion.core.utils.StringUtils utils = this.getStringUtils();
        placeholders.forEach((key, value) -> resolvers.add((TagResolver)Placeholder.parsed((String)utils.replaceAllBrackets((String)key).toLowerCase(), (String)value)));
        return MiniMessage.miniMessage().deserialize(this.papi(audience, utils.replaceBrackets(message)), !resolvers.isEmpty() ? TagResolver.resolver(resolvers) : TagResolver.empty()).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final String papi(@NotNull Audience audience, @NotNull String message) {
        String string;
        if (audience instanceof Player) {
            Player player = (Player)audience;
            if (this.getModManager().getMod(ModSupport.placeholder_api).isEnabled()) {
                string = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
                return string;
            }
        }
        string = message;
        return string;
    }

    @Override
    @NotNull
    public final FusionPaper init(@NotNull Consumer<FusionCore> fusion) {
        Path dataPath = this.getDataPath();
        if (Files.notExists(dataPath, new LinkOption[0])) {
            try {
                Files.createDirectory(dataPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.fileManager.addFile(this.dataPath.resolve("fusion.yml"), FileType.FUSION_YAML, consumer -> {
            YamlCustomFile customFile = (YamlCustomFile)consumer;
            customFile.setOptions(options -> options.shouldCopyDefaults(true));
            customFile.addAction(FileAction.EXTRACT_FILE);
        });
        if (this.isModReady(ModSupport.head_database) && this.api == null) {
            this.api = new HeadDatabaseAPI();
        }
        fusion.accept(this);
        return this;
    }

    @Override
    @NotNull
    public final FusionCore reload() {
        this.config.reload();
        return this;
    }

    @Override
    @NotNull
    public final String chomp(@NotNull String value) {
        return StringUtils.chomp((String)value);
    }

    @NotNull
    public final PlayerProfile createProfile(@NotNull UUID uuid, @Nullable String name) {
        return this.server.createProfile(uuid, name);
    }

    @Override
    public boolean isModReady(@NotNull FusionKey key) {
        return this.pluginManager.isPluginEnabled(key.getValue());
    }

    @Override
    public PaperFileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public FusionConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final StructureRegistry getRegistry() {
        if (this.registry == null) {
            throw new FusionException("An error occurred while trying to get the structure registry instance.");
        }
        return this.registry;
    }

    @NotNull
    public final Optional<HeadDatabaseAPI> getHeadDatabaseAPI() {
        return Optional.ofNullable(this.api);
    }
}

