/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.support.factions;

import com.badbones69.crazyenchantments.paper.support.interfaces.claims.ClaimSupport;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.iface.RelationParticipator;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class FactionsUUIDSupport
implements ClaimSupport {
    @Override
    public boolean isFriendly(Player player, Player other) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        FPlayer oPlayer = FPlayers.getInstance().getByPlayer(other);
        if (fPlayer == null || oPlayer == null) {
            return false;
        }
        if (oPlayer.getFaction().isPeaceful()) {
            return true;
        }
        if (this.isWilderness(fPlayer) || this.isWilderness(oPlayer)) {
            return false;
        }
        try {
            return fPlayer.getFaction() == oPlayer.getFaction() || fPlayer.getRelationTo((RelationParticipator)oPlayer).isAlly() || fPlayer.getRelationTo((RelationParticipator)oPlayer).isTruce();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    @Override
    public boolean inTerritory(Player player) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        return !this.isWilderness(fPlayer) && (fPlayer.isInOwnTerritory() || fPlayer.isInAllyTerritory());
    }

    @Override
    public boolean canBreakBlock(Player player, Block block) {
        Faction fBlock = Board.getInstance().getFactionAt(new FLocation(block.getLocation()));
        return this.isWilderness(fBlock) || FPlayers.getInstance().getByPlayer(player).getFaction() == fBlock;
    }

    private boolean isWilderness(FPlayer player) {
        return this.isWilderness(player.getFaction());
    }

    private boolean isWilderness(Faction faction) {
        return faction != null && faction.isWilderness();
    }
}

