/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SlotCrystalListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private static ItemStack slot_crystal;

    public void load() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        slot_crystal = new ItemBuilder().setMaterial(config.getString("Settings.Slot_Crystal.Item", "RED_WOOL")).setName(config.getString("Settings.Slot_Crystal.Name", "Error getting name.")).setLore(config.getStringList("Settings.Slot_Crystal.Lore")).setGlow(config.getBoolean("Settings.Slot_Crystal.Glowing", false)).addKey(DataKeys.slot_crystal.getNamespacedKey(), "").build();
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack crystalItem = event.getCursor();
        ItemStack item = event.getCurrentItem();
        if (item == null || item.isEmpty() || !this.isSlotCrystal(crystalItem) || this.isSlotCrystal(item)) {
            return;
        }
        final int maxEnchants = this.starter.getCrazyManager().getPlayerMaxEnchantments(player);
        final int enchAmount = this.enchantmentBookSettings.getEnchantmentAmount(item, this.starter.getCrazyManager().checkVanillaLimit());
        final int baseEnchants = this.starter.getCrazyManager().getPlayerBaseEnchantments(player);
        final int limiter = this.starter.getCrazyManager().getEnchantmentLimiter(item);
        event.setCancelled(true);
        if (enchAmount >= maxEnchants) {
            player.sendMessage(Messages.HIT_ENCHANTMENT_MAX.getMessage());
            return;
        }
        if (baseEnchants - limiter >= maxEnchants) {
            player.sendMessage(Messages.MAX_SLOTS_UNLOCKED.getMessage());
            return;
        }
        crystalItem.setAmount(crystalItem.getAmount() - 1);
        event.getCursor().setAmount(crystalItem.getAmount());
        event.setCurrentItem(this.starter.getCrazyManager().changeEnchantmentLimiter(item, -1));
        player.sendMessage(Messages.APPLIED_SLOT_CRYSTAL.getMessage((Map<String, String>)new HashMap<String, String>(4){
            {
                super(arg0);
                this.put("%slot%", String.valueOf(-(limiter - 1)));
                this.put("%maxEnchants%", String.valueOf(maxEnchants));
                this.put("%enchantAmount%", String.valueOf(enchAmount));
                this.put("baseEnchants", String.valueOf(baseEnchants));
            }
        }));
    }

    private boolean isSlotCrystal(ItemStack crystalItem) {
        if (crystalItem == null || crystalItem.isEmpty()) {
            return false;
        }
        return crystalItem.getPersistentDataContainer().has(DataKeys.slot_crystal.getNamespacedKey());
    }

    public ItemStack getSlotCrystal() {
        return slot_crystal.clone();
    }
}

