/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.typeimpl;

import ch.jalu.typeresolver.CommonTypeUtils;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

public class WildcardTypeImpl
implements WildcardType {
    private final Type[] upperBounds;
    private final Type[] lowerBounds;

    public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    public static WildcardType newWildcardExtends(Type upperBound) {
        return new WildcardTypeImpl(new Type[]{upperBound}, new Type[0]);
    }

    public static WildcardType newWildcardSuper(Type lowerBound) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{lowerBound});
    }

    public static WildcardType newUnboundedWildcard() {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
    }

    @Override
    public Type[] getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public Type[] getLowerBounds() {
        return this.lowerBounds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WildcardType) {
            WildcardType that = (WildcardType)obj;
            return Arrays.equals(that.getLowerBounds(), this.lowerBounds) && Arrays.equals(that.getUpperBounds(), this.upperBounds);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
    }

    public String toString() {
        Type[] bounds;
        StringBuilder sb = new StringBuilder();
        if (this.lowerBounds.length > 0) {
            bounds = this.lowerBounds;
            sb.append("? super ");
        } else {
            if (!CommonTypeUtils.hasExplicitUpperBound(this)) {
                return "?";
            }
            bounds = this.upperBounds;
            sb.append("? extends ");
        }
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                sb.append(" & ");
            }
            sb.append(bounds[i].getTypeName());
        }
        return sb.toString();
    }
}

