/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.enchantments;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.events.AuraActiveEvent;
import com.badbones69.crazyenchantments.paper.api.managers.ArmorEnchantmentManager;
import com.badbones69.crazyenchantments.paper.api.objects.ArmorEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.PotionEffects;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.api.utils.EventUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.tasks.processors.ArmorProcessor;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ArmorEnchantments
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final ProtectionCrystalSettings protectionCrystalSettings = this.starter.getProtectionCrystalSettings();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    @NotNull
    private final ArmorEnchantmentManager armorEnchantmentManager = this.starter.getArmorEnchantmentManager();
    private final ArmorProcessor armorProcessor = new ArmorProcessor();
    private final List<UUID> fallenPlayers = new ArrayList<UUID>();

    public ArmorEnchantments() {
        this.armorProcessor.start();
    }

    public void stop() {
        this.armorProcessor.stop();
    }

    @EventHandler
    public void onDeath(EntityResurrectEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)livingEntity;
        final ItemStack air = new ItemStack(Material.AIR);
        new FoliaScheduler(this.plugin, null, (Entity)player){

            @Override
            public void run() {
                ArmorEnchantments.this.updateEffects(player, air, air);
            }
        }.runDelayed(10L);
    }

    @EventHandler
    public void onEquip(EntityEquipmentChangedEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        NamespacedKey key = DataKeys.enchantments.getNamespacedKey();
        event.getEquipmentChanges().forEach((slot, action) -> {
            ItemStack newItem = action.newItem();
            ItemStack oldItem = action.oldItem();
            PersistentDataContainerView newView = newItem.getPersistentDataContainer();
            PersistentDataContainerView oldView = oldItem.getPersistentDataContainer();
            if (!newView.has(key) && oldView.has(key)) {
                return;
            }
            if (Objects.equals(newView.get(key, PersistentDataType.STRING), oldView.get(key, PersistentDataType.STRING))) {
                return;
            }
            this.updateEffects(player, newItem, oldItem);
        });
    }

    private void updateEffects(@NotNull Player player, @NotNull ItemStack newItem, @NotNull ItemStack oldItem) {
        Map<CEnchantment, Integer> topEnchants = this.getCurrentEnchants(player, newItem);
        if (!oldItem.isEmpty()) {
            this.getTopPotionEffects(this.enchantmentBookSettings.getEnchantments(oldItem).entrySet().stream().filter(enchant -> !topEnchants.containsKey(enchant.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b))).keySet().forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
        }
        for (Map.Entry<PotionEffectType, Integer> effect : this.getTopPotionEffects(topEnchants).entrySet()) {
            for (PotionEffect currentEffect : player.getActivePotionEffects()) {
                if (!currentEffect.getType().equals(effect.getKey())) continue;
                if (currentEffect.getAmplifier() >= effect.getValue() - 1) break;
                player.removePotionEffect(effect.getKey());
                break;
            }
            player.addPotionEffect(new PotionEffect(effect.getKey(), -1, effect.getValue() - 1));
        }
    }

    @NotNull
    private Map<PotionEffectType, Integer> getTopPotionEffects(@NotNull Map<CEnchantment, Integer> topEnchants) {
        Map<CEnchantments, HashMap<PotionEffectType, Integer>> enchantmentPotions = this.crazyManager.getEnchantmentPotions();
        HashMap<PotionEffectType, Integer> topPotions = new HashMap<PotionEffectType, Integer>();
        topEnchants.forEach((key, value) -> enchantmentPotions.entrySet().stream().filter(enchantedPotion -> ((CEnchantments)((Object)((Object)((Object)enchantedPotion.getKey())))).getEnchantment().equals(key)).forEach(enchantedPotion -> ((HashMap)enchantedPotion.getValue()).entrySet().stream().filter(pot -> !topPotions.containsKey(pot.getKey()) || (Integer)topPotions.get(pot.getKey()) != -1 && (Integer)topPotions.get(pot.getKey()) <= (Integer)pot.getValue()).forEach(pot -> topPotions.put((PotionEffectType)pot.getKey(), (Integer)value))));
        return topPotions;
    }

    @NotNull
    private Map<CEnchantment, Integer> getCurrentEnchants(@NotNull Player player, @NotNull ItemStack newItem) {
        HashMap<CEnchantment, Integer> toAdd = this.getUpperEnchants(player);
        if (!newItem.isEmpty()) {
            this.enchantmentBookSettings.getEnchantments(newItem).entrySet().stream().filter(ench -> !toAdd.containsKey(ench.getKey()) || (Integer)toAdd.get(ench.getKey()) <= (Integer)ench.getValue()).filter(ench -> EnchantUtils.isArmorEventActive(player, CEnchantments.valueOf(((CEnchantment)ench.getKey()).getName().toUpperCase()), newItem)).forEach(ench -> toAdd.put((CEnchantment)ench.getKey(), (Integer)ench.getValue()));
        }
        return toAdd;
    }

    @NotNull
    private HashMap<CEnchantment, Integer> getUpperEnchants(@NotNull Player player) {
        HashMap<CEnchantment, Integer> topEnchants = new HashMap<CEnchantment, Integer>();
        Arrays.stream(player.getEquipment().getArmorContents()).map(this.enchantmentBookSettings::getEnchantments).forEach(enchantments -> enchantments.entrySet().stream().filter(ench -> !topEnchants.containsKey(ench.getKey()) || (Integer)topEnchants.get(ench.getKey()) <= (Integer)ench.getValue()).forEach(ench -> topEnchants.put((CEnchantment)ench.getKey(), (Integer)ench.getValue())));
        return topEnchants;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        Map<CEnchantment, Integer> enchants;
        LivingEntity damager;
        Entity entity2;
        block28: {
            block27: {
                if (EventUtils.isIgnoredEvent((Event)event) || EventUtils.isIgnoredUUID(event.getDamager().getUniqueId())) {
                    return;
                }
                if (this.pluginSupport.isFriendly(event.getDamager(), event.getEntity())) {
                    return;
                }
                entity2 = event.getDamager();
                if (!(entity2 instanceof LivingEntity)) break block27;
                damager = (LivingEntity)entity2;
                entity2 = event.getEntity();
                if (entity2 instanceof Player) break block28;
            }
            return;
        }
        final Player player = (Player)entity2;
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            enchants = this.enchantmentBookSettings.getEnchantments(armor);
            if (enchants.isEmpty()) continue;
            for (ArmorEnchantment armorEnchantment : this.armorEnchantmentManager.getArmorEnchantments()) {
                CEnchantments enchantment = armorEnchantment.getEnchantment();
                if (!EnchantUtils.isEventActive(enchantment, (Entity)player, armor, enchants)) continue;
                if (armorEnchantment.isPotionEnchantment()) {
                    for (PotionEffects effect : armorEnchantment.getPotionEffects()) {
                        damager.addPotionEffect(new PotionEffect(effect.potionEffect(), effect.duration(), (armorEnchantment.isLevelAddedToAmplifier() ? enchants.get(enchantment.getEnchantment()) : 0) + effect.amplifier()));
                    }
                    continue;
                }
                event.setDamage(event.getDamage() * ((double)(armorEnchantment.isLevelAddedToAmplifier() ? enchants.get(enchantment.getEnchantment()) : 0) + armorEnchantment.getDamageAmplifier()));
            }
            if (EnchantUtils.isEventActive(CEnchantments.MANEUVER, (Entity)player, armor, enchants)) {
                event.setCancelled(true);
                return;
            }
            if (player.isSneaking() && EnchantUtils.isEventActive(CEnchantments.CROUCH, (Entity)player, armor, enchants)) {
                double percentageReduced = (double)(CEnchantments.CROUCH.getChance() + CEnchantments.CROUCH.getChanceIncrease() * enchants.get(CEnchantments.CROUCH.getEnchantment())) / 100.0;
                double newDamage = event.getFinalDamage() * (1.0 - percentageReduced);
                if (newDamage < 0.0) {
                    newDamage = 0.0;
                }
                event.setDamage(newDamage);
            }
            if (EnchantUtils.isEventActive(CEnchantments.SHOCKWAVE, (Entity)player, armor, enchants)) {
                damager.setVelocity(player.getLocation().getDirection().multiply(2).setY(1.25));
            }
            if (player.getHealth() <= event.getFinalDamage() && EnchantUtils.isEventActive(CEnchantments.SYSTEMREBOOT, (Entity)player, armor, enchants)) {
                player.setHealth(player.getAttribute(Attribute.MAX_HEALTH).getValue());
                event.setCancelled(true);
                return;
            }
            if (player.getHealth() <= 4.0 && EnchantUtils.isEventActive(CEnchantments.ADRENALINE, (Entity)player, armor, enchants)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 3 + enchants.get(CEnchantments.ADRENALINE.getEnchantment()) * 20, 10));
            }
            if (player.getHealth() <= 8.0 && EnchantUtils.isEventActive(CEnchantments.ROCKET, (Entity)player, armor, enchants)) {
                new FoliaScheduler(this, this.plugin, null, (Entity)player){

                    @Override
                    public void run() {
                        player.setVelocity(player.getLocation().toVector().subtract(damager.getLocation().toVector()).normalize().setY(1));
                    }
                }.runDelayed(1L);
                this.fallenPlayers.add(player.getUniqueId());
                player.getWorld().spawnParticle(Particle.EXPLOSION, player.getLocation(), 1);
                new FoliaScheduler(this.plugin, null, (Entity)player){

                    @Override
                    public void run() {
                        ArmorEnchantments.this.fallenPlayers.remove(player.getUniqueId());
                    }
                }.runDelayed(160L);
            }
            if (player.getHealth() > 0.0 && EnchantUtils.isEventActive(CEnchantments.ENLIGHTENED, (Entity)player, armor, enchants)) {
                double heal = enchants.get(CEnchantments.ENLIGHTENED.getEnchantment()).intValue();
                double maxHealth = player.getAttribute(Attribute.MAX_HEALTH).getValue();
                if (player.getHealth() + heal < maxHealth) {
                    player.setHealth(player.getHealth() + heal);
                }
                if (player.getHealth() + heal >= maxHealth) {
                    player.setHealth(maxHealth);
                }
            }
            if (EnchantUtils.isEventActive(CEnchantments.INSOMNIA, (Entity)player, armor, enchants)) {
                damager.damage(event.getDamage() + (double)enchants.get(CEnchantments.INSOMNIA.getEnchantment()).intValue());
            }
            if (EnchantUtils.isEventActive(CEnchantments.MOLTEN, (Entity)player, armor, enchants)) {
                damager.setFireTicks(enchants.get(CEnchantments.MOLTEN.getEnchantment()) * 2 * 20);
            }
            if (EnchantUtils.isEventActive(CEnchantments.SAVIOR, (Entity)player, armor, enchants)) {
                event.setDamage(event.getDamage() / 2.0);
            }
            if (EnchantUtils.isEventActive(CEnchantments.CACTUS, (Entity)player, armor, enchants)) {
                damager.damage((double)enchants.get(CEnchantments.CACTUS.getEnchantment()).intValue());
            }
            if (!EnchantUtils.isEventActive(CEnchantments.STORMCALLER, (Entity)player, armor, enchants)) continue;
            Entity lightning = this.methods.lightning(damager);
            for (LivingEntity en : this.methods.getNearbyLivingEntities(2.0, (Entity)player)) {
                EntityDamageEvent damageByEntityEvent = new EntityDamageEvent((Entity)en, EntityDamageEvent.DamageCause.LIGHTNING, DamageSource.builder((DamageType)DamageType.LIGHTNING_BOLT).withCausingEntity((Entity)player).withDirectEntity(lightning).build(), 5.0);
                this.methods.entityEvent(player, en, damageByEntityEvent);
            }
            damager.damage(5.0);
        }
        if (!(damager instanceof Player)) {
            return;
        }
        for (ItemStack armor : Objects.requireNonNull(damager.getEquipment()).getArmorContents()) {
            int radius;
            int n;
            enchants = this.enchantmentBookSettings.getEnchantments(armor);
            if (!enchants.containsKey(CEnchantments.LEADERSHIP.getEnchantment()) || (n = (int)damager.getNearbyEntities((double)(radius = 4 + enchants.get(CEnchantments.LEADERSHIP.getEnchantment())), (double)radius, (double)radius).stream().filter(entity -> entity instanceof Player && this.pluginSupport.isFriendly((Entity)damager, (Entity)entity)).count()) <= 0 || !EnchantUtils.isEventActive(CEnchantments.LEADERSHIP, (Entity)player, armor, enchants)) continue;
            event.setDamage(event.getDamage() + (double)n / 2.0);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onAura(AuraActiveEvent event) {
        Player other;
        Player player = event.getPlayer();
        if (!player.canSee(other = event.getOther()) || !other.canSee(player)) {
            return;
        }
        if (this.pluginSupport.isVanished(player) || this.pluginSupport.isVanished(other)) {
            return;
        }
        CEnchantments enchant = event.getEnchantment();
        int level = event.getLevel();
        if (!this.pluginSupport.allowCombat(other.getLocation()) || this.pluginSupport.isFriendly((Entity)player, (Entity)other) || this.methods.hasPermission(other, "bypass.aura", false)) {
            return;
        }
        Map<CEnchantment, Integer> enchantments = Map.of(enchant.getEnchantment(), level);
        switch (enchant) {
            case BLIZZARD: {
                if (!EnchantUtils.isAuraActive(player, enchant, enchantments)) break;
                other.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, level - 1));
                break;
            }
            case INTIMIDATE: {
                if (!EnchantUtils.isAuraActive(player, enchant, enchantments)) break;
                other.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 60, level - 1));
                break;
            }
            case ACIDRAIN: {
                if (!EnchantUtils.isAuraActive(player, enchant, enchantments)) break;
                other.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 80, 1));
                break;
            }
            case SANDSTORM: {
                if (!EnchantUtils.isAuraActive(player, enchant, enchantments)) break;
                other.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 200, 0));
                break;
            }
            case RADIANT: {
                if (!EnchantUtils.isAuraActive(player, enchant, enchantments)) break;
                other.setFireTicks(100);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMovement(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        this.armorProcessor.add(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (player.getKiller() == null) {
            return;
        }
        Player killer = player.getKiller();
        if (!this.pluginSupport.allowCombat(player.getLocation())) {
            return;
        }
        for (ItemStack item : player.getEquipment().getArmorContents()) {
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(item);
            if (EnchantUtils.isEventActive(CEnchantments.SELFDESTRUCT, (Entity)player, item, enchantments)) {
                this.methods.explode((Entity)player);
                List<ItemStack> items = event.getDrops().stream().filter(drop -> ProtectionCrystalSettings.isProtected(drop.getPersistentDataContainer()) && this.protectionCrystalSettings.isProtectionSuccessful(player)).toList();
                event.getDrops().clear();
                event.getDrops().addAll(items);
            }
            if (!EnchantUtils.isEventActive(CEnchantments.RECOVER, (Entity)player, item, enchantments)) continue;
            killer.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 160, 2));
            killer.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 1));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.fallenPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (!EntityDamageEvent.DamageCause.FALL.equals((Object)event.getCause())) {
            return;
        }
        event.setCancelled(true);
    }
}

