/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.primitives;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum PrimitiveType {
    BOOLEAN(Boolean.TYPE, Boolean.class, false),
    BYTE(Byte.TYPE, Byte.class, (byte)0),
    CHARACTER(Character.TYPE, Character.class, Character.valueOf('\u0000')),
    SHORT(Short.TYPE, Short.class, (short)0),
    INTEGER(Integer.TYPE, Integer.class, 0),
    LONG(Long.TYPE, Long.class, 0L),
    FLOAT(Float.TYPE, Float.class, Float.valueOf(0.0f)),
    DOUBLE(Double.TYPE, Double.class, 0.0);

    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_REFERENCE_TYPES;
    private static final Map<Class<?>, Class<?>> REFERENCE_TO_PRIMITIVE_TYPES;
    private static final Map<Class<?>, PrimitiveType> PRIMITIVES_BY_CLASS;
    private final Class<?> primitiveType;
    private final Class<?> referenceType;
    private final Object defaultValue;

    private PrimitiveType(Class<?> primitiveType, Class<?> referenceType, Object defaultValue) {
        this.primitiveType = primitiveType;
        this.referenceType = referenceType;
        this.defaultValue = defaultValue;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    public Class<?> getReferenceType() {
        return this.referenceType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean matches(@Nullable Class<?> clazz) {
        return this.primitiveType.equals(clazz) || this.referenceType.equals(clazz);
    }

    @Nullable
    public static PrimitiveType from(Class<?> clazz) {
        return PRIMITIVES_BY_CLASS.get(clazz);
    }

    public static Class<?> toPrimitiveType(Class<?> clazz) {
        Class<?> primitiveType = REFERENCE_TO_PRIMITIVE_TYPES.get(clazz);
        return primitiveType == null ? clazz : primitiveType;
    }

    public static Class<?> toReferenceType(Class<?> clazz) {
        Class<?> referenceType = PRIMITIVE_TO_REFERENCE_TYPES.get(clazz);
        return referenceType == null ? clazz : referenceType;
    }

    public static boolean isRealPrimitive(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isPrimitive() && !Void.TYPE.equals(clazz);
    }

    private static Map<Class<?>, Class<?>> initPrimitiveToReferenceTypesMap() {
        HashMap<Class<Comparable<Boolean>>, Class> primToRefTypes = new HashMap<Class<Comparable<Boolean>>, Class>();
        primToRefTypes.put(Boolean.TYPE, Boolean.class);
        primToRefTypes.put(Byte.TYPE, Byte.class);
        primToRefTypes.put(Character.TYPE, Character.class);
        primToRefTypes.put(Short.TYPE, Short.class);
        primToRefTypes.put(Integer.TYPE, Integer.class);
        primToRefTypes.put(Long.TYPE, Long.class);
        primToRefTypes.put(Float.TYPE, Float.class);
        primToRefTypes.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(primToRefTypes);
    }

    private static Map<Class<?>, Class<?>> initReferenceToPrimitiveTypesMap() {
        HashMap<Class, Class<Comparable<Boolean>>> refToPrimTypes = new HashMap<Class, Class<Comparable<Boolean>>>();
        refToPrimTypes.put(Boolean.class, Boolean.TYPE);
        refToPrimTypes.put(Byte.class, Byte.TYPE);
        refToPrimTypes.put(Character.class, Character.TYPE);
        refToPrimTypes.put(Short.class, Short.TYPE);
        refToPrimTypes.put(Integer.class, Integer.TYPE);
        refToPrimTypes.put(Long.class, Long.TYPE);
        refToPrimTypes.put(Float.class, Float.TYPE);
        refToPrimTypes.put(Double.class, Double.TYPE);
        return Collections.unmodifiableMap(refToPrimTypes);
    }

    private static Map<Class<?>, PrimitiveType> initClassToPrimitiveTypes() {
        HashMap classToPrimRefType = new HashMap();
        for (PrimitiveType type : PrimitiveType.values()) {
            classToPrimRefType.put(type.getPrimitiveType(), type);
            classToPrimRefType.put(type.getReferenceType(), type);
        }
        return Collections.unmodifiableMap(classToPrimRefType);
    }

    static {
        PRIMITIVE_TO_REFERENCE_TYPES = PrimitiveType.initPrimitiveToReferenceTypesMap();
        REFERENCE_TO_PRIMITIVE_TYPES = PrimitiveType.initReferenceToPrimitiveTypesMap();
        PRIMITIVES_BY_CLASS = PrimitiveType.initClassToPrimitiveTypes();
    }
}

