/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.objects;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.events.RegisteredCEnchantmentEvent;
import com.badbones69.crazyenchantments.paper.api.events.UnregisterCEnchantmentEvent;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.enchants.EnchantmentType;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CEnchantment {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    private String name;
    private String customName;
    private boolean activated;
    private int maxLevel;
    private String infoName;
    private int chance;
    private int chanceIncrease;
    private List<String> infoDescription;
    private final List<Category> categories;
    private EnchantmentType enchantmentType;
    private final CEnchantment instance = this;
    private Sound sound;
    private List<String> conflicts;

    public CEnchantment(String name) {
        this.name = name;
        this.customName = name;
        this.activated = true;
        this.maxLevel = 3;
        this.infoName = ColorUtils.color("&7" + name);
        this.chance = 0;
        this.chanceIncrease = 0;
        this.infoDescription = new ArrayList<String>();
        this.categories = new ArrayList<Category>();
        this.enchantmentType = null;
        this.sound = Sound.ENTITY_PLAYER_LEVELUP;
        this.conflicts = new ArrayList<String>();
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public CEnchantment setConflicts(List<String> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    public boolean conflictsWith(CEnchantment other) {
        return this.conflicts.contains(other.name);
    }

    @NotNull
    public Sound getSound() {
        return this.sound;
    }

    public CEnchantment setSound(String soundString) {
        if (soundString == null || soundString.isBlank()) {
            this.sound = Sound.ENTITY_PLAYER_LEVELUP;
            return this;
        }
        try {
            this.sound = Sound.valueOf((String)soundString);
        }
        catch (IllegalArgumentException e) {
            this.sound = Sound.ENTITY_PLAYER_LEVELUP;
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CEnchantment setName(String name) {
        this.name = name;
        return this;
    }

    public String getCustomName() {
        return this.customName;
    }

    public CEnchantment setCustomName(String customName) {
        this.customName = customName;
        return this;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public CEnchantment setActivated(boolean activated) {
        this.activated = activated;
        return this;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public CEnchantment setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public String getInfoName() {
        return this.infoName;
    }

    public CEnchantment setInfoName(String infoName) {
        this.infoName = ColorUtils.color(infoName);
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public CEnchantment setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getChanceIncrease() {
        return this.chanceIncrease;
    }

    public CEnchantment setChanceIncrease(int chanceIncrease) {
        this.chanceIncrease = chanceIncrease;
        return this;
    }

    public boolean hasChanceSystem() {
        return this.chance > 0;
    }

    public boolean chanceSuccessful(int enchantmentLevel) {
        return this.chanceSuccessful(enchantmentLevel, 1.0);
    }

    public boolean chanceSuccessful(int enchantmentLevel, double multiplier) {
        int newChance = this.chance + this.chanceIncrease * (enchantmentLevel - 1);
        int pickedChance = this.methods.getRandomNumber(0, 100);
        return (newChance = (int)((double)newChance * multiplier)) >= 100 || newChance <= 0 || pickedChance <= newChance;
    }

    public List<String> getInfoDescription() {
        return this.infoDescription;
    }

    public CEnchantment setInfoDescription(List<String> infoDescription) {
        ArrayList<String> info = new ArrayList<String>();
        infoDescription.forEach(lore -> info.add(ColorUtils.color(lore)));
        this.infoDescription = info;
        return this;
    }

    public CEnchantment addCategory(Category category) {
        if (category != null) {
            this.categories.add(category);
        }
        return this;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public CEnchantment setCategories(List<String> categories) {
        for (String categoryString : categories) {
            Category category = this.enchantmentBookSettings.getCategory(categoryString);
            if (category == null) continue;
            this.categories.add(category);
        }
        return this;
    }

    public EnchantmentType getEnchantmentType() {
        return this.enchantmentType;
    }

    public boolean canEnchantItem(@NotNull ItemStack item) {
        return this.enchantmentType != null && this.enchantmentType.canEnchantItem(item);
    }

    public CEnchantment setEnchantmentType(EnchantmentType enchantmentType) {
        this.enchantmentType = enchantmentType;
        return this;
    }

    public void registerEnchantment() {
        RegisteredCEnchantmentEvent event = new RegisteredCEnchantmentEvent(this.instance);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        this.crazyManager.registerEnchantment(this.instance);
        if (this.enchantmentType != null) {
            this.enchantmentType.addEnchantment(this.instance);
        }
        this.categories.forEach(category -> category.addEnchantment(this.instance));
    }

    public void unregisterEnchantment() {
        UnregisterCEnchantmentEvent event = new UnregisterCEnchantmentEvent(this.instance);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        this.crazyManager.unregisterEnchantment(this.instance);
        if (this.enchantmentType != null) {
            this.enchantmentType.removeEnchantment(this.instance);
        }
        this.categories.forEach(category -> category.addEnchantment(this.instance));
    }
}

