/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.builders;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    private Material material;
    private TrimMaterial trimMaterial;
    private TrimPattern trimPattern;
    private int damage;
    private Component itemName;
    private final List<Component> itemLore;
    private int itemAmount;
    private NamespacedKey itemModel;
    private String player;
    private boolean isHash;
    private boolean isURL;
    private boolean isHead;
    private boolean unbreakable;
    private boolean hideItemFlags;
    private boolean glowing;
    private final boolean isMobEgg;
    private EntityType entityType;
    private PotionType potionType;
    private Color potionColor;
    private boolean isPotion;
    private Color armorColor;
    private boolean isLeatherArmor;
    private Map<Enchantment, Integer> enchantments;
    private final Map<CEnchantment, Integer> crazyEnchantments;
    private boolean isShield;
    private boolean isBanner;
    private List<Pattern> patterns;
    private boolean isMap;
    private Color mapColor;
    private Map<String, String> namePlaceholders;
    private Map<String, String> lorePlaceholders;
    private ItemStack referenceItem;
    private List<ItemFlag> itemFlags;
    private int customModelData;
    private boolean useCustomModelData;
    private Map<NamespacedKey, String> namespaces;
    private static final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = plugin.getStarter();
    private final Server server = plugin.getServer();
    private final ComponentLogger logger = plugin.getComponentLogger();
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    private final EnchantmentBookSettings settings = this.starter.getEnchantmentBookSettings();

    public ItemBuilder() {
        this.material = Material.STONE;
        this.trimMaterial = null;
        this.trimPattern = null;
        this.damage = 0;
        this.itemName = null;
        this.itemLore = new ArrayList<Component>();
        this.itemAmount = 1;
        this.player = "";
        this.isHash = false;
        this.isURL = false;
        this.isHead = false;
        this.unbreakable = false;
        this.hideItemFlags = false;
        this.glowing = false;
        this.isMobEgg = false;
        this.entityType = EntityType.BAT;
        this.potionType = null;
        this.potionColor = null;
        this.isPotion = false;
        this.armorColor = null;
        this.isLeatherArmor = false;
        this.enchantments = new HashMap<Enchantment, Integer>();
        this.crazyEnchantments = new HashMap<CEnchantment, Integer>();
        this.isShield = false;
        this.isBanner = false;
        this.patterns = new ArrayList<Pattern>();
        this.isMap = false;
        this.mapColor = Color.RED;
        this.namePlaceholders = new HashMap<String, String>();
        this.lorePlaceholders = new HashMap<String, String>();
        this.itemFlags = new ArrayList<ItemFlag>();
        this.namespaces = new HashMap<NamespacedKey, String>();
    }

    public ItemBuilder(ItemBuilder itemBuilder) {
        this.material = itemBuilder.material;
        this.trimMaterial = itemBuilder.trimMaterial;
        this.trimPattern = itemBuilder.trimPattern;
        this.damage = itemBuilder.damage;
        this.itemName = itemBuilder.itemName;
        this.itemLore = new ArrayList<Component>(itemBuilder.itemLore);
        this.itemAmount = itemBuilder.itemAmount;
        this.player = itemBuilder.player;
        this.referenceItem = itemBuilder.referenceItem;
        this.customModelData = itemBuilder.customModelData;
        this.useCustomModelData = itemBuilder.useCustomModelData;
        this.enchantments = new HashMap<Enchantment, Integer>(itemBuilder.enchantments);
        this.crazyEnchantments = new HashMap<CEnchantment, Integer>(itemBuilder.crazyEnchantments);
        this.isHash = itemBuilder.isHash;
        this.isURL = itemBuilder.isURL;
        this.isHead = itemBuilder.isHead;
        this.unbreakable = itemBuilder.unbreakable;
        this.hideItemFlags = itemBuilder.hideItemFlags;
        this.glowing = itemBuilder.glowing;
        this.isMobEgg = itemBuilder.isMobEgg;
        this.entityType = itemBuilder.entityType;
        this.potionType = itemBuilder.potionType;
        this.potionColor = itemBuilder.potionColor;
        this.isPotion = itemBuilder.isPotion;
        this.armorColor = itemBuilder.armorColor;
        this.isLeatherArmor = itemBuilder.isLeatherArmor;
        this.isShield = itemBuilder.isShield;
        this.isBanner = itemBuilder.isBanner;
        this.patterns = new ArrayList<Pattern>(itemBuilder.patterns);
        this.isMap = itemBuilder.isMap;
        this.mapColor = itemBuilder.mapColor;
        this.namePlaceholders = new HashMap<String, String>(itemBuilder.namePlaceholders);
        this.lorePlaceholders = new HashMap<String, String>(itemBuilder.lorePlaceholders);
        this.itemFlags = new ArrayList<ItemFlag>(itemBuilder.itemFlags);
        this.namespaces = itemBuilder.namespaces;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean isBanner() {
        return this.isBanner;
    }

    public boolean isShield() {
        return this.isShield;
    }

    public boolean isMobEgg() {
        return this.isMobEgg;
    }

    public String getPlayerName() {
        return this.player;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getName() {
        return this.itemName == null ? "" : ColorUtils.toLegacy(this.itemName);
    }

    public List<Component> getLore() {
        return this.itemLore;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public Map<CEnchantment, Integer> getCrazyEnchantments() {
        return this.crazyEnchantments;
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    public boolean isItemFlagsHidden() {
        return this.hideItemFlags;
    }

    public boolean isLeatherArmor() {
        return this.isLeatherArmor;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public final String getUpdatedName() {
        if (this.itemName == null) {
            return "";
        }
        String newName = ColorUtils.toLegacy(this.itemName);
        for (Map.Entry<String, String> placeholder : this.namePlaceholders.entrySet()) {
            newName = newName.replace(placeholder.getKey(), placeholder.getValue()).replace(placeholder.getKey().toLowerCase(), placeholder.getValue());
        }
        return newName;
    }

    public ItemStack build() {
        ItemStack item;
        ItemStack itemStack = item = this.referenceItem != null ? this.referenceItem : new ItemStack(this.material);
        if (item.isEmpty()) {
            return item;
        }
        if (this.isHead) {
            ResolvableProfile.Builder builder = ResolvableProfile.resolvableProfile();
            if (this.isHash) {
                if (this.isURL) {
                    PlayerProfile profile = this.server.createProfile(UUID.randomUUID(), null);
                    profile.setProperty(new ProfileProperty("", ""));
                    PlayerTextures textures = profile.getTextures();
                    try {
                        textures.setSkin(URI.create(this.player).toURL(), PlayerTextures.SkinModel.CLASSIC);
                    }
                    catch (MalformedURLException exception) {
                        this.logger.warn("The url is malformed", (Throwable)exception);
                    }
                    profile.setTextures(textures);
                    builder.addProperties((Collection)profile.getProperties());
                } else {
                    builder.name(this.player);
                }
                item.setData(DataComponentTypes.PROFILE, (Object)((ResolvableProfile)builder.build()));
            }
            item.setAmount(this.itemAmount);
            if (!this.namespaces.isEmpty()) {
                item.editPersistentDataContainer(container -> this.namespaces.forEach((key, value) -> container.set(key, PersistentDataType.STRING, value)));
            }
            ItemMeta itemMeta = item.getItemMeta();
            List<Component> newLore = this.getUpdatedLore();
            if (!this.getUpdatedName().isEmpty()) {
                itemMeta.displayName((Component)ColorUtils.legacyTranslateColourCodes(this.getUpdatedName()));
            }
            if (!newLore.isEmpty()) {
                itemMeta.lore(newLore);
            }
            if (this.useCustomModelData) {
                itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            }
            this.itemFlags.forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
            item.setItemMeta(itemMeta);
            this.hideItemFlags(item);
            item.addUnsafeEnchantments(this.enchantments);
            this.addGlow(item);
            if (this.itemModel != null) {
                item.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel);
            }
            return item;
        }
        item.setAmount(this.itemAmount);
        if (!this.namespaces.isEmpty()) {
            item.editPersistentDataContainer(container -> this.namespaces.forEach((key, value) -> container.set(key, PersistentDataType.STRING, value)));
        }
        if (!this.crazyEnchantments.isEmpty()) {
            this.addEnchantments(item, this.crazyEnchantments);
        }
        ItemMeta itemMeta = item.getItemMeta();
        List<Component> newLore = this.getUpdatedLore();
        if (!this.getUpdatedName().isEmpty()) {
            itemMeta.displayName((Component)ColorUtils.legacyTranslateColourCodes(this.getUpdatedName()));
        }
        if (!newLore.isEmpty()) {
            itemMeta.lore(newLore);
        }
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(this.damage);
        }
        if (this.isPotion && (this.potionType != null || this.potionColor != null)) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            if (this.potionType != null) {
                potionMeta.setBasePotionType(this.potionType);
            }
            if (this.potionColor != null) {
                potionMeta.setColor(this.potionColor);
            }
        }
        if (this.material == Material.TIPPED_ARROW && this.potionType != null) {
            Arrow arrowMeta = (Arrow)itemMeta;
            arrowMeta.setBasePotionType(this.potionType);
        }
        if (this.isLeatherArmor && this.armorColor != null) {
            LeatherArmorMeta leatherMeta = (LeatherArmorMeta)itemMeta;
            leatherMeta.setColor(this.armorColor);
        }
        if (this.isBanner && !this.patterns.isEmpty()) {
            BannerMeta bannerMeta = (BannerMeta)itemMeta;
            bannerMeta.setPatterns(this.patterns);
        }
        if (this.isShield && !this.patterns.isEmpty()) {
            BlockStateMeta shieldMeta = (BlockStateMeta)itemMeta;
            Banner banner = (Banner)shieldMeta.getBlockState();
            banner.setPatterns(this.patterns);
            banner.update();
            shieldMeta.setBlockState((BlockState)banner);
        }
        if (this.useCustomModelData) {
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        if (this.unbreakable) {
            itemMeta.setUnbreakable(true);
        }
        this.itemFlags.forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
        item.setItemMeta(itemMeta);
        this.hideItemFlags(item);
        item.addUnsafeEnchantments(this.enchantments);
        this.addGlow(item);
        if (this.isMobEgg && itemMeta instanceof SpawnEggMeta) {
            ((SpawnEggMeta)itemMeta).setCustomSpawnedType(this.entityType);
        }
        if (this.itemModel != null) {
            item.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel);
        }
        return item;
    }

    public void addEnchantments(ItemStack itemStack, Map<CEnchantment, Integer> enchantments) {
        if (this.crazyManager != null) {
            this.crazyManager.addEnchantments(itemStack, enchantments);
            return;
        }
        Map<CEnchantment, Integer> currentEnchantments = this.settings.getEnchantments(itemStack);
        this.settings.removeEnchantments(itemStack, enchantments.keySet().stream().filter(currentEnchantments::containsKey).toList());
        String data = (String)itemStack.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        Enchant enchantData = data != null ? Methods.getGson().fromJson(data, Enchant.class) : new Enchant(new HashMap<String, Integer>());
        ArrayList<TextComponent> lore = itemStack.lore();
        if (lore == null) {
            lore = new ArrayList<TextComponent>();
        }
        for (Map.Entry<CEnchantment, Integer> entry : enchantments.entrySet()) {
            CEnchantment enchantment = entry.getKey();
            int level = entry.getValue();
            String loreString = enchantment.getCustomName() + " " + NumberUtils.convertLevelString(level);
            lore.add(ColorUtils.legacyTranslateColourCodes(loreString));
            for (Map.Entry<CEnchantment, Integer> x : enchantments.entrySet()) {
                enchantData.addEnchantment(x.getKey().getName(), x.getValue());
            }
        }
        itemStack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        itemStack.editPersistentDataContainer(container -> container.set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(enchantData)));
    }

    public ItemBuilder setItemModel(@NotNull String namespace, @NotNull String itemModel) {
        if (namespace.isEmpty() || itemModel.isEmpty()) {
            return this;
        }
        this.itemModel = new NamespacedKey(namespace, itemModel);
        return this;
    }

    public ItemBuilder setItemModel(@NotNull String itemModel) {
        if (itemModel.isEmpty()) {
            return this;
        }
        this.itemModel = NamespacedKey.minecraft((String)itemModel);
        return this;
    }

    public ItemBuilder setMaterial(Material material) {
        this.material = material;
        this.isHead = material == Material.PLAYER_HEAD;
        return this;
    }

    public ItemBuilder setTrimMaterial(TrimMaterial trimMaterial) {
        this.trimMaterial = trimMaterial;
        return this;
    }

    public ItemBuilder setTrimPattern(TrimPattern trimPattern) {
        this.trimPattern = trimPattern;
        return this;
    }

    public ItemBuilder setMaterial(String material) {
        if (material.contains(":")) {
            String modelData;
            String[] b = material.split(":");
            material = b[0];
            String metaData = b[1];
            if (metaData.contains("#") && NumberUtils.isInt(modelData = metaData.split("#")[1])) {
                this.useCustomModelData = true;
                this.customModelData = Integer.parseInt(modelData);
            }
            if (NumberUtils.isInt(metaData = metaData.replace("#" + this.customModelData, ""))) {
                this.damage = Integer.parseInt(metaData);
            } else {
                try {
                    this.potionType = this.getPotionType(PotionEffectType.getByName((String)metaData));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.potionColor = ColorUtils.getColor(metaData);
                this.armorColor = ColorUtils.getColor(metaData);
                this.mapColor = ColorUtils.getColor(metaData);
            }
        } else if (material.contains("#")) {
            String[] materialSplit = material.split("#");
            material = materialSplit[0];
            if (NumberUtils.isInt(materialSplit[1])) {
                this.useCustomModelData = true;
                this.customModelData = Integer.parseInt(materialSplit[1]);
            }
        }
        Material matchedMaterial = Material.matchMaterial((String)material);
        if (matchedMaterial != null) {
            this.material = matchedMaterial;
        }
        switch (this.material.name()) {
            case "PLAYER_HEAD": {
                this.isHead = true;
                break;
            }
            case "POTION": 
            case "SPLASH_POTION": {
                this.isPotion = true;
                break;
            }
            case "LEATHER_HELMET": 
            case "LEATHER_CHESTPLATE": 
            case "LEATHER_LEGGINGS": 
            case "LEATHER_BOOTS": 
            case "LEATHER_HORSE_ARMOR": {
                this.isLeatherArmor = true;
                break;
            }
            case "BANNER": {
                this.isBanner = true;
                break;
            }
            case "SHIELD": {
                this.isShield = true;
                break;
            }
            case "FILLED_MAP": {
                this.isMap = true;
            }
        }
        if (this.material.name().contains("BANNER")) {
            this.isBanner = true;
        }
        return this;
    }

    public ItemBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public int getDamage() {
        return this.damage;
    }

    public ItemBuilder setName(String itemName) {
        if (itemName != null && !itemName.isEmpty()) {
            this.itemName = ColorUtils.legacyTranslateColourCodes(itemName);
        }
        return this;
    }

    public ItemBuilder setName(Component itemName) {
        if (itemName != null) {
            this.itemName = itemName;
        }
        return this;
    }

    public ItemBuilder setNamePlaceholders(Map<String, String> placeholders) {
        this.namePlaceholders = placeholders;
        return this;
    }

    public ItemBuilder addNamePlaceholder(String placeholder, String argument) {
        this.namePlaceholders.put(placeholder, argument);
        return this;
    }

    public ItemBuilder removeNamePlaceholder(String placeholder) {
        this.namePlaceholders.remove(placeholder);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        return this.lore(lore.stream().map(ColorUtils::legacyTranslateColourCodes).collect(Collectors.toList()));
    }

    public ItemBuilder lore(List<Component> lore) {
        if (lore != null) {
            this.itemLore.clear();
            this.itemLore.addAll(lore);
        }
        return this;
    }

    public ItemBuilder addLore(String lore) {
        if (lore != null) {
            this.itemLore.add((Component)ColorUtils.legacyTranslateColourCodes(lore));
        }
        return this;
    }

    public ItemBuilder setLorePlaceholders(Map<String, String> placeholders) {
        this.lorePlaceholders = placeholders;
        return this;
    }

    public ItemBuilder addLorePlaceholder(String placeholder, String argument) {
        this.lorePlaceholders.put(placeholder, argument);
        return this;
    }

    public List<Component> getUpdatedLore() {
        ArrayList<Component> newLore = new ArrayList<Component>();
        if (this.itemLore.isEmpty()) {
            return newLore;
        }
        for (Component line : this.itemLore) {
            String newLine = ColorUtils.toLegacy(line);
            for (Map.Entry<String, String> placeholder : this.lorePlaceholders.entrySet()) {
                newLine = newLine.replace(placeholder.getKey(), placeholder.getValue()).replace(placeholder.getKey().toLowerCase(), placeholder.getValue());
            }
            newLore.add((Component)ColorUtils.legacyTranslateColourCodes(newLine));
        }
        return newLore;
    }

    public ItemBuilder removeLorePlaceholder(String placeholder) {
        this.lorePlaceholders.remove(placeholder);
        return this;
    }

    public ItemBuilder setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    private void addPattern(String patternName, String stringColour) {
        NamespacedKey key;
        try {
            key = NamespacedKey.minecraft((String)patternName.toLowerCase());
        }
        catch (Exception ignored) {
            return;
        }
        PatternType pattern = (PatternType)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(key);
        DyeColor colour = ItemBuilder.getDyeColor(stringColour);
        if (pattern == null || colour == null) {
            return;
        }
        this.addPattern(new Pattern(colour, pattern));
    }

    public ItemBuilder addPattern(Pattern pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public ItemBuilder setPattern(List<Pattern> patterns) {
        this.patterns = patterns;
        return this;
    }

    public int getAmount() {
        return this.itemAmount;
    }

    public ItemBuilder setAmount(int amount) {
        this.itemAmount = amount;
        return this;
    }

    public ItemBuilder addAmount(int amount) {
        this.itemAmount += amount;
        return this;
    }

    public ItemBuilder setPlayerName(@NotNull String playerName) {
        if (playerName.isEmpty()) {
            return this;
        }
        this.player = playerName;
        if (this.player.length() > 16) {
            this.isHash = true;
            this.isURL = this.player.startsWith("http");
        }
        return this;
    }

    public ItemBuilder setEnchantments(Map<Enchantment, Integer> enchantment) {
        if (enchantment != null) {
            this.enchantments = enchantment;
        }
        return this;
    }

    public ItemBuilder addEnchantments(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ItemBuilder addCEEnchantments(CEnchantment enchantment, int level) {
        this.crazyEnchantments.put(enchantment, level);
        return this;
    }

    public ItemBuilder addFlags(String flagString) {
        ItemFlag flag = this.getFlag(flagString);
        if (flag != null) {
            this.itemFlags.add(flag);
        }
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        if (itemFlag != null) {
            this.itemFlags.add(itemFlag);
        }
        return this;
    }

    public ItemBuilder setItemFlags(List<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
        return this;
    }

    public ItemBuilder hideItemFlags(boolean hideItemFlags) {
        this.hideItemFlags = hideItemFlags;
        return this;
    }

    public ItemStack hideItemFlags(ItemStack item) {
        if (this.hideItemFlags && item != null && item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            itemMeta.addItemFlags(ItemFlag.values());
            item.setItemMeta(itemMeta);
            return item;
        }
        return item;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public ItemBuilder setGlow(boolean glow) {
        this.glowing = glow;
        return this;
    }

    public static ItemBuilder convertString(String itemString) {
        return ItemBuilder.convertString(itemString, null);
    }

    public static ItemBuilder convertString(String itemString, String placeHolder) {
        ItemBuilder itemBuilder = new ItemBuilder();
        itemString = itemString.strip();
        try {
            block30: for (String optionString : itemString.split(", ")) {
                String option = optionString.split(":")[0];
                String value = optionString.replace(option + ":", "").replace(option, "");
                switch (option.toLowerCase()) {
                    case "item": {
                        itemBuilder.setMaterial(value);
                        continue block30;
                    }
                    case "name": {
                        itemBuilder.setName(value);
                        continue block30;
                    }
                    case "item-model": {
                        String[] splitter = value.split("!");
                        String namespace = splitter[0];
                        String key = splitter[1];
                        itemBuilder.setItemModel(namespace, key);
                        continue block30;
                    }
                    case "amount": {
                        try {
                            itemBuilder.setAmount(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            itemBuilder.setAmount(1);
                        }
                        continue block30;
                    }
                    case "damage": {
                        try {
                            itemBuilder.setDamage(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            itemBuilder.setDamage(0);
                        }
                        continue block30;
                    }
                    case "lore": {
                        itemBuilder.setLore(List.of(value.split(",")));
                        continue block30;
                    }
                    case "player": {
                        itemBuilder.setPlayerName(value);
                        continue block30;
                    }
                    case "unbreakable-item": {
                        if (!value.isEmpty() && !value.equalsIgnoreCase("true")) continue block30;
                        itemBuilder.setUnbreakable(true);
                        continue block30;
                    }
                    case "trim-pattern": {
                        if (value.isEmpty()) continue block30;
                        itemBuilder.setTrimPattern((TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.minecraft((String)value.toLowerCase())));
                        continue block30;
                    }
                    case "trim-material": {
                        if (value.isEmpty()) continue block30;
                        itemBuilder.setTrimMaterial((TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.minecraft((String)value.toLowerCase())));
                        continue block30;
                    }
                    default: {
                        String[] val;
                        if (value.contains("-") && (val = value.split("-")).length == 2 && NumberUtils.isInt(val[0]) && NumberUtils.isInt(val[1])) {
                            value = String.valueOf(ItemBuilder.getRandom(Integer.parseInt(val[0]), Integer.parseInt(val[1])));
                        }
                        int number = NumberUtils.isInt(value) ? Integer.parseInt(value) : 1;
                        Enchantment enchantment = ItemBuilder.getEnchantment(option);
                        if (enchantment != null) {
                            if (number == 0) continue block30;
                            itemBuilder.addEnchantments(enchantment, number);
                            continue block30;
                        }
                        CEnchantment ceEnchant = plugin.getStarter().getCrazyManager().getEnchantmentFromName(option);
                        if (ceEnchant != null) {
                            if (number == 0) continue block30;
                            itemBuilder.addCEEnchantments(ceEnchant, number);
                            continue block30;
                        }
                        for (ItemFlag itemFlag : ItemFlag.values()) {
                            if (!itemFlag.name().equalsIgnoreCase(option)) continue;
                            itemBuilder.addItemFlag(itemFlag);
                            break;
                        }
                        itemBuilder.addPattern(option, value);
                    }
                }
            }
        }
        catch (Exception e) {
            itemBuilder.setMaterial(Material.RED_TERRACOTTA).setName("&c&lERROR").lore(Arrays.asList(Component.text((String)"There was an error", (TextColor)NamedTextColor.RED), Component.text((String)("For : " + (placeHolder != null ? placeHolder : "")), (TextColor)NamedTextColor.RED)));
            plugin.getLogger().log(Level.WARNING, "There is an error with " + placeHolder, e);
        }
        return itemBuilder;
    }

    private static int getRandom(int min, int max) {
        Random random = new Random();
        return min + random.nextInt(++max - min);
    }

    public static List<ItemBuilder> convertStringList(List<String> itemStrings) {
        return ItemBuilder.convertStringList(itemStrings, null);
    }

    public static List<ItemBuilder> convertStringList(List<String> itemStrings, String placeholder) {
        return itemStrings.stream().map(itemString -> ItemBuilder.convertString(itemString, placeholder)).collect(Collectors.toList());
    }

    private void addGlow(ItemStack item) {
        if (item != null && this.glowing) {
            item.editMeta(itemMeta -> itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(true)));
        }
    }

    private PotionType getPotionType(PotionEffectType type) {
        if (type != null) {
            if (type.equals(PotionEffectType.FIRE_RESISTANCE)) {
                return PotionType.FIRE_RESISTANCE;
            }
            if (type.equals(PotionEffectType.INSTANT_DAMAGE)) {
                return PotionType.HARMING;
            }
            if (type.equals(PotionEffectType.INSTANT_HEALTH)) {
                return PotionType.HEALING;
            }
            if (type.equals(PotionEffectType.INVISIBILITY)) {
                return PotionType.INVISIBILITY;
            }
            if (type.equals(PotionEffectType.JUMP_BOOST)) {
                return PotionType.LEAPING;
            }
            if (type.equals(PotionEffectType.LUCK)) {
                return PotionType.LUCK;
            }
            if (type.equals(PotionEffectType.NIGHT_VISION)) {
                return PotionType.NIGHT_VISION;
            }
            if (type.equals(PotionEffectType.POISON)) {
                return PotionType.POISON;
            }
            if (type.equals(PotionEffectType.REGENERATION)) {
                return PotionType.REGENERATION;
            }
            if (type.equals(PotionEffectType.SLOWNESS)) {
                return PotionType.SLOWNESS;
            }
            if (type.equals(PotionEffectType.SPEED)) {
                return PotionType.SWIFTNESS;
            }
            if (type.equals(PotionEffectType.STRENGTH)) {
                return PotionType.STRENGTH;
            }
            if (type.equals(PotionEffectType.WATER_BREATHING)) {
                return PotionType.WATER_BREATHING;
            }
            if (type.equals(PotionEffectType.WEAKNESS)) {
                return PotionType.WEAKNESS;
            }
        }
        return null;
    }

    public static DyeColor getDyeColor(String color) {
        if (color != null) {
            try {
                return DyeColor.valueOf((String)color.toUpperCase());
            }
            catch (Exception e) {
                try {
                    String[] rgb = color.split(",");
                    return DyeColor.getByColor((Color)Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2])));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    private static Enchantment getEnchantment(String enchantmentName) {
        NamespacedKey key;
        try {
            key = NamespacedKey.minecraft((String)enchantmentName.toLowerCase());
        }
        catch (Exception ignored) {
            return null;
        }
        return (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(key);
    }

    private ItemFlag getFlag(String flagString) {
        for (ItemFlag flag : ItemFlag.values()) {
            if (!flag.name().equalsIgnoreCase(flagString)) continue;
            return flag;
        }
        return null;
    }

    public ItemBuilder addKey(@NotNull NamespacedKey key, String data) {
        this.namespaces.put(key, data);
        return this;
    }
}

