/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper;

import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.types.BaseMenu;
import com.badbones69.crazyenchantments.paper.api.builders.types.blacksmith.BlackSmithMenu;
import com.badbones69.crazyenchantments.paper.api.builders.types.gkitz.KitsMenu;
import com.badbones69.crazyenchantments.paper.api.builders.types.tinkerer.TinkererMenu;
import com.badbones69.crazyenchantments.paper.api.utils.FileUtils;
import com.badbones69.crazyenchantments.paper.commands.CECommand;
import com.badbones69.crazyenchantments.paper.commands.CETab;
import com.badbones69.crazyenchantments.paper.commands.CommandManager;
import com.badbones69.crazyenchantments.paper.commands.GkitzCommand;
import com.badbones69.crazyenchantments.paper.commands.GkitzTab;
import com.badbones69.crazyenchantments.paper.commands.TinkerCommand;
import com.badbones69.crazyenchantments.paper.controllers.BossBarController;
import com.badbones69.crazyenchantments.paper.controllers.LostBookController;
import com.badbones69.crazyenchantments.paper.enchantments.AllyEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.ArmorEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.AxeEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.BootEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.BowEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.HoeEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.PickaxeEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.SwordEnchantments;
import com.badbones69.crazyenchantments.paper.enchantments.ToolEnchantments;
import com.badbones69.crazyenchantments.paper.listeners.AuraListener;
import com.badbones69.crazyenchantments.paper.listeners.DustControlListener;
import com.badbones69.crazyenchantments.paper.listeners.FireworkDamageListener;
import com.badbones69.crazyenchantments.paper.listeners.MiscListener;
import com.badbones69.crazyenchantments.paper.listeners.ProtectionCrystalListener;
import com.badbones69.crazyenchantments.paper.listeners.ShopListener;
import com.badbones69.crazyenchantments.paper.listeners.server.WorldSwitchListener;
import com.ryderbelserion.fusion.paper.FusionPaper;
import libs.org.bstats.bukkit.Metrics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CrazyEnchantments
extends JavaPlugin {
    private Starter starter;
    public final PluginManager pluginManager = this.getServer().getPluginManager();
    private FireworkDamageListener fireworkDamageListener;
    private ArmorEnchantments armorEnchantments;
    private final BossBarController bossBarController = new BossBarController(this);
    private FusionPaper fusion;

    public void onEnable() {
        this.fusion = new FusionPaper(this);
        this.starter = new Starter();
        this.starter.run();
        this.starter.getCurrencyAPI().loadCurrency();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        FileConfiguration tinker = FileManager.Files.TINKER.getFile();
        if (!config.contains("Settings.CESuccessOverride")) {
            config.set("Settings.CESuccessOverride", (Object)"-1");
            FileManager.Files.CONFIG.saveFile();
        }
        if (!config.contains("Settings.CESuccessOverride")) {
            config.set("Settings.CEFailureOverride", (Object)"-1");
            FileManager.Files.CONFIG.saveFile();
        }
        if (!config.contains("Settings.Toggle-Metrics")) {
            config.set("Settings.Toggle-Metrics", (Object)false);
            FileManager.Files.CONFIG.saveFile();
        }
        if (!config.contains("Settings.Refresh-Potion-Effects-On-World-Change")) {
            config.set("Settings.Refresh-Potion-Effects-On-World-Change", (Object)false);
            FileManager.Files.CONFIG.saveFile();
        }
        if (!tinker.contains("Settings.Tinker-Version")) {
            tinker.set("Settings.Tinker-Version", (Object)1.0);
            FileManager.Files.TINKER.saveFile();
        }
        if (config.getBoolean("Settings.Toggle-Metrics")) {
            new Metrics((Plugin)this, 4494);
        }
        this.fireworkDamageListener = new FireworkDamageListener();
        this.pluginManager.registerEvents((Listener)this.fireworkDamageListener, (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ShopListener(), (Plugin)this);
        this.starter.getCrazyManager().load();
        this.pluginManager.registerEvents((Listener)new MiscListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new DustControlListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlackSmithMenu.BlackSmithListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new KitsMenu.KitsListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new TinkererMenu.TinkererListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BaseMenu.InfoMenuListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PickaxeEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new SwordEnchantments(), (Plugin)this);
        this.armorEnchantments = new ArmorEnchantments();
        this.pluginManager.registerEvents((Listener)this.armorEnchantments, (Plugin)this);
        this.pluginManager.registerEvents((Listener)new AllyEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ToolEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BootEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new AxeEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BowEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new HoeEnchantments(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new ProtectionCrystalListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new FireworkDamageListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new AuraListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new LostBookController(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new WorldSwitchListener(), (Plugin)this);
        if (this.starter.getCrazyManager().isGkitzEnabled()) {
            this.getLogger().info("G-Kitz support is now enabled.");
            this.pluginManager.registerEvents((Listener)new KitsMenu.KitsListener(), (Plugin)this);
        }
        this.registerCommand(this.getCommand("crazyenchantments"), new CETab(), new CECommand());
        this.registerCommand(this.getCommand("tinkerer"), null, new TinkerCommand());
        this.registerCommand(this.getCommand("gkit"), new GkitzTab(), new GkitzCommand());
        CommandManager.load();
        FileUtils.loadFiles();
    }

    public void onDisable() {
        this.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)this);
        this.getServer().getAsyncScheduler().cancelTasks((Plugin)this);
        this.bossBarController.removeAllBossBars();
        if (this.armorEnchantments != null) {
            this.armorEnchantments.stop();
        }
        if (this.starter.getAllyManager() != null) {
            this.starter.getAllyManager().forceRemoveAllies();
        }
        this.getServer().getOnlinePlayers().forEach(this.starter.getCrazyManager()::unloadCEPlayer);
    }

    private void registerCommand(PluginCommand pluginCommand, TabCompleter tabCompleter, CommandExecutor commandExecutor) {
        if (pluginCommand != null) {
            pluginCommand.setExecutor(commandExecutor);
            if (tabCompleter != null) {
                pluginCommand.setTabCompleter(tabCompleter);
            }
        }
    }

    public Starter getStarter() {
        return this.starter;
    }

    public FireworkDamageListener getFireworkDamageListener() {
        return this.fireworkDamageListener;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public BossBarController getBossBarController() {
        return this.bossBarController;
    }

    public boolean isLogging() {
        return true;
    }

    @NotNull
    public final FusionPaper getFusion() {
        return this.fusion;
    }
}

