/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.listeners;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.enums.Messages;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ProtectionCrystalListener
implements Listener {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final ProtectionCrystalSettings protectionCrystalSettings = this.starter.getProtectionCrystalSettings();

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item;
        Player player = (Player)event.getWhoClicked();
        ItemStack crystalItem = event.getCursor();
        ItemStack itemStack = item = event.getCurrentItem() != null ? event.getCurrentItem() : new ItemStack(Material.AIR);
        if (item.getType() == Material.AIR || crystalItem.getType() == Material.AIR) {
            return;
        }
        if (!this.protectionCrystalSettings.isProtectionCrystal(crystalItem)) {
            return;
        }
        if (this.protectionCrystalSettings.isProtectionCrystal(item)) {
            return;
        }
        if (ProtectionCrystalSettings.isProtected(item.getPersistentDataContainer())) {
            return;
        }
        if (item.getAmount() > 1 || crystalItem.getAmount() > 1) {
            player.sendMessage(Messages.NEED_TO_UNSTACK_ITEM.getMessage());
            return;
        }
        event.setCancelled(true);
        player.setItemOnCursor(this.methods.removeItem(crystalItem));
        event.setCurrentItem(this.protectionCrystalSettings.addProtection(item));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getKeepInventory()) {
            return;
        }
        Player player = event.getEntity();
        ArrayList<ItemStack> savedItems = new ArrayList<ItemStack>();
        for (ItemStack item2 : event.getDrops()) {
            if (!ProtectionCrystalSettings.isProtected(item2.getPersistentDataContainer()) || !this.protectionCrystalSettings.isProtectionSuccessful(player)) continue;
            savedItems.add(item2);
        }
        savedItems.forEach(item -> event.getDrops().remove(item));
        this.protectionCrystalSettings.addPlayer(player, savedItems);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.protectionCrystalSettings.containsPlayer(player)) {
            if (FileManager.Files.CONFIG.getFile().getBoolean("Settings.ProtectionCrystal.Lose-Protection-On-Death", true)) {
                for (ItemStack item : this.protectionCrystalSettings.getCrystalItems().get(player.getUniqueId())) {
                    player.getInventory().addItem(new ItemStack[]{this.protectionCrystalSettings.removeProtection(item)});
                }
            } else {
                for (ItemStack item : this.protectionCrystalSettings.getPlayer(player)) {
                    player.getInventory().addItem(new ItemStack[]{item});
                }
            }
            this.protectionCrystalSettings.removePlayer(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCrystalClick(PlayerInteractEvent event) {
        if (this.protectionCrystalSettings.isProtectionCrystal(this.methods.getItemInHand(event.getPlayer()))) {
            event.setCancelled(true);
        }
    }
}

