/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.internal.ConversionUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.ArrayPropertyType;
import ch.jalu.configme.properties.types.InlineArrayPropertyType;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.typeresolver.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumPropertyType<E extends Enum<E>>
implements PropertyType<E> {
    private final Class<E> enumType;

    public EnumPropertyType(@NotNull Class<E> enumType) {
        this.enumType = enumType;
    }

    @NotNull
    public static <E extends Enum<E>> EnumPropertyType<E> of(@NotNull Class<E> type) {
        return new EnumPropertyType<E>(type);
    }

    @Override
    @Nullable
    public E convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof String) {
            return (E)((Enum)EnumUtils.tryValueOfCaseInsensitive(this.enumType, (String)object).orElse(null));
        }
        if (this.enumType.isInstance(object)) {
            return (E)((Enum)object);
        }
        return null;
    }

    @NotNull
    public String toExportValue(@NotNull E value) {
        return ((Enum)value).name();
    }

    @NotNull
    public final Class<E> getEnumClass() {
        return this.enumType;
    }

    @NotNull
    public ArrayPropertyType<E> arrayType() {
        return new ArrayPropertyType(this, size -> (Enum[])ConversionUtils.createArrayForReferenceType(this.enumType, size));
    }

    @NotNull
    public InlineArrayPropertyType<E> inlineArrayType(@NotNull String separator) {
        return new InlineArrayPropertyType(this, separator, true, size -> (Enum[])ConversionUtils.createArrayForReferenceType(this.enumType, size));
    }
}

