/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.resource.PropertyResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsManagerImpl
implements SettingsManager {
    private final ConfigurationData configurationData;
    private final PropertyResource resource;
    private final MigrationService migrationService;

    protected SettingsManagerImpl(@NotNull PropertyResource resource, @NotNull ConfigurationData configurationData, @Nullable MigrationService migrationService) {
        this.configurationData = configurationData;
        this.resource = resource;
        this.migrationService = migrationService;
        this.loadFromResourceAndValidate();
    }

    @Override
    @NotNull
    public <T> T getProperty(@NotNull Property<T> property) {
        return this.configurationData.getValue(property);
    }

    @Override
    public <T> void setProperty(@NotNull Property<T> property, @NotNull T value) {
        this.configurationData.setValue(property, value);
    }

    @Override
    public void reload() {
        this.loadFromResourceAndValidate();
    }

    @Override
    public void save() {
        this.resource.exportProperties(this.configurationData);
    }

    protected void loadFromResourceAndValidate() {
        PropertyReader reader = this.resource.createReader();
        this.configurationData.initializeValues(reader);
        if (this.migrationService != null && this.migrationService.checkAndMigrate(reader, this.configurationData)) {
            this.save();
        }
    }

    @NotNull
    protected final PropertyResource getPropertyResource() {
        return this.resource;
    }

    @NotNull
    protected final ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    @Nullable
    protected final MigrationService getMigrationService() {
        return this.migrationService;
    }
}

