/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.commands;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.CrazyManager;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CETab
implements TabCompleter {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = this.plugin.getStarter();
    private final Methods methods = this.starter.getMethods();
    private final CrazyManager crazyManager = this.starter.getCrazyManager();
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String commandLabel, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (this.hasPermission(sender, "access")) {
                completions.add("help");
            }
            if (this.hasPermission(sender, "debug")) {
                completions.add("debug");
            }
            if (this.hasPermission(sender, "limit")) {
                completions.add("limit");
            }
            if (this.hasPermission(sender, "info")) {
                completions.add("info");
            }
            if (this.hasPermission(sender, "reload")) {
                completions.add("reload");
            }
            if (this.hasPermission(sender, "remove")) {
                completions.add("remove");
            }
            if (this.hasPermission(sender, "add")) {
                completions.add("add");
            }
            if (this.hasPermission(sender, "spawn")) {
                completions.add("spawn");
            }
            if (this.hasPermission(sender, "scroll")) {
                completions.add("scroll");
            }
            if (this.hasPermission(sender, "crystal")) {
                completions.add("crystal");
            }
            if (this.hasPermission(sender, "scrambler")) {
                completions.add("scrambler");
            }
            if (this.hasPermission(sender, "dust")) {
                completions.add("dust");
            }
            if (this.hasPermission(sender, "book")) {
                completions.add("book");
            }
            if (this.hasPermission(sender, "lostbook")) {
                completions.add("lostbook");
            }
            if (this.hasPermission(sender, "updateenchants")) {
                completions.add("updateEnchants");
            }
            if (this.hasPermission(sender, "give")) {
                completions.add("give");
            }
            if (this.hasPermission(sender, "bottle")) {
                completions.add("bottle");
            }
            if (this.hasPermission(sender, "slotcrystal")) {
                completions.add("slotcrystal");
            }
            if (this.hasPermission(sender, "checkenchants")) {
                completions.add("check-enchants");
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], completions, new ArrayList());
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "info": 
                case "add": 
                case "book": {
                    for (CEnchantment enchantment2 : this.crazyManager.getRegisteredEnchantments()) {
                        try {
                            completions.add(ColorUtils.stripStringColour(enchantment2.getCustomName().replaceAll(" ", "_")));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    Arrays.asList(Enchantment.values()).forEach(enchantment -> completions.add(enchantment.getKey().getKey()));
                    break;
                }
                case "remove": {
                    this.enchantmentBookSettings.getEnchantments(((Player)sender).getInventory().getItemInMainHand()).forEach((a, b) -> completions.add(ColorUtils.stripStringColour(a.getCustomName())));
                    break;
                }
                case "spawn": {
                    for (CEnchantment enchantment3 : this.crazyManager.getRegisteredEnchantments()) {
                        try {
                            completions.add(ColorUtils.stripStringColour(enchantment3.getCustomName()));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    for (Category category : this.enchantmentBookSettings.getCategories()) {
                        try {
                            completions.add(category.getName());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    break;
                }
                case "scroll": {
                    completions.add("black");
                    completions.add("white");
                    completions.add("transmog");
                    break;
                }
                case "crystal": 
                case "scrambler": 
                case "slotcrystal": {
                    completions.add("1");
                    completions.add("32");
                    completions.add("64");
                    break;
                }
                case "dust": {
                    for (Dust dust : Dust.values()) {
                        completions.addAll(dust.getKnownNames());
                    }
                    break;
                }
                case "lostbook": {
                    for (Category category : this.enchantmentBookSettings.getCategories()) {
                        try {
                            completions.add(category.getName());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    break;
                }
                case "give": 
                case "bottle": 
                case "check-enchants": {
                    this.plugin.getServer().getOnlinePlayers().forEach(player -> completions.add(player.getName()));
                }
            }
            return (List)StringUtil.copyPartialMatches((String)args[1], completions, new ArrayList());
        }
        if (args.length == 3) {
            switch (args[0].toLowerCase()) {
                case "book": {
                    CEnchantment ceEnchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                    if (ceEnchantment == null) break;
                    for (int amount = 1; amount <= ceEnchantment.getMaxLevel(); ++amount) {
                        completions.add(String.valueOf(amount));
                    }
                    break;
                }
                case "add": {
                    CEnchantment ceEnchantment = this.crazyManager.getEnchantmentFromName(args[1]);
                    Enchantment vanillaEnchantment = this.methods.getEnchantment(args[1]);
                    if (vanillaEnchantment == null && ceEnchantment == null) break;
                    int maxLevel = vanillaEnchantment != null ? vanillaEnchantment.getMaxLevel() : ceEnchantment.getMaxLevel();
                    for (int amount = 1; amount <= maxLevel; ++amount) {
                        completions.add(String.valueOf(amount));
                    }
                    break;
                }
                case "spawn": {
                    completions.add("Level:");
                    completions.add("World:");
                    completions.add("X:");
                    completions.add("Y:");
                    completions.add("Z:");
                    break;
                }
                case "scroll": 
                case "dust": 
                case "lostbook": 
                case "bottle": {
                    completions.add("1");
                    completions.add("32");
                    completions.add("64");
                    break;
                }
                case "crystal": 
                case "scrambler": 
                case "slotcrystal": {
                    this.plugin.getServer().getOnlinePlayers().forEach(player -> completions.add(player.getName()));
                    break;
                }
                case "give": {
                    completions.add("Item:DIAMOND_HELMET, Amount:1, Name:&6&lHat, Protection:4, Overload:1-5, Hulk:2-5, Lore:&aLine 1.,&aLine 2.");
                }
            }
            return (List)StringUtil.copyPartialMatches((String)args[2], completions, new ArrayList());
        }
        if (args.length == 4) {
            switch (args[0].toLowerCase()) {
                case "spawn": {
                    completions.add("Level:");
                    completions.add("World:");
                    completions.add("X:");
                    completions.add("Y:");
                    completions.add("Z:");
                    break;
                }
                case "scroll": 
                case "dust": 
                case "lostbook": {
                    this.plugin.getServer().getOnlinePlayers().forEach(player -> completions.add(player.getName()));
                    break;
                }
                case "bottle": {
                    completions.add("1");
                    completions.add("32");
                    completions.add("64");
                    break;
                }
                default: {
                    return (List)StringUtil.copyPartialMatches((String)args[3], completions, new ArrayList());
                }
            }
        } else {
            if (args.length == 5) {
                switch (args[0].toLowerCase()) {
                    case "spawn": {
                        completions.add("Level:");
                        completions.add("World:");
                        completions.add("X:");
                        completions.add("Y:");
                        completions.add("Z:");
                        break;
                    }
                    case "dust": {
                        completions.add("1");
                        completions.add("25");
                        completions.add("50");
                        completions.add("75");
                        completions.add("100");
                    }
                }
                return (List)StringUtil.copyPartialMatches((String)args[4], completions, new ArrayList());
            }
            if (args[0].equalsIgnoreCase("spawn")) {
                completions.add("Level:");
                completions.add("World:");
                completions.add("X:");
                completions.add("Y:");
                completions.add("Z:");
            }
            return (List)StringUtil.copyPartialMatches((String)args[args.length - 1], completions, new ArrayList());
        }
        return completions;
    }

    private boolean hasPermission(CommandSender sender, String node) {
        return sender.hasPermission("crazyenchantments." + node) || sender.hasPermission("crazyenchantments.admin");
    }
}

