/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api.enums;

import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public enum Scrolls {
    BLACK_SCROLL("Black-Scroll", "BlackScroll", Arrays.asList("b", "black", "blackscroll")),
    WHITE_SCROLL("White-Scroll", "WhiteScroll", Arrays.asList("w", "white", "whitescroll")),
    TRANSMOG_SCROLL("Transmog-Scroll", "TransmogScroll", Arrays.asList("t", "transmog", "transmogscroll"));

    private static final HashMap<Scrolls, ItemBuilder> itemBuilderScrolls;
    private final String name;
    private final String configName;
    private final List<String> knownNames;
    private static final NamespacedKey scroll;
    private static final NamespacedKey whiteScrollProtectionKey;

    private Scrolls(String name, String configName, List<String> knowNames) {
        this.name = name;
        this.knownNames = knowNames;
        this.configName = configName;
    }

    public static void loadScrolls() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        itemBuilderScrolls.clear();
        for (Scrolls scroll : Scrolls.values()) {
            String path = "Settings." + scroll.getConfigName() + ".";
            itemBuilderScrolls.put(scroll, new ItemBuilder().setName(config.getString(path + "Name", "Error getting name.")).setLore(config.getStringList(path + "Item-Lore")).setItemModel(config.getString(path + "Model.Namespace", ""), config.getString(path + "Model.Key", "")).setMaterial(config.getString(path + "Item", "BOOK")).setGlow(config.getBoolean(path + "Glowing", false)));
        }
    }

    public static Scrolls getFromName(String nameString) {
        for (Scrolls scroll : Scrolls.values()) {
            if (!scroll.getKnownNames().contains(nameString.toLowerCase())) continue;
            return scroll;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getKnownNames() {
        return this.knownNames;
    }

    public String getConfigName() {
        return this.configName;
    }

    public static Scrolls getFromPDC(ItemStack item) {
        PersistentDataContainerView data = item.getPersistentDataContainer();
        if (!data.has(scroll)) {
            return null;
        }
        return Scrolls.getFromName((String)data.get(scroll, PersistentDataType.STRING));
    }

    public ItemStack getScroll() {
        ItemStack item = itemBuilderScrolls.get((Object)this).build();
        item.editPersistentDataContainer(container -> container.set(scroll, PersistentDataType.STRING, (Object)this.configName));
        return item;
    }

    public ItemStack getScroll(int amount) {
        ItemStack item = itemBuilderScrolls.get((Object)this).setAmount(amount).build();
        item.editPersistentDataContainer(container -> container.set(scroll, PersistentDataType.STRING, (Object)this.configName));
        return item;
    }

    public static String getWhiteScrollProtectionName() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        String protectNamed = ColorUtils.color(config.getString("Settings.WhiteScroll.ProtectedName"));
        return protectNamed;
    }

    public static boolean hasWhiteScrollProtection(@NotNull ItemStack item) {
        return Scrolls.hasWhiteScrollProtection(item.getPersistentDataContainer());
    }

    public static boolean hasWhiteScrollProtection(@NotNull PersistentDataContainerView data) {
        return data.has(whiteScrollProtectionKey);
    }

    public static ItemStack addWhiteScrollProtection(@NotNull ItemStack item) {
        ItemLore itemLore = (ItemLore)item.getData(DataComponentTypes.LORE);
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>(itemLore != null ? itemLore.styledLines() : new ArrayList());
        lore.add(ColorUtils.legacyTranslateColourCodes(Scrolls.getWhiteScrollProtectionName()));
        item.editPersistentDataContainer(container -> container.set(whiteScrollProtectionKey, PersistentDataType.BOOLEAN, (Object)true));
        item.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        return item;
    }

    public static ItemStack removeWhiteScrollProtection(@NotNull ItemStack item) {
        List lore;
        if (item.getPersistentDataContainer().has(whiteScrollProtectionKey, PersistentDataType.BOOLEAN)) {
            item.editPersistentDataContainer(container -> container.remove(whiteScrollProtectionKey));
        }
        if ((lore = item.lore()) == null || lore.isEmpty()) {
            return item;
        }
        lore.removeIf(loreComponent -> ColorUtils.toPlainText(loreComponent).contains(ColorUtils.stripStringColour(Scrolls.getWhiteScrollProtectionName())));
        item.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(lore).build()));
        return item;
    }

    static {
        itemBuilderScrolls = new HashMap();
        scroll = DataKeys.scroll.getNamespacedKey();
        whiteScrollProtectionKey = DataKeys.white_scroll_protection.getNamespacedKey();
    }
}

