/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.api;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.FileManager;
import com.badbones69.crazyenchantments.paper.api.builders.ItemBuilder;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.enums.Dust;
import com.badbones69.crazyenchantments.paper.api.enums.Scrolls;
import com.badbones69.crazyenchantments.paper.api.enums.ShopOption;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.DataKeys;
import com.badbones69.crazyenchantments.paper.api.enums.pdc.Enchant;
import com.badbones69.crazyenchantments.paper.api.managers.AllyManager;
import com.badbones69.crazyenchantments.paper.api.managers.ArmorEnchantmentManager;
import com.badbones69.crazyenchantments.paper.api.managers.BowEnchantmentManager;
import com.badbones69.crazyenchantments.paper.api.managers.ShopManager;
import com.badbones69.crazyenchantments.paper.api.managers.WingsManager;
import com.badbones69.crazyenchantments.paper.api.objects.CEBook;
import com.badbones69.crazyenchantments.paper.api.objects.CEPlayer;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.objects.Category;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GKitz;
import com.badbones69.crazyenchantments.paper.api.objects.gkitz.GkitCoolDown;
import com.badbones69.crazyenchantments.paper.api.utils.ColorUtils;
import com.badbones69.crazyenchantments.paper.api.utils.NumberUtils;
import com.badbones69.crazyenchantments.paper.api.utils.WingsUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.controllers.settings.ProtectionCrystalSettings;
import com.badbones69.crazyenchantments.paper.listeners.ScramblerListener;
import com.badbones69.crazyenchantments.paper.listeners.ScrollListener;
import com.badbones69.crazyenchantments.paper.listeners.SlotCrystalListener;
import com.badbones69.crazyenchantments.paper.support.CropManager;
import com.badbones69.crazyenchantments.paper.support.interfaces.CropManagerVersion;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.scheduler.FoliaScheduler;
import com.ryderbelserion.fusion.paper.scheduler.Scheduler;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CrazyManager {
    @NotNull
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final FusionPaper fusion = this.plugin.getFusion();
    @NotNull
    private final Starter starter = this.plugin.getStarter();
    @NotNull
    private final Methods methods = this.starter.getMethods();
    @NotNull
    private final ProtectionCrystalSettings protectionCrystalSettings = this.starter.getProtectionCrystalSettings();
    @NotNull
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();
    @NotNull
    private final ScramblerListener scramblerListener = this.starter.getScramblerListener();
    @NotNull
    private final ScrollListener scrollListener = this.starter.getScrollListener();
    @NotNull
    private final SlotCrystalListener slotCrystalListener = this.starter.getSlotCrystalListener();
    private CropManagerVersion cropManagerVersion;
    @NotNull
    private final AllyManager allyManager = this.starter.getAllyManager();
    @NotNull
    private final WingsManager wingsManager = this.starter.getWingsManager();
    @NotNull
    private final ShopManager shopManager = this.starter.getShopManager();
    @NotNull
    private final BowEnchantmentManager bowEnchantmentManager = this.starter.getBowEnchantmentManager();
    @NotNull
    private final ArmorEnchantmentManager armorEnchantmentManager = this.starter.getArmorEnchantmentManager();
    private final List<GKitz> gkitz = new ArrayList<GKitz>();
    private final List<CEPlayer> players = new ArrayList<CEPlayer>();
    private final List<Material> blockList = new ArrayList<Material>();
    private final Map<Material, Double> headMap = new HashMap<Material, Double>();
    private int rageMaxLevel;
    private boolean gkitzToggle;
    private boolean useUnsafeEnchantments;
    private boolean breakRageOnDamage;
    private boolean useRageBossBar;
    private double rageIncrement;
    private boolean maxEnchantmentCheck;
    private boolean checkVanillaLimit;
    private boolean dropBlocksBlast;
    private boolean dropBlocksVeinMiner;
    private int defaultLimit;
    private int defaultBaseLimit;
    private boolean useEnchantmentLimiter;
    private boolean useConfigLimits;
    private int CESuccessOverride;
    private int CEFailureOverride;

    public void load() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        FileConfiguration gkit = FileManager.Files.GKITZ.getFile();
        FileConfiguration enchants = FileManager.Files.ENCHANTMENTS.getFile();
        FileConfiguration blocks = FileManager.Files.BLOCKLIST.getFile();
        FileConfiguration heads = FileManager.Files.HEADMAP.getFile();
        this.blockList.clear();
        this.headMap.clear();
        this.gkitz.clear();
        this.enchantmentBookSettings.getRegisteredEnchantments().clear();
        this.enchantmentBookSettings.getCategories().clear();
        this.starter.getPluginSupport().updateHooks();
        boolean playerHealthPatch = config.getBoolean("Settings.Reset-Players-Max-Health", true);
        this.plugin.getServer().getOnlinePlayers().forEach(player -> {
            this.loadCEPlayer((Player)player);
            Attribute genericAttribute = Attribute.MAX_HEALTH;
            double baseValue = player.getAttribute(genericAttribute).getBaseValue();
            if (playerHealthPatch) {
                player.getAttribute(genericAttribute).setBaseValue(baseValue);
            }
            new FoliaScheduler(this.plugin, Scheduler.global_scheduler, TimeUnit.MINUTES){

                @Override
                public void run() {
                    CrazyManager.this.getCEPlayers().forEach(player -> CrazyManager.this.backupCEPlayer(player.getPlayer()));
                }
            }.runAtFixedRate(5L, 5L);
        });
        CEnchantments.invalidateCachedEnchants();
        blocks.getStringList("Block-List").forEach(id -> {
            try {
                this.blockList.add(new ItemBuilder().setMaterial((String)id).getMaterial());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ConfigurationSection headSec = heads.getConfigurationSection("HeadOdds");
        if (headSec == null) {
            this.fusion.log("warn", "HeadOdds could not be found in HeadMap.yml!", new Object[0]);
        } else {
            headSec.getKeys(false).forEach(id -> {
                try {
                    Material mat = new ItemBuilder().setMaterial((String)id).getMaterial();
                    this.headMap.put(mat, headSec.getDouble(id));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        Scrolls.getWhiteScrollProtectionName();
        this.enchantmentBookSettings.setEnchantmentBook(new ItemBuilder().setMaterial(config.getString("Settings.Enchantment-Book-Item", "BOOK")));
        this.useUnsafeEnchantments = config.getBoolean("Settings.EnchantmentOptions.UnSafe-Enchantments", true);
        this.maxEnchantmentCheck = config.getBoolean("Settings.EnchantmentOptions.MaxAmountOfEnchantmentsToggle", true);
        this.useConfigLimits = config.getBoolean("Settings.EnchantmentOptions.Limit.Check-Perms", false);
        this.defaultLimit = config.getInt("Settings.EnchantmentOptions.Limit.Default-Limit", 0);
        this.defaultBaseLimit = config.getInt("Settings.EnchantmentOptions.Limit.Default-Base-Limit", 0);
        this.useEnchantmentLimiter = config.getBoolean("Settings.EnchantmentOptions.Limit.Enable-SlotCrystal", true);
        this.checkVanillaLimit = config.getBoolean("Settings.EnchantmentOptions.IncludeVanillaEnchantments", false);
        this.gkitzToggle = !config.contains("Settings.GKitz.Enabled") || config.getBoolean("Settings.GKitz.Enabled", true);
        this.rageMaxLevel = config.getInt("Settings.EnchantmentOptions.MaxRageLevel", 4);
        this.breakRageOnDamage = config.getBoolean("Settings.EnchantmentOptions.Break-Rage-On-Damage", true);
        this.useRageBossBar = config.getBoolean("Settings.EnchantmentOptions.Rage-Boss-Bar", false);
        this.rageIncrement = config.getDouble("Settings.EnchantmentOptions.Rage-Increase", 0.1);
        this.setDropBlocksBlast(config.getBoolean("Settings.EnchantmentOptions.Drop-Blocks-For-Blast", true));
        this.setDropBlocksVeinMiner(config.getBoolean("Settings.EnchantmentOptions.Drop-Blocks-For-VeinMiner", true));
        this.CEFailureOverride = config.getInt("Settings.CEFailureOverride", -1);
        this.CESuccessOverride = config.getInt("Settings.CESuccessOverride", -1);
        this.enchantmentBookSettings.populateMaps();
        for (CEnchantments cEnchantment : CEnchantments.values()) {
            String name = cEnchantment.getName();
            String path = "Enchantments." + name;
            if (!enchants.contains(path)) continue;
            CEnchantment enchantment = new CEnchantment(name).setCustomName(enchants.getString(path + ".Name")).setActivated(enchants.getBoolean(path + ".Enabled")).setMaxLevel(enchants.getInt(path + ".MaxPower")).setEnchantmentType(cEnchantment.getType()).setInfoName(enchants.getString(path + ".Info.Name")).setInfoDescription(enchants.getStringList(path + ".Info.Description")).setCategories(enchants.getStringList(path + ".Categories")).setChance(cEnchantment.getChance()).setChanceIncrease(cEnchantment.getChanceIncrease()).setSound(enchants.getString(path + ".Sound")).setConflicts(enchants.getStringList(path + ".Conflicts"));
            if (enchants.contains(path + ".Enchantment-Type")) {
                enchantment.setEnchantmentType(this.methods.getFromName(enchants.getString(path + ".Enchantment-Type")));
            }
            if (cEnchantment.hasChanceSystem()) {
                if (enchants.contains(path + ".Chance-System.Base")) {
                    enchantment.setChance(enchants.getInt(path + ".Chance-System.Base"));
                } else {
                    enchantment.setChance(cEnchantment.getChance());
                }
                if (enchants.contains(path + ".Chance-System.Increase")) {
                    enchantment.setChanceIncrease(enchants.getInt(path + ".Chance-System.Increase"));
                } else {
                    enchantment.setChanceIncrease(cEnchantment.getChanceIncrease());
                }
            }
            enchantment.registerEnchantment();
        }
        if (this.gkitzToggle) {
            ConfigurationSection section = gkit.getConfigurationSection("GKitz");
            if (section == null) {
                this.fusion.log("warn", "The gkitz section cannot be found in gkitz.yml, It's possible the file is badly formatted!", new Object[0]);
            } else {
                for (String kit : section.getKeys(false)) {
                    String path = "GKitz." + kit + ".";
                    int slot = gkit.getInt(path + "Display.Slot");
                    String time = gkit.getString(path + "Cooldown");
                    boolean autoEquip = gkit.getBoolean(path + "Auto-Equip");
                    ItemStack displayItem = new ItemBuilder().setMaterial(gkit.getString(path + "Display.Item", ColorUtils.getRandomPaneColor().getName())).setItemModel(gkit.getString(path + "Display.Model.Namespace", ""), gkit.getString(path + "Display.Model.Key", "")).setName(gkit.getString(path + "Display.Name", "Error getting name.")).setLore(gkit.getStringList(path + "Display.Lore")).setGlow(gkit.getBoolean(path + "Display.Glowing", false)).addKey(DataKeys.gkit_type.getNamespacedKey(), kit).build();
                    List commands = gkit.getStringList(path + "Commands");
                    List itemStrings = gkit.getStringList(path + "Items");
                    List<ItemStack> previewItems = this.getInfoGKit(itemStrings);
                    previewItems.addAll(this.getInfoGKit(gkit.getStringList(path + "Fake-Items")));
                    this.gkitz.add(new GKitz(kit, slot, time, displayItem, previewItems, commands, itemStrings, autoEquip));
                }
            }
        }
        Scrolls.loadScrolls();
        Dust.loadDust();
        this.protectionCrystalSettings.loadProtectionCrystal();
        this.scramblerListener.loadScrambler();
        this.slotCrystalListener.load();
        this.scrollListener.loadScrollControl();
        this.cropManagerVersion = new CropManager();
        Scrolls.loadScrolls();
        Dust.loadDust();
        ShopOption.loadShopOptions();
        this.shopManager.load();
        this.wingsManager.load();
        this.bowEnchantmentManager.load();
        this.armorEnchantmentManager.load();
        this.allyManager.load();
        WingsUtils.startWings();
    }

    public void loadCEPlayer(Player player) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = player.getUniqueId().toString();
        ArrayList<GkitCoolDown> gkitCoolDowns = new ArrayList<GkitCoolDown>();
        for (GKitz kit : this.getGKitz()) {
            if (!data.contains("Players." + uuid + ".GKitz." + kit.getName())) continue;
            Calendar coolDown = Calendar.getInstance();
            coolDown.setTimeInMillis(data.getLong("Players." + uuid + ".GKitz." + kit.getName()));
            gkitCoolDowns.add(new GkitCoolDown(kit, coolDown));
        }
        this.addCEPlayer(new CEPlayer(player, gkitCoolDowns));
    }

    public void unloadCEPlayer(Player player) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = player.getUniqueId().toString();
        CEPlayer cePlayer = this.getCEPlayer(player);
        if (cePlayer != null) {
            for (GkitCoolDown gkitCooldown : cePlayer.getCoolDowns()) {
                data.set("Players." + uuid + ".GKitz." + gkitCooldown.getGKitz().getName(), (Object)gkitCooldown.getCoolDown().getTimeInMillis());
            }
            FileManager.Files.DATA.saveFile();
        }
        this.removeCEPlayer(cePlayer);
    }

    public void backupCEPlayer(Player player) {
        this.backupCEPlayer(this.getCEPlayer(player));
    }

    private void backupCEPlayer(CEPlayer cePlayer) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = cePlayer.getPlayer().getUniqueId().toString();
        for (GkitCoolDown gkitCooldown : cePlayer.getCoolDowns()) {
            data.set("Players." + uuid + ".GKitz." + gkitCooldown.getGKitz().getName(), (Object)gkitCooldown.getCoolDown().getTimeInMillis());
        }
        FileManager.Files.DATA.saveFile();
    }

    public CropManagerVersion getNMSSupport() {
        return this.cropManagerVersion;
    }

    public boolean checkVanillaLimit() {
        return this.checkVanillaLimit;
    }

    public boolean isGkitzEnabled() {
        return this.gkitzToggle;
    }

    public GKitz getGKitFromName(String kitName) {
        for (GKitz kit : this.getGKitz()) {
            if (!kit.getName().equalsIgnoreCase(kitName)) continue;
            return kit;
        }
        return null;
    }

    public List<GKitz> getGKitz() {
        return this.gkitz;
    }

    public CEPlayer getCEPlayer(Player player) {
        for (CEPlayer cePlayer : this.getCEPlayers()) {
            if (cePlayer.getPlayer() != player) continue;
            return cePlayer;
        }
        return null;
    }

    public CEPlayer getCEPlayer(UUID uuid) {
        for (CEPlayer cePlayer : this.getCEPlayers()) {
            if (!cePlayer.getPlayer().getUniqueId().equals(uuid)) continue;
            return cePlayer;
        }
        return null;
    }

    public List<CEPlayer> getCEPlayers() {
        return this.players;
    }

    public CEBook getRandomEnchantmentBook(Category category) {
        try {
            List<CEnchantment> enchantments = category.getEnabledEnchantments();
            CEnchantment enchantment = enchantments.get(new Random().nextInt(enchantments.size()));
            return new CEBook(enchantment, this.randomLevel(enchantment, category), 1, category);
        }
        catch (Exception e) {
            this.plugin.getLogger().info("The category " + category.getName() + " has no enchantments. Please add enchantments to the category in the Enchantments.yml. If you do not wish to have the category feel free to delete it from the Config.yml.");
            return null;
        }
    }

    public List<CEnchantment> getRegisteredEnchantments() {
        return new ArrayList<CEnchantment>(this.enchantmentBookSettings.getRegisteredEnchantments());
    }

    public CEnchantment getEnchantmentFromName(String enchantmentString) {
        for (CEnchantment enchantment : this.enchantmentBookSettings.getRegisteredEnchantments()) {
            if (enchantment.getName().equalsIgnoreCase(enchantmentString)) {
                return enchantment;
            }
            enchantmentString = enchantmentString.replaceAll("([&\u00a7]?#[0-9a-fA-F]{6}|[&\u00a7][1-9a-fA-Fk-or]| |_)", "");
            if (!enchantment.getCustomName().replaceAll("([&\u00a7]?#[0-9a-fA-F]{6}|[&\u00a7][1-9a-fA-Fk-or]| |_)", "").equalsIgnoreCase(enchantmentString)) continue;
            return enchantment;
        }
        return null;
    }

    public void registerEnchantment(CEnchantment enchantment) {
        this.enchantmentBookSettings.getRegisteredEnchantments().add(enchantment);
    }

    public void unregisterEnchantment(CEnchantment enchantment) {
        this.enchantmentBookSettings.getRegisteredEnchantments().remove(enchantment);
    }

    public void addEnchantment(ItemStack item, CEnchantment enchantment, int level) {
        HashMap<CEnchantment, Integer> enchantments = new HashMap<CEnchantment, Integer>();
        enchantments.put(enchantment, level);
        this.addEnchantments(item, enchantments);
    }

    public void addEnchantments(ItemStack itemStack, Map<CEnchantment, Integer> enchantments) {
        Map<CEnchantment, Integer> currentEnchantments = this.enchantmentBookSettings.getEnchantments(itemStack);
        this.enchantmentBookSettings.removeEnchantments(itemStack, enchantments.keySet().stream().filter(currentEnchantments::containsKey).toList());
        String data = (String)itemStack.getPersistentDataContainer().get(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING);
        Enchant enchantData = data != null ? Methods.getGson().fromJson(data, Enchant.class) : new Enchant(new HashMap<String, Integer>());
        List lore = itemStack.lore();
        List oldLore = lore != null ? lore : new ArrayList();
        ArrayList<TextComponent> newLore = new ArrayList<TextComponent>();
        for (Map.Entry<CEnchantment, Integer> entry : enchantments.entrySet()) {
            CEnchantment enchantment = entry.getKey();
            int level = entry.getValue();
            String loreString = enchantment.getCustomName() + " " + NumberUtils.convertLevelString(level);
            newLore.add(ColorUtils.legacyTranslateColourCodes(loreString));
            for (Map.Entry<CEnchantment, Integer> x : enchantments.entrySet()) {
                enchantData.addEnchantment(x.getKey().getName(), x.getValue());
            }
        }
        newLore.addAll(oldLore);
        itemStack.setData(DataComponentTypes.LORE, (Object)((ItemLore)ItemLore.lore().addLines(newLore).build()));
        itemStack.editPersistentDataContainer(container -> container.set(DataKeys.enchantments.getNamespacedKey(), PersistentDataType.STRING, (Object)Methods.getGson().toJson(enchantData)));
    }

    public ItemStack changeEnchantmentLimiter(@NotNull ItemStack itemStack, int amount) {
        PersistentDataContainerView view = itemStack.getPersistentDataContainer();
        int type = (Integer)view.getOrDefault(DataKeys.limit_reducer.getNamespacedKey(), PersistentDataType.INTEGER, (Object)0);
        int newAmount = type += amount;
        itemStack.editPersistentDataContainer(container -> {
            if (newAmount == 0) {
                container.remove(DataKeys.limit_reducer.getNamespacedKey());
            } else {
                container.set(DataKeys.limit_reducer.getNamespacedKey(), PersistentDataType.INTEGER, (Object)newAmount);
            }
        });
        return itemStack;
    }

    public int getEnchantmentLimiter(@NotNull ItemStack item) {
        if (!this.useEnchantmentLimiter) {
            return 0;
        }
        return (Integer)item.getPersistentDataContainer().getOrDefault(DataKeys.limit_reducer.getNamespacedKey(), PersistentDataType.INTEGER, (Object)0);
    }

    public void updatePlayerEffects(Player player) {
        if (player == null) {
            return;
        }
        Set<CEnchantments> allEnchantPotionEffects = this.getEnchantmentPotions().keySet();
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(armor);
            for (CEnchantments ench : allEnchantPotionEffects) {
                if (!enchantments.containsKey(ench.getEnchantment())) continue;
                Map<PotionEffectType, Integer> effects = this.getUpdatedEffects(player, armor, new ItemStack(Material.AIR), ench);
                this.checkPotions(effects, player);
            }
        }
    }

    public void checkPotions(Map<PotionEffectType, Integer> effects, Player player) {
        for (Map.Entry<PotionEffectType, Integer> type : effects.entrySet()) {
            int value = type.getValue();
            PotionEffectType key = type.getKey();
            player.removePotionEffect(key);
            if (value == 0) continue;
            PotionEffect potionEffect = new PotionEffect(key, -1, value);
            player.addPotionEffect(potionEffect);
        }
    }

    public Map<PotionEffectType, Integer> getUpdatedEffects(Player player, ItemStack includedItem, ItemStack excludedItem, CEnchantments enchantment) {
        HashMap<PotionEffectType, Integer> effects = new HashMap<PotionEffectType, Integer>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(player.getEquipment().getArmorContents()));
        if (includedItem == null) {
            includedItem = new ItemStack(Material.AIR);
        }
        if (excludedItem == null) {
            excludedItem = new ItemStack(Material.AIR);
        }
        if (excludedItem.isSimilar(includedItem)) {
            excludedItem = new ItemStack(Material.AIR);
        }
        items.add(includedItem);
        Map<CEnchantments, HashMap<PotionEffectType, Integer>> armorEffects = this.getEnchantmentPotions();
        for (ItemStack armor : items) {
            if (armor == null || armor.isSimilar(excludedItem)) continue;
            Map<CEnchantment, Integer> ench = this.enchantmentBookSettings.getEnchantments(armor);
            for (Map.Entry<CEnchantments, HashMap<PotionEffectType, Integer>> enchantments : armorEffects.entrySet()) {
                if (!ench.containsKey(enchantments.getKey().getEnchantment())) continue;
                int level = ench.get(enchantments.getKey().getEnchantment());
                if (!this.useUnsafeEnchantments && level > enchantments.getKey().getEnchantment().getMaxLevel()) {
                    level = enchantments.getKey().getEnchantment().getMaxLevel();
                }
                for (PotionEffectType type : enchantments.getValue().keySet()) {
                    if (effects.containsKey(type)) {
                        int updated = (Integer)effects.get(type);
                        if (updated >= level + enchantments.getValue().get(type)) continue;
                        effects.put(type, level + enchantments.getValue().get(type));
                        continue;
                    }
                    effects.put(type, level + enchantments.getValue().get(type));
                }
            }
        }
        for (PotionEffectType type : armorEffects.get((Object)enchantment).keySet()) {
            if (effects.containsKey(type)) continue;
            effects.put(type, 0);
        }
        return effects;
    }

    public Map<CEnchantments, HashMap<PotionEffectType, Integer>> getEnchantmentPotions() {
        HashMap<CEnchantments, HashMap<PotionEffectType, Integer>> enchants = new HashMap<CEnchantments, HashMap<PotionEffectType, Integer>>();
        enchants.put(CEnchantments.GLOWING, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.GLOWING)).put(PotionEffectType.NIGHT_VISION, -1);
        enchants.put(CEnchantments.MERMAID, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.MERMAID)).put(PotionEffectType.WATER_BREATHING, -1);
        enchants.put(CEnchantments.BURNSHIELD, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.BURNSHIELD)).put(PotionEffectType.FIRE_RESISTANCE, -1);
        enchants.put(CEnchantments.DRUNK, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.STRENGTH, -1);
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.MINING_FATIGUE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.SLOWNESS, -1);
        enchants.put(CEnchantments.HULK, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.STRENGTH, -1);
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.RESISTANCE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.SLOWNESS, -1);
        enchants.put(CEnchantments.VALOR, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.VALOR)).put(PotionEffectType.RESISTANCE, -1);
        enchants.put(CEnchantments.OVERLOAD, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.OVERLOAD)).put(PotionEffectType.HEALTH_BOOST, -1);
        enchants.put(CEnchantments.NINJA, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.NINJA)).put(PotionEffectType.HEALTH_BOOST, -1);
        ((HashMap)enchants.get((Object)CEnchantments.NINJA)).put(PotionEffectType.SPEED, -1);
        enchants.put(CEnchantments.INSOMNIA, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.NAUSEA, -1);
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.MINING_FATIGUE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.SLOWNESS, -1);
        enchants.put(CEnchantments.ANTIGRAVITY, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.ANTIGRAVITY)).put(PotionEffectType.JUMP_BOOST, 1);
        enchants.put(CEnchantments.GEARS, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.GEARS)).put(PotionEffectType.SPEED, -1);
        enchants.put(CEnchantments.SPRINGS, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.SPRINGS)).put(PotionEffectType.JUMP_BOOST, -1);
        enchants.put(CEnchantments.CYBORG, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.SPEED, -1);
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.STRENGTH, 0);
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.JUMP_BOOST, -1);
        return enchants;
    }

    public boolean useConfigLimit() {
        return this.useConfigLimits;
    }

    public int getPlayerMaxEnchantments(Player player) {
        int limit = this.defaultLimit;
        if (this.useConfigLimits) {
            return limit;
        }
        for (PermissionAttachmentInfo Permission : player.getEffectivePermissions()) {
            String perm = Permission.getPermission().toLowerCase();
            if (!perm.startsWith("crazyenchantments.limit.") || !NumberUtils.isInt(perm = perm.replace("crazyenchantments.limit.", "")) || limit >= Integer.parseInt(perm)) continue;
            limit = Integer.parseInt(perm);
        }
        return limit;
    }

    public int getPlayerBaseEnchantments(@NotNull Player player) {
        int limit = this.defaultBaseLimit;
        if (this.useConfigLimits) {
            return limit;
        }
        for (PermissionAttachmentInfo Permission : player.getEffectivePermissions()) {
            String perm = Permission.getPermission().toLowerCase();
            if (!perm.startsWith("crazyenchantments.base-limit.") || !NumberUtils.isInt(perm = perm.replace("crazyenchantments.base-limit.", "")) || limit >= Integer.parseInt(perm)) continue;
            limit = Integer.parseInt(perm);
        }
        return limit;
    }

    public boolean canAddEnchantment(@NotNull Player player, @NotNull ItemStack item) {
        if (!this.maxEnchantmentCheck || player.hasPermission("crazyenchantments.bypass.limit")) {
            return true;
        }
        return this.enchantmentBookSettings.getEnchantmentAmount(item, this.checkVanillaLimit) < Math.min(this.getPlayerBaseEnchantments(player) - this.getEnchantmentLimiter(item), this.getPlayerMaxEnchantments(player));
    }

    public boolean canAddEnchantment(@NotNull Player player, int cEnchantments, int vanillaEnchantments) {
        if (!this.maxEnchantmentCheck || player.hasPermission("crazyenchantments.bypass.limit")) {
            return true;
        }
        int enchantAmount = cEnchantments;
        if (this.checkVanillaLimit) {
            enchantAmount += vanillaEnchantments;
        }
        return enchantAmount < this.getPlayerMaxEnchantments(player);
    }

    public int randomLevel(CEnchantment enchantment, Category category) {
        int enchantmentMax = enchantment.getMaxLevel();
        int randomLevel = 1 + new Random().nextInt(enchantmentMax);
        if (category.useMaxLevel()) {
            if (randomLevel > category.getMaxLevel()) {
                randomLevel = 1 + new Random().nextInt(category.getMaxLevel());
            }
            if (randomLevel < category.getMinLevel()) {
                randomLevel = category.getMinLevel();
            }
            if (randomLevel > enchantmentMax) {
                randomLevel = enchantmentMax;
            }
        }
        return randomLevel;
    }

    public Map<Material, Double> getDecapitationHeadMap() {
        return this.headMap;
    }

    public List<Material> getBlastBlockList() {
        return this.blockList;
    }

    public boolean isDropBlocksBlast() {
        return this.dropBlocksBlast;
    }

    public boolean isDropBlocksVeinMiner() {
        return this.dropBlocksVeinMiner;
    }

    public void setDropBlocksBlast(boolean dropBlocksBlast) {
        this.dropBlocksBlast = dropBlocksBlast;
    }

    public void setDropBlocksVeinMiner(boolean dropBlocksVeinMiner) {
        this.dropBlocksVeinMiner = dropBlocksVeinMiner;
    }

    public int getRageMaxLevel() {
        return this.rageMaxLevel;
    }

    public boolean isBreakRageOnDamageOn() {
        return this.breakRageOnDamage;
    }

    public boolean useRageBossBar() {
        return this.useRageBossBar;
    }

    public double getRageIncrement() {
        return this.rageIncrement;
    }

    private void addCEPlayer(CEPlayer player) {
        this.players.add(player);
    }

    private void removeCEPlayer(CEPlayer player) {
        this.players.remove(player);
    }

    private List<ItemStack> getInfoGKit(List<String> itemStrings) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String itemString : itemStrings) {
            itemString = this.getNewItemString(itemString);
            ItemBuilder itemBuilder = ItemBuilder.convertString(itemString);
            ArrayList<CallSite> customEnchantments = new ArrayList<CallSite>();
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (String option : itemString.split(", ")) {
                try {
                    Enchantment enchantment = this.methods.getEnchantment(option.split(":")[0]);
                    CEnchantment cEnchantment = this.getEnchantmentFromName(option.split(":")[0]);
                    String level = option.split(":")[1];
                    if (enchantment != null) {
                        if (level.contains("-")) {
                            customEnchantments.add((CallSite)((Object)("&7" + option.split(":")[0] + " " + level)));
                            continue;
                        }
                        enchantments.put(enchantment, Integer.parseInt(level));
                        continue;
                    }
                    if (cEnchantment == null) continue;
                    customEnchantments.add((CallSite)((Object)(cEnchantment.getCustomName() + " " + level)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            itemBuilder.getLore().addAll(0, customEnchantments.stream().map(ColorUtils::legacyTranslateColourCodes).toList());
            itemBuilder.setEnchantments(enchantments);
            items.add(itemBuilder.addKey(DataKeys.random_number.getNamespacedKey(), String.valueOf(this.methods.getRandomNumber(0, Integer.MAX_VALUE))).build());
        }
        return items;
    }

    public String getNewItemString(String itemString) {
        StringBuilder newItemString = new StringBuilder();
        for (String option : itemString.split(", ")) {
            if (option.toLowerCase().startsWith("enchantments:") || option.toLowerCase().startsWith("customenchantments:")) {
                StringBuilder newOption = new StringBuilder();
                for (String enchantment : option.toLowerCase().replace("customenchantments:", "").replace("enchantments:", "").split(",")) {
                    newOption.append(enchantment).append(", ");
                }
                option = newOption.substring(0, newOption.length() - 2);
            }
            newItemString.append(option).append(", ");
        }
        if (!newItemString.isEmpty()) {
            itemString = newItemString.substring(0, newItemString.length() - 2);
        }
        return itemString;
    }

    public int pickLevel(int min, int max) {
        return min + new Random().nextInt(max + 1 - min);
    }

    public int getCESuccessOverride() {
        return this.CESuccessOverride;
    }

    public int getCEFailureOverride() {
        return this.CEFailureOverride;
    }
}

