/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.internal;

import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import java.lang.reflect.Array;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    @Nullable
    public static <T> T convertOrLogError(@Nullable Object element, @NotNull PropertyType<T> type, @NotNull ConvertErrorRecorder errorRecorder) {
        return (T)ConversionUtils.convertOrLogError(element, (? super I elem) -> type.convert(elem, errorRecorder), errorRecorder);
    }

    @Nullable
    public static <I, T> T convertOrLogError(@Nullable I element, @NotNull Function<? super I, T> conversionFunction, @NotNull ConvertErrorRecorder errorRecorder) {
        T result = conversionFunction.apply(element);
        if (result == null) {
            errorRecorder.setHasError("Could not convert '" + String.valueOf(element) + "'");
        }
        return result;
    }

    public static <T> T @NotNull [] createArrayForReferenceType(@NotNull Class<T> component, int size) {
        if (component.isPrimitive()) {
            throw new IllegalArgumentException("The component type may not be a primitive type, but got: " + String.valueOf(component));
        }
        return (Object[])Array.newInstance(component, size);
    }
}

