/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.propertydescription;

import ch.jalu.configme.Comment;
import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.ExportName;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyComments;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescriptionImpl;
import ch.jalu.typeresolver.TypeInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanDescriptionFactoryImpl
implements BeanDescriptionFactory {
    private final Map<Class<?>, List<BeanPropertyDescription>> classProperties = new HashMap();

    @Override
    @NotNull
    public Collection<BeanPropertyDescription> getAllProperties(@NotNull Class<?> clazz) {
        return this.classProperties.computeIfAbsent(clazz, this::collectAllProperties);
    }

    @NotNull
    protected List<BeanPropertyDescription> collectAllProperties(@NotNull Class<?> clazz) {
        List<PropertyDescriptor> descriptors = this.getWritableProperties(clazz);
        List<BeanPropertyDescription> properties = descriptors.stream().map(this::convert).filter(Objects::nonNull).collect(Collectors.toList());
        this.validateProperties(clazz, properties);
        return properties;
    }

    @Nullable
    protected BeanPropertyDescription convert(@NotNull PropertyDescriptor descriptor) {
        if (Boolean.TRUE.equals(descriptor.getValue("transient"))) {
            return null;
        }
        Field field = this.tryGetField(descriptor.getWriteMethod().getDeclaringClass(), descriptor.getName());
        BeanPropertyComments comments = this.getComments(field);
        return new BeanPropertyDescriptionImpl(this.getPropertyName(descriptor, field), this.createTypeInfo(descriptor), descriptor.getReadMethod(), descriptor.getWriteMethod(), comments);
    }

    @NotNull
    protected BeanPropertyComments getComments(@Nullable Field field) {
        Comment comment;
        Comment comment2 = comment = field == null ? null : field.getAnnotation(Comment.class);
        if (comment != null) {
            UUID uniqueId = comment.repeat() ? null : UUID.randomUUID();
            return new BeanPropertyComments(Arrays.asList(comment.value()), uniqueId);
        }
        return BeanPropertyComments.EMPTY;
    }

    @Nullable
    protected Field tryGetField(@NotNull Class<?> clazz, @NotNull String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    protected void validateProperties(@NotNull Class<?> clazz, @NotNull Collection<BeanPropertyDescription> properties) {
        HashSet names = new HashSet(properties.size());
        properties.forEach(property -> {
            if (property.getName().isEmpty()) {
                throw new ConfigMeMapperException("Custom name of " + String.valueOf(property) + " may not be empty");
            }
            if (!names.add(property.getName())) {
                throw new ConfigMeMapperException(String.valueOf(clazz) + " has multiple properties with name '" + property.getName() + "'");
            }
        });
    }

    @NotNull
    protected String getPropertyName(@NotNull PropertyDescriptor descriptor, @Nullable Field field) {
        if (field != null && field.isAnnotationPresent(ExportName.class)) {
            return field.getAnnotation(ExportName.class).value();
        }
        return descriptor.getName();
    }

    @NotNull
    protected TypeInfo createTypeInfo(@NotNull PropertyDescriptor descriptor) {
        return new TypeInfo(descriptor.getWriteMethod().getGenericParameterTypes()[0]);
    }

    @NotNull
    protected List<PropertyDescriptor> getWritableProperties(@NotNull Class<?> clazz) {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<PropertyDescriptor> writableProperties = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            writableProperties.add(descriptor);
        }
        return this.sortPropertiesList(clazz, writableProperties);
    }

    @NotNull
    protected List<PropertyDescriptor> sortPropertiesList(@NotNull Class<?> clazz, @NotNull List<PropertyDescriptor> properties) {
        Map<String, Integer> fieldNameByIndex = this.createFieldNameOrderMap(clazz);
        int maxIndex = fieldNameByIndex.size();
        properties.sort(Comparator.comparing(property -> {
            Integer index = (Integer)fieldNameByIndex.get(property.getName());
            return index == null ? maxIndex : index;
        }));
        return properties;
    }

    @NotNull
    protected Map<String, Integer> createFieldNameOrderMap(@NotNull Class<?> clazz) {
        HashMap<String, Integer> nameByIndex = new HashMap<String, Integer>();
        int i = 0;
        for (Class<?> currentClass : this.collectClassAndAllParents(clazz)) {
            for (Field field : currentClass.getDeclaredFields()) {
                nameByIndex.put(field.getName(), i);
                ++i;
            }
        }
        return nameByIndex;
    }

    @NotNull
    protected List<Class<?>> collectClassAndAllParents(@NotNull Class<?> clazz) {
        ArrayList parents = new ArrayList();
        for (Class<?> curClass = clazz; curClass != null && curClass != Object.class; curClass = curClass.getSuperclass()) {
            parents.add(curClass);
        }
        Collections.reverse(parents);
        return parents;
    }
}

