/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.scheduler;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FoliaScheduler
implements Runnable {
    private final JavaPlugin plugin;
    private final Scheduler type;
    private final Server server;
    private final TimeUnit timeUnit;
    private ScheduledTask task;
    private World world;
    private int x;
    private int z;
    private Runnable retired;
    private Entity entity;

    public FoliaScheduler(@NotNull JavaPlugin plugin, @NotNull Scheduler type, @NotNull TimeUnit timeUnit) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.timeUnit = timeUnit;
        this.type = type;
    }

    public FoliaScheduler(@NotNull JavaPlugin plugin, @NotNull Scheduler type) {
        this(plugin, type, TimeUnit.SECONDS);
    }

    public FoliaScheduler(@NotNull JavaPlugin plugin, @NotNull World world, int x, int z) {
        this(plugin, Scheduler.region_scheduler, TimeUnit.SECONDS);
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public FoliaScheduler(@NotNull JavaPlugin plugin, @NotNull Location location) {
        this(plugin, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public FoliaScheduler(@NotNull JavaPlugin plugin, @Nullable Runnable retired, @NotNull Entity entity) {
        this(plugin, Scheduler.entity_scheduler);
        this.retired = retired;
        this.entity = entity;
    }

    public ScheduledTask runNow() throws FusionException {
        this.isScheduled();
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().run((Plugin)this.plugin, scheduledTask -> this.run());
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> this.run());
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().run((Plugin)this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot immediately run entity task if the entity is null.");
                }
                yield this.entity.getScheduler().run((Plugin)this.plugin, scheduledTask -> this.run(), this.retired);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public boolean execute() throws FusionException {
        this.isScheduled();
        switch (this.type) {
            case global_scheduler: {
                this.server.getGlobalRegionScheduler().execute((Plugin)this.plugin, (Runnable)this);
                break;
            }
            case async_scheduler: {
                this.server.getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> this.run());
                break;
            }
            case region_scheduler: {
                this.server.getRegionScheduler().run((Plugin)this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
                break;
            }
            case entity_scheduler: {
                if (this.entity == null) {
                    throw new FusionException("Cannot immediately execute entity task if the entity is null.");
                }
                this.entity.getScheduler().run((Plugin)this.plugin, scheduledTask -> this.run(), this.retired);
                break;
            }
            default: {
                throw new FusionException("The task type is not supported!");
            }
        }
        return true;
    }

    public ScheduledTask runDelayed(long delay) throws FusionException {
        this.isScheduled();
        long maxDelay = Math.max(1L, delay);
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> this.run(), maxDelay);
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> this.run(), maxDelay, this.timeUnit);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().runDelayed((Plugin)this.plugin, this.world, this.x, this.z, scheduledTask -> this.run(), maxDelay);
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run delayed entity task if the entity is null.");
                }
                yield this.entity.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> this.run(), this.retired, maxDelay);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public ScheduledTask runNextTick() throws FusionException {
        this.isScheduled();
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().run((Plugin)this.plugin, scheduledTask -> this.run());
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> this.run(), 50L, TimeUnit.MILLISECONDS);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().run((Plugin)this.plugin, this.world, this.x, this.z, scheduledTask -> this.run());
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run delayed entity task if the entity is null.");
                }
                yield this.entity.getScheduler().run((Plugin)this.plugin, scheduledTask -> this.run(), this.retired);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public ScheduledTask runAtFixedRate(long delay, long interval) throws FusionException {
        this.isScheduled();
        long maxDelay = Math.max(1L, delay);
        long maxInterval = Math.max(1L, interval);
        this.task = switch (this.type) {
            case Scheduler.global_scheduler -> this.server.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.run(), maxDelay, maxInterval);
            case Scheduler.async_scheduler -> this.server.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.run(), maxDelay, maxInterval, this.timeUnit);
            case Scheduler.region_scheduler -> this.server.getRegionScheduler().runAtFixedRate((Plugin)this.plugin, this.world, this.x, this.z, scheduledTask -> this.run(), maxDelay, maxInterval);
            case Scheduler.entity_scheduler -> {
                if (this.entity == null) {
                    throw new FusionException("Cannot run fixed rate entity task if the entity is null");
                }
                yield this.entity.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.run(), this.retired, maxDelay, maxInterval);
            }
            default -> throw new FusionException("The task type is not supported!");
        };
        return this.task;
    }

    public void cancel(@Nullable Consumer<FoliaScheduler> consumer) {
        this.isNotScheduled();
        this.task.cancel();
        if (consumer != null) {
            consumer.accept(this);
        }
    }

    public void cancel() {
        this.cancel(null);
    }

    @Override
    public void run() {
    }

    public final int getTaskId() throws FusionException {
        this.isNotScheduled();
        return this.task.hashCode();
    }

    public final Scheduler getType() {
        return this.type;
    }

    public final ScheduledTask getTask() {
        return this.task;
    }

    private void isNotScheduled() throws FusionException {
        if (this.task == null) {
            throw new FusionException("The task is not yet scheduled.");
        }
    }

    private void isScheduled() throws FusionException {
        if (this.task != null) {
            throw new FusionException(String.format("The task is already scheduled as %s", this.task.hashCode()));
        }
    }
}

