/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.commands.objects;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.commands.objects.ICommand;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.api.commands.objects.PaperCommandContext;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

public abstract class PaperCommand
extends ICommand<CommandSourceStack, LiteralCommandNode<CommandSourceStack>, Player, PaperCommandContext> {
    private final FusionPaper fusion = (FusionPaper)FusionProvider.get();

    @NotNull
    public List<PaperCommand> getChildren() {
        return new ArrayList<PaperCommand>();
    }

    @NotNull
    public PermissionDefault getPermissionDefault() {
        return PermissionDefault.OP;
    }

    @Override
    @NotNull
    public final Suggestions supplyIntegers(@NotNull SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            if (tooltip.isEmpty()) {
                builder.suggest(count);
                continue;
            }
            builder.suggest(count, (Message)MessageComponentSerializer.message().serialize(this.fusion.color(tooltip)));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public final Suggestions supplyDoubles(@NotNull SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            if (tooltip.isEmpty()) {
                builder.suggest(String.valueOf((double)count / 10.0));
                continue;
            }
            builder.suggest(String.valueOf((double)count / 10.0), (Message)MessageComponentSerializer.message().serialize(this.fusion.color(tooltip)));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public final Suggestions supplyStrings(@NotNull SuggestionsBuilder builder, int min, int max, @NotNull String tooltip) {
        for (int count = min; count <= max; ++count) {
            String uuid = UUID.randomUUID().toString().replace("-", "").substring(0, 8);
            if (tooltip.isEmpty()) {
                builder.suggest(uuid);
                continue;
            }
            builder.suggest(uuid, (Message)MessageComponentSerializer.message().serialize(this.fusion.color(tooltip)));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public final Suggestions supplyIntegers(@NotNull SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.supplyIntegers(builder, 1, 64, tooltip);
    }

    @Override
    @NotNull
    public final Suggestions supplyDoubles(@NotNull SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.supplyDoubles(builder, 0, 64, tooltip);
    }

    @Override
    @NotNull
    public final Suggestions supplyStrings(@NotNull SuggestionsBuilder builder, @NotNull String tooltip) {
        return this.supplyStrings(builder, 1, 8, tooltip);
    }
}

