/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builders.items.types;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.BaseItemBuilder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;

public class SkullBuilder
extends BaseItemBuilder<SkullBuilder> {
    private final ResolvableProfile.Builder builder = ResolvableProfile.resolvableProfile();

    public SkullBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    @NotNull
    public SkullBuilder withAudience(@NotNull Audience audience) {
        UUID uuid = (UUID)audience.getOrDefault(Identity.UUID, null);
        if (uuid == null) {
            return this;
        }
        this.builder.uuid(uuid);
        return this;
    }

    @NotNull
    public SkullBuilder withUrl(@NotNull String url) {
        if (url.isEmpty()) {
            return this;
        }
        String newUrl = "https://textures.minecraft.net/texture/" + url;
        PlayerProfile profile = this.fusion.createProfile(UUID.randomUUID(), null);
        profile.setProperty(new ProfileProperty("", ""));
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(URI.create(newUrl).toURL(), PlayerTextures.SkinModel.CLASSIC);
        }
        catch (MalformedURLException exception) {
            throw new FusionException("Skull URL is malformed!", exception);
        }
        profile.setTextures(textures);
        this.builder.addProperties((Collection)profile.getProperties());
        return this;
    }

    @Override
    @NotNull
    public SkullBuilder withBase64(@NotNull String base64) {
        if (base64.isEmpty()) {
            return this;
        }
        this.builder.addProperty(new ProfileProperty("textures", base64));
        return this;
    }

    @NotNull
    public SkullBuilder withName(@NotNull String playerName) {
        if (playerName.isEmpty()) {
            return this;
        }
        if (playerName.length() > 16) {
            return this.withUrl(playerName);
        }
        this.builder.name(playerName);
        return this;
    }

    @Override
    @NotNull
    public SkullBuilder build() {
        this.getItem().setData(DataComponentTypes.PROFILE, (Object)((ResolvableProfile)this.builder.build()));
        return this;
    }
}

