/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builders.items.legacy;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.nexomc.nexo.api.NexoItems;
import dev.lone.itemsadder.api.CustomStack;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.th0rgal.oraxen.api.OraxenItems;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.enums.Support;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import libs.com.ryderbelserion.fusion.core.api.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.api.builders.PlayerBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiAction;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.legacy.NbtBuilder;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Tag;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.tag.DamageTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder<T extends ItemBuilder<T>> {
    private final FusionPaper fusion = (FusionPaper)FusionProvider.get();
    private final NbtBuilder nbt = new NbtBuilder();
    private final JavaPlugin plugin;
    private final Server server;
    private ItemStack itemStack;
    private static final EnumSet<Material> LEATHER_ARMOR = EnumSet.of(Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.LEATHER_HORSE_ARMOR);
    private static final EnumSet<Material> POTIONS = EnumSet.of(Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION);
    private static final EnumSet<Material> BANNERS = EnumSet.of(Material.WHITE_BANNER, new Material[]{Material.ORANGE_BANNER, Material.MAGENTA_BANNER, Material.LIGHT_BLUE_BANNER, Material.YELLOW_BANNER, Material.LIME_BANNER, Material.PINK_BANNER, Material.GRAY_BANNER, Material.LIGHT_GRAY_BANNER, Material.CYAN_BANNER, Material.PURPLE_BANNER, Material.BLUE_BANNER, Material.BROWN_BANNER, Material.GREEN_BANNER, Material.RED_BANNER, Material.BLACK_BANNER, Material.WHITE_WALL_BANNER, Material.ORANGE_WALL_BANNER, Material.MAGENTA_WALL_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.YELLOW_WALL_BANNER, Material.LIME_WALL_BANNER, Material.PINK_WALL_BANNER, Material.GRAY_WALL_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.CYAN_WALL_BANNER, Material.PURPLE_WALL_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_WALL_BANNER, Material.GREEN_WALL_BANNER, Material.RED_WALL_BANNER, Material.BLACK_WALL_BANNER});
    private static final EnumSet<Material> ARMOR = EnumSet.of(Material.LEATHER_HELMET, new Material[]{Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.TURTLE_HELMET});
    private static final EnumSet<Material> SHULKERS = EnumSet.of(Material.SHULKER_BOX, new Material[]{Material.BLUE_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX});
    private boolean isCustom = false;
    @Nullable
    private Color color = null;
    private int damage = 0;
    private List<String> displayLore = new ArrayList<String>();
    private List<Component> displayComponentLore = new ArrayList<Component>();
    private Map<String, String> displayLorePlaceholders = new HashMap<String, String>();
    private String displayName = "";
    private Component displayComponent = Component.empty();
    private Map<String, String> displayNamePlaceholders = new HashMap<String, String>();
    private List<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    private List<FireworkEffect> fireworkEffects = new ArrayList<FireworkEffect>();
    @NotNull
    private EntityType entityType = EntityType.PIG;
    private boolean canAlwaysEat = false;
    private int nutritionalValue = 0;
    private float saturation = 0.0f;
    private float eatSeconds = 0.0f;
    private int fireworkPower = 1;
    @NotNull
    private List<Pattern> patterns = new ArrayList<Pattern>();
    @Nullable
    private UUID player = null;
    @Nullable
    private PotionType potionType = null;
    @Nullable
    private UUID uuid = null;
    private String url = "";
    private boolean isHidingItemFlags = false;
    private boolean isHidingToolTips = false;
    private List<Tag<DamageType>> damageTags = new ArrayList<Tag<DamageType>>();
    private boolean isUnbreakable = false;
    private boolean isGlowing = false;
    private TrimMaterial trimMaterial;
    private TrimPattern trimPattern;

    public ItemBuilder(@NotNull JavaPlugin plugin) {
        this(plugin, (ItemType)ItemType.STONE, 1);
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemType itemType) {
        this(plugin, itemType, 1);
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemType itemType, int amount) {
        this(plugin, itemType.createItemStack(amount), true);
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemStack itemStack, boolean createNewStack) {
        this.itemStack = createNewStack ? itemStack.clone() : itemStack;
        this.plugin = plugin;
        this.server = this.plugin.getServer();
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemBuilder<T> itemBuilder) {
        this(plugin, itemBuilder, false);
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemBuilder<T> itemBuilder, boolean createNewStack) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.itemStack = createNewStack ? itemBuilder.itemStack.clone() : itemBuilder.itemStack;
        this.isCustom = itemBuilder.isCustom;
        this.damage = itemBuilder.damage;
        this.color = itemBuilder.color;
        this.displayLorePlaceholders = itemBuilder.displayLorePlaceholders;
        this.displayNamePlaceholders = itemBuilder.displayNamePlaceholders;
        this.displayComponentLore = itemBuilder.displayComponentLore;
        this.displayComponent = itemBuilder.displayComponent;
        this.displayLore = itemBuilder.displayLore;
        this.displayName = itemBuilder.displayName;
        this.potionEffects = itemBuilder.potionEffects;
        this.fireworkEffects = itemBuilder.fireworkEffects;
        this.entityType = itemBuilder.entityType;
        this.nutritionalValue = itemBuilder.nutritionalValue;
        this.canAlwaysEat = itemBuilder.canAlwaysEat;
        this.saturation = itemBuilder.saturation;
        this.eatSeconds = itemBuilder.eatSeconds;
        this.fireworkPower = itemBuilder.fireworkPower;
        this.patterns = itemBuilder.patterns;
        this.player = itemBuilder.player;
        this.url = itemBuilder.url;
        this.uuid = itemBuilder.uuid;
        this.potionType = itemBuilder.potionType;
        this.isHidingItemFlags = itemBuilder.isHidingItemFlags;
        this.isHidingToolTips = itemBuilder.isHidingToolTips;
        this.isUnbreakable = itemBuilder.isUnbreakable;
        this.isGlowing = itemBuilder.isGlowing;
        this.trimMaterial = itemBuilder.trimMaterial;
        this.trimPattern = itemBuilder.trimPattern;
    }

    public ItemBuilder(@NotNull JavaPlugin plugin, @NotNull ItemStack itemStack) {
        TooltipDisplay display;
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.itemStack = itemStack;
        if (this.hasItemMeta()) {
            Tag tag;
            @NotNull ItemMeta itemMeta = this.itemStack.getItemMeta();
            if (itemMeta.hasDisplayName()) {
                this.displayComponent = itemMeta.displayName();
            }
            if (itemMeta.hasLore()) {
                this.displayComponentLore = itemMeta.lore();
            }
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                v0 = damageable.getDamage();
            } else {
                v0 = this.damage = 1;
            }
            if (this.isFirework() || this.isFireworkStar()) {
                if (itemMeta instanceof FireworkMeta) {
                    FireworkMeta firework = (FireworkMeta)itemMeta;
                    this.fireworkEffects = firework.getEffects();
                    this.fireworkPower = firework.getPower();
                }
            } else if (this.isSpawner()) {
                BlockStateMeta blockState;
                CreatureSpawner creatureSpawner;
                EntityType type;
                if (itemMeta instanceof BlockStateMeta && (type = (creatureSpawner = (CreatureSpawner)(blockState = (BlockStateMeta)itemMeta).getBlockState()).getSpawnedType()) != null) {
                    this.entityType = type;
                }
            } else if (this.isBanner()) {
                if (itemMeta instanceof BannerMeta) {
                    BannerMeta banner = (BannerMeta)itemMeta;
                    this.patterns.addAll(banner.getPatterns());
                }
            } else if (this.isShield()) {
                if (itemMeta instanceof BlockStateMeta) {
                    BlockStateMeta shield = (BlockStateMeta)itemMeta;
                    @NotNull Banner banner = (Banner)shield.getBlockState();
                    this.patterns.addAll(banner.getPatterns());
                }
            } else if (this.isPlayerHead()) {
                OfflinePlayer target;
                SkullMeta skull;
                if (itemMeta instanceof SkullMeta && (skull = (SkullMeta)itemMeta).hasOwner() && (target = skull.getOwningPlayer()) != null) {
                    this.uuid = target.getUniqueId();
                }
            } else if (this.isArrow() || this.isPotion()) {
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta potionMeta = (PotionMeta)itemMeta;
                    this.color = potionMeta.getColor();
                    this.potionEffects = potionMeta.getCustomEffects();
                    this.potionType = potionMeta.getBasePotionType();
                }
            } else if (this.isLeather()) {
                if (itemMeta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta armor = (LeatherArmorMeta)itemMeta;
                    this.color = armor.getColor();
                }
            } else if (this.isMap() && itemMeta instanceof MapMeta) {
                MapMeta map = (MapMeta)itemMeta;
                this.color = map.getColor();
            }
            if (itemMeta.hasDamageResistant() && (tag = itemMeta.getDamageResistant()) != null) {
                this.damageTags = new ArrayList<Tag<DamageType>>(){
                    {
                        this.add(tag);
                    }
                };
            }
        }
        this.setGlowing(itemStack.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE));
        boolean hasToolTipDisplay = itemStack.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY);
        if (hasToolTipDisplay && (display = (TooltipDisplay)itemStack.getData(DataComponentTypes.TOOLTIP_DISPLAY)) != null) {
            this.setHidingToolTips(display.hideTooltip());
            this.setHidingItemFlags(display.hideTooltip());
        }
        this.setUnbreakable(itemStack.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE));
    }

    @NotNull
    public GuiItem asGuiItem(@Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        return new GuiItem(this.asItemStack(), action);
    }

    @NotNull
    public GuiItem asGuiItem() {
        return new GuiItem(this.asItemStack(), null);
    }

    @NotNull
    public ItemStack asItemStack() {
        return this.asItemStack(null);
    }

    @NotNull
    public ItemStack asItemStack(@Nullable Consumer<ItemMeta> consumer) {
        if (this.isCustom) {
            return this.itemStack;
        }
        ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)this.applyColor()).applyEffects()).applyEntityType()).applyPattern()).applySkull()).applyTexture()).applyDamage();
        if (this.trimPattern != null && this.trimMaterial != null) {
            this.applyTrim(this.trimPattern, this.trimMaterial);
        }
        this.itemStack.editMeta(itemMeta -> {
            String displayName;
            if (consumer != null) {
                consumer.accept((ItemMeta)itemMeta);
            }
            if (!(displayName = this.displayName).isEmpty()) {
                if (!this.displayNamePlaceholders.isEmpty()) {
                    for (Map.Entry<String, String> entry : this.displayNamePlaceholders.entrySet()) {
                        String key = entry.getKey().toLowerCase();
                        String value = entry.getValue();
                        displayName = displayName.replace(key, value);
                    }
                }
                this.displayComponent = AdvUtils.parse(displayName);
                itemMeta.displayName(this.displayComponent);
            }
            if (!this.displayLore.isEmpty()) {
                boolean isEmpty = this.displayLorePlaceholders.isEmpty();
                @NotNull ArrayList<Component> components = new ArrayList<Component>();
                for (String line : this.displayLore) {
                    if (!isEmpty) {
                        for (Map.Entry<String, String> entry : this.displayLorePlaceholders.entrySet()) {
                            String key = entry.getKey().toLowerCase();
                            String value = entry.getValue();
                            line = line.replace(key, value);
                        }
                    }
                    components.add(AdvUtils.parse(line));
                }
                this.displayComponentLore = components;
                itemMeta.lore(this.displayComponentLore);
            }
            this.damageTags.forEach(arg_0 -> ((ItemMeta)itemMeta).setDamageResistant(arg_0));
            itemMeta.setHideTooltip(this.isHidingToolTips);
        });
        if (this.isHidingItemFlags) {
            ItemAttributeModifiers modifier2;
            @NotNull ArrayList<E> values = new ArrayList();
            if (this.itemStack.hasData((DataComponentType)DataComponentTypes.ATTRIBUTE_MODIFIERS) && (modifier2 = (ItemAttributeModifiers)this.itemStack.getData(DataComponentTypes.ATTRIBUTE_MODIFIERS)) != null) {
                values.addAll(modifier2.modifiers());
            }
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.itemAttributes();
            values.forEach(modifier -> builder.addModifier(modifier.attribute(), modifier.modifier()));
            this.itemStack.setData(DataComponentTypes.ATTRIBUTE_MODIFIERS, (DataComponentBuilder)builder);
        }
        if (this.isGlowing) {
            this.itemStack.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        }
        if (this.isHidingToolTips) {
            TooltipDisplay display = (TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build();
            this.itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)display);
        }
        if (this.isUnbreakable) {
            this.itemStack.setData(DataComponentTypes.UNBREAKABLE);
        }
        return this.itemStack;
    }

    @NotNull
    public String toBase64() {
        return ItemUtils.toBase64(this.asItemStack());
    }

    @NotNull
    public T fromBase64(@NotNull String base64) {
        if (base64.isEmpty()) {
            return (T)new ItemBuilder<T>(this.plugin);
        }
        return (T)new ItemBuilder<T>(this.plugin, ItemUtils.fromBase64(base64));
    }

    @NotNull
    public T apply(@Nullable Consumer<ItemBuilder<T>> builder) {
        if (builder != null) {
            builder.accept(this);
        }
        return (T)this;
    }

    @NotNull
    public T withType(@Nullable ItemType itemType) {
        return this.withType(itemType, 1);
    }

    @NotNull
    public T withType(@Nullable ItemType itemType, int amount) {
        if (itemType == null) {
            return (T)this;
        }
        ItemStack itemStack = itemType.createItemStack(Math.max(amount, 1));
        this.itemStack = this.itemStack.withType(itemStack.getType());
        this.itemStack.setAmount(itemStack.getAmount());
        return (T)this;
    }

    @NotNull
    public T withType(@NotNull String key) {
        if (key.isEmpty()) {
            return (T)this;
        }
        switch (this.fusion.getItemsPlugin().toLowerCase()) {
            case "nexo": {
                if (!Support.nexo.isEnabled()) break;
                this.getNexo(key);
                break;
            }
            case "oraxen": {
                if (!Support.oraxen.isEnabled()) break;
                this.getOraxen(key);
                break;
            }
            case "itemsadder": {
                if (!Support.items_adder.isEnabled()) break;
                this.getItemsAdder(key);
                break;
            }
            default: {
                if (Support.nexo.isEnabled()) {
                    this.getNexo(key);
                    break;
                }
                if (Support.items_adder.isEnabled()) {
                    this.getItemsAdder(key);
                    break;
                }
                if (!Support.oraxen.isEnabled()) break;
                this.getOraxen(key);
            }
        }
        String type = key;
        if (key.contains(":")) {
            Optional<Number> damage;
            String model;
            Optional<Number> customModelData;
            String[] sections = key.split(":");
            type = sections[0];
            String data = sections[1];
            if (data.contains("#") && (customModelData = StringUtils.tryParseInt(model = data.split("#")[1])).isPresent()) {
                data = data.replace("#" + String.valueOf(customModelData.get()), "");
                this.setCustomModelData(customModelData.get().intValue());
            }
            if ((damage = StringUtils.tryParseInt(data)).isEmpty()) {
                @Nullable PotionEffectType potionEffect = ItemUtils.getPotionEffect(data);
                if (potionEffect != null) {
                    this.potionEffects.add(new PotionEffect(potionEffect, 1, 1));
                }
                this.potionType = ItemUtils.getPotionType(data);
                this.color = data.contains(",") ? ColorUtils.getRGB(data) : ColorUtils.getColor(data);
            } else {
                this.damage = damage.get().intValue();
            }
        } else if (key.contains("#")) {
            String[] sections = key.split("#");
            type = sections[0];
            String model = sections[1];
            Optional<Number> customModelData = StringUtils.tryParseInt(model);
            customModelData.ifPresent(number -> this.setCustomModelData(number.intValue()));
        }
        @Nullable ItemType itemType = ItemUtils.getItemType(type);
        if (itemType == null) {
            return (T)this;
        }
        return this.withType(itemType);
    }

    @NotNull
    public T setDisplayLore(@NotNull List<String> displayLore) {
        if (displayLore.isEmpty()) {
            return (T)this;
        }
        this.displayLore = displayLore;
        return (T)this;
    }

    @NotNull
    public T addDisplayLore(@NotNull String displayLore) {
        if (displayLore.isEmpty()) {
            return (T)this;
        }
        this.displayLore.add(displayLore);
        return (T)this;
    }

    @NotNull
    public T setDisplayName(@NotNull String displayName) {
        if (displayName.isEmpty()) {
            return (T)this;
        }
        this.displayName = displayName;
        return (T)this;
    }

    @NotNull
    public T setCustomModelData(int model) {
        if (model == -1) {
            return (T)this;
        }
        this.itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)this.populateData().addFloat((float)model).build()));
        return (T)this;
    }

    @NotNull
    public T setCustomModelData(@NotNull String model) {
        if (model.isEmpty()) {
            return (T)this;
        }
        Optional<Number> integer = StringUtils.tryParseInt(model);
        if (integer.isPresent()) {
            return this.setCustomModelData(integer.orElse(-1).intValue());
        }
        CustomModelData.Builder data = this.populateData();
        this.itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)data.addString(model).build()));
        return (T)this;
    }

    @NotNull
    public T setItemModel(@NotNull String itemModel) {
        if (itemModel.isEmpty()) {
            return (T)this;
        }
        this.itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)NamespacedKey.minecraft((String)itemModel));
        return (T)this;
    }

    @NotNull
    public T setItemModel(@NotNull String namespace, @NotNull String itemModel) {
        if (namespace.isEmpty() || itemModel.isEmpty()) {
            return (T)this;
        }
        this.itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)new NamespacedKey(namespace, itemModel));
        return (T)this;
    }

    @NotNull
    public T setHidingItemFlags(boolean isHidingItemFlags) {
        this.isHidingItemFlags = isHidingItemFlags;
        return (T)this;
    }

    @NotNull
    public T setHidingToolTips(boolean isHidingToolTips) {
        this.isHidingToolTips = isHidingToolTips;
        return (T)this;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public T setFireResistant() {
        return this.addDamageTag((Tag<DamageType>)DamageTypeTags.IS_FIRE);
    }

    @NotNull
    public T addDamageTag(@NotNull Tag<DamageType> tag) {
        this.damageTags.add(tag);
        return (T)this;
    }

    @NotNull
    public T removeDamageTag(@NotNull Tag<DamageType> tag) {
        this.damageTags.remove(tag);
        return (T)this;
    }

    @NotNull
    public T addFireworkEffect(@NotNull FireworkEffect.Builder effect) {
        if (!this.isFirework() && !this.isFireworkStar()) {
            return (T)this;
        }
        this.fireworkEffects.add(effect.build());
        return (T)this;
    }

    @NotNull
    public T setFireworkPower(int fireworkPower) {
        if (!this.isFirework() && !this.isFireworkStar()) {
            return (T)this;
        }
        this.fireworkPower = fireworkPower;
        return (T)this;
    }

    @NotNull
    public T setUnbreakable(boolean isUnbreakable) {
        this.isUnbreakable = isUnbreakable;
        return (T)this;
    }

    @NotNull
    public T setGlowing(boolean isGlowing) {
        this.isGlowing = isGlowing;
        return (T)this;
    }

    @NotNull
    public T setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return (T)this;
    }

    @NotNull
    public T addNamePlaceholder(@NotNull String placeholder, @NotNull String value) {
        return this.addPlaceholder(placeholder, value, false);
    }

    @NotNull
    public T setNamePlaceholders(@NotNull Map<String, String> placeholders) {
        placeholders.forEach(this::addNamePlaceholder);
        return (T)this;
    }

    @NotNull
    public T addLorePlaceholder(@NotNull String placeholder, @NotNull String value) {
        return this.addPlaceholder(placeholder, value, true);
    }

    @NotNull
    public T setLorePlaceholders(@NotNull Map<String, String> placeholders) {
        placeholders.forEach(this::addLorePlaceholder);
        return (T)this;
    }

    @NotNull
    public T addPattern(@NotNull PatternType type, @NotNull DyeColor color) {
        if (!this.isBanner() && !this.isShield()) {
            return (T)this;
        }
        this.patterns.add(new Pattern(color, type));
        return (T)this;
    }

    @NotNull
    public T addPattern(@NotNull String pattern) {
        if (!this.isBanner() && !this.isShield()) {
            return (T)this;
        }
        if (!pattern.contains(":")) {
            return (T)this;
        }
        String[] sections = pattern.split(":");
        PatternType type = ItemUtils.getPatternType(sections[0].toLowerCase());
        DyeColor color = ColorUtils.getDyeColor(sections[1]);
        if (type == null) {
            return (T)this;
        }
        return this.addPattern(type, color);
    }

    @NotNull
    public T addPatterns(@NotNull List<String> patterns) {
        if (!this.isBanner() && !this.isShield()) {
            return (T)this;
        }
        patterns.forEach(this::addPattern);
        return (T)this;
    }

    @NotNull
    public T addPotionEffect(@NotNull PotionEffectType type, int duration, int amplifier) {
        if (!this.isArrow() && !this.isPotion()) {
            return (T)this;
        }
        this.potionEffects.add(new PotionEffect(type, duration, amplifier));
        return (T)this;
    }

    @NotNull
    public T setPotionType(@NotNull PotionType potionType) {
        if (!this.isPotion()) {
            return (T)this;
        }
        this.potionType = potionType;
        return (T)this;
    }

    @NotNull
    public T setColor(@NotNull Color color) {
        this.color = color;
        return (T)this;
    }

    @NotNull
    public T setCustom(boolean isCustom) {
        this.isCustom = isCustom;
        return (T)this;
    }

    @NotNull
    public T setEntityType(@NotNull EntityType entityType) {
        this.entityType = entityType;
        return (T)this;
    }

    @NotNull
    public T setDamage(int damage) {
        this.damage = damage;
        return (T)this;
    }

    @NotNull
    public T setPersistentDouble(@NotNull NamespacedKey key, double value) {
        this.nbt.setItemStack(this.itemStack).setPersistentDouble(key, value);
        return (T)this;
    }

    @NotNull
    public T setPersistentInteger(@NotNull NamespacedKey key, int value) {
        this.nbt.setItemStack(this.itemStack).setPersistentInteger(key, value);
        return (T)this;
    }

    @NotNull
    public T setPersistentBoolean(@NotNull NamespacedKey key, boolean value) {
        this.nbt.setItemStack(this.itemStack).setPersistentBoolean(key, value);
        return (T)this;
    }

    @NotNull
    public T setPersistentString(@NotNull NamespacedKey key, @NotNull String value) {
        this.nbt.setItemStack(this.itemStack).setPersistentString(key, value);
        return (T)this;
    }

    @NotNull
    public T setPersistentList(@NotNull NamespacedKey key, @NotNull List<String> values) {
        this.nbt.setItemStack(this.itemStack).setPersistentList(key, values);
        return (T)this;
    }

    public final boolean getBoolean(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).getBoolean(key);
    }

    public final double getDouble(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).getDouble(key);
    }

    public final int getInteger(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).getInteger(key);
    }

    @NotNull
    public List<String> getList(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).getList(key);
    }

    @NotNull
    public String getString(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).getString(key);
    }

    @NotNull
    public T removePersistentKey(@Nullable NamespacedKey key) {
        this.nbt.setItemStack(this.itemStack).removePersistentKey(key);
        return (T)this;
    }

    public final boolean hasKey(@NotNull NamespacedKey key) {
        return this.nbt.setItemStack(this.itemStack).hasKey(key);
    }

    @Nullable
    public UUID getPlayer() {
        return this.player;
    }

    @NotNull
    public T setPlayer(@NotNull Player player) {
        if (player.isEmpty()) {
            return (T)this;
        }
        this.player = player.getUniqueId();
        return (T)this;
    }

    @NotNull
    public T setPlayer(@NotNull String player) {
        if (player.isEmpty()) {
            return (T)this;
        }
        if (player.length() > 16) {
            this.url = "https://textures.minecraft.net/texture/" + player;
            return (T)this;
        }
        this.uuid = new PlayerBuilder(this.server, player).getUniqueId();
        return (T)this;
    }

    @NotNull
    public T setSkull(@NotNull UUID uuid) {
        if (!this.isPlayerHead()) {
            return (T)this;
        }
        this.uuid = uuid;
        return (T)this;
    }

    @NotNull
    public T setSkull(@NotNull String skull) {
        if (skull.isEmpty()) {
            return (T)this;
        }
        @NotNull Optional<HeadDatabaseAPI> key = this.fusion.getHeadDatabaseAPI();
        ItemStack itemStack = null;
        if (key.isPresent()) {
            HeadDatabaseAPI api = key.get();
            if (api.isHead(skull)) {
                itemStack = api.getItemHead(skull);
            }
        } else {
            itemStack = this.itemStack.withType(Material.PLAYER_HEAD);
        }
        this.itemStack = itemStack;
        return (T)this;
    }

    @NotNull
    public T addEnchantment(@NotNull String enchant, int level, boolean ignoreLevelCap) {
        if (this.isCustom || enchant.isEmpty() || level < 0) {
            return (T)this;
        }
        @Nullable Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (this.isEnchantedBook() && itemMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)itemMeta;
                storageMeta.addStoredEnchant(enchantment, level, ignoreLevelCap);
                return;
            }
            itemMeta.addEnchant(enchantment, level, ignoreLevelCap);
        });
        return (T)this;
    }

    @NotNull
    public T removeEnchantment(@NotNull String enchant) {
        if (this.isCustom) {
            return (T)this;
        }
        if (enchant.isEmpty()) {
            return (T)this;
        }
        @Nullable Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (T)this;
        }
        if (this.hasItemMeta()) {
            this.itemStack.editMeta(itemMeta -> {
                EnchantmentStorageMeta storageMeta;
                if (this.isEnchantedBook() && itemMeta instanceof EnchantmentStorageMeta && (storageMeta = (EnchantmentStorageMeta)itemMeta).hasStoredEnchant(enchantment)) {
                    storageMeta.removeStoredEnchant(enchantment);
                    return;
                }
                if (itemMeta.hasEnchant(enchantment)) {
                    itemMeta.removeEnchant(enchantment);
                }
            });
        }
        return (T)this;
    }

    @NotNull
    public T addEnchantments(@NotNull Map<String, Integer> enchantments, boolean ignoreLevelCap) {
        if (this.isCustom) {
            return (T)this;
        }
        if (enchantments.isEmpty()) {
            return (T)this;
        }
        enchantments.forEach((enchantment, level) -> this.addEnchantment((String)enchantment, (int)level, ignoreLevelCap));
        return (T)this;
    }

    @NotNull
    public T removeEnchantments(@NotNull Set<String> enchantments) {
        if (this.isCustom) {
            return (T)this;
        }
        if (enchantments.isEmpty()) {
            return (T)this;
        }
        enchantments.forEach(this::removeEnchantment);
        return (T)this;
    }

    @NotNull
    public T applyUnbreakable() {
        if (this.isCustom) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> itemMeta.setUnbreakable(this.isUnbreakable));
        return (T)this;
    }

    @NotNull
    public T applyEntityType() {
        if (this.isCustom) {
            return (T)this;
        }
        if (!this.isSpawner()) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (itemMeta instanceof BlockStateMeta) {
                BlockStateMeta blockState = (BlockStateMeta)itemMeta;
                CreatureSpawner creatureSpawner = (CreatureSpawner)blockState.getBlockState();
                creatureSpawner.setSpawnedType(this.entityType);
                blockState.setBlockState((BlockState)creatureSpawner);
            }
        });
        return (T)this;
    }

    @NotNull
    public T applyTrim(@NotNull String pattern, @NotNull String material) {
        if (this.isCustom) {
            return (T)this;
        }
        if (pattern.isEmpty() || material.isEmpty()) {
            return (T)this;
        }
        TrimMaterial trimMaterial = ItemUtils.getTrimMaterial(material);
        TrimPattern trimPattern = ItemUtils.getTrimPattern(pattern);
        if (trimPattern == null || trimMaterial == null) {
            return (T)this;
        }
        return this.applyTrim(trimPattern, trimMaterial);
    }

    @NotNull
    public T applyTrimPattern(@NotNull String pattern) {
        if (this.isCustom) {
            return (T)this;
        }
        if (pattern.isEmpty()) {
            return (T)this;
        }
        TrimPattern trimPattern = ItemUtils.getTrimPattern(pattern);
        if (trimPattern == null) {
            return (T)this;
        }
        this.trimPattern = trimPattern;
        return (T)this;
    }

    @NotNull
    public T applyTrimMaterial(@NotNull String material) {
        if (this.isCustom) {
            return (T)this;
        }
        if (material.isEmpty()) {
            return (T)this;
        }
        TrimMaterial trimMaterial = ItemUtils.getTrimMaterial(material);
        if (trimMaterial == null) {
            return (T)this;
        }
        this.trimMaterial = trimMaterial;
        return (T)this;
    }

    @NotNull
    public T applyPattern() {
        if (this.isCustom) {
            return (T)this;
        }
        if (this.patterns.isEmpty()) {
            return (T)this;
        }
        if (this.isBanner()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof BannerMeta) {
                    BannerMeta banner = (BannerMeta)itemMeta;
                    banner.setPatterns(this.patterns);
                }
            });
        } else if (this.isShield()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof BlockStateMeta) {
                    BlockStateMeta shield = (BlockStateMeta)itemMeta;
                    Banner banner = (Banner)shield.getBlockState();
                    banner.setPatterns(this.patterns);
                    banner.update();
                    shield.setBlockState((BlockState)banner);
                }
            });
        }
        return (T)this;
    }

    @NotNull
    public T applyDamage() {
        if (this.isCustom) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                if (this.damage <= 0) {
                    return;
                }
                if (this.damage >= this.getType().getMaxDurability()) {
                    damageable.setDamage((int)this.getType().getMaxDurability());
                } else {
                    damageable.setDamage(this.damage);
                }
            }
        });
        return (T)this;
    }

    @NotNull
    public T applyEffects() {
        if (this.isCustom) {
            return (T)this;
        }
        if (this.isFirework() || this.isFireworkStar() && !this.fireworkEffects.isEmpty()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof FireworkMeta) {
                    FireworkMeta firework = (FireworkMeta)itemMeta;
                    this.fireworkEffects.forEach(arg_0 -> ((FireworkMeta)firework).addEffect(arg_0));
                    firework.setPower(this.fireworkPower);
                }
            });
        } else if (this.isPotion() || this.isArrow() && !this.potionEffects.isEmpty()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta potion = (PotionMeta)itemMeta;
                    this.potionEffects.forEach(effect -> potion.addCustomEffect(effect, true));
                    if (this.potionType != null) {
                        potion.setBasePotionType(this.potionType);
                    }
                }
            });
        }
        return (T)this;
    }

    @NotNull
    public T applyTexture() {
        if (this.isCustom) {
            return (T)this;
        }
        if (this.url.isEmpty()) {
            return (T)this;
        }
        if (!this.isPlayerHead()) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (itemMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                PlayerProfile profile = this.fusion.createProfile(UUID.randomUUID(), "");
                profile.setProperty(new ProfileProperty("", ""));
                PlayerTextures textures = profile.getTextures();
                try {
                    textures.setSkin(URI.create(this.url).toURL(), PlayerTextures.SkinModel.CLASSIC);
                }
                catch (MalformedURLException exception) {
                    throw new FusionException("Failed to load skull texture!", exception);
                }
                profile.setTextures(textures);
                skullMeta.setPlayerProfile(profile);
            }
        });
        return (T)this;
    }

    @NotNull
    public T applySkull() {
        if (this.isCustom) {
            return (T)this;
        }
        if (this.uuid == null) {
            return (T)this;
        }
        if (!this.isPlayerHead()) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            SkullMeta skull;
            if (itemMeta instanceof SkullMeta && !(skull = (SkullMeta)itemMeta).hasOwner()) {
                skull.setOwningPlayer(this.getOfflinePlayer(this.uuid));
            }
        });
        return (T)this;
    }

    @NotNull
    public T applyTrim(@NotNull TrimPattern trimPattern, @NotNull TrimMaterial trimMaterial) {
        if (this.isCustom) {
            return (T)this;
        }
        if (!this.isArmor()) {
            return (T)this;
        }
        this.itemStack.editMeta(itemMeta -> {
            if (itemMeta instanceof ArmorMeta) {
                ArmorMeta armorMeta = (ArmorMeta)itemMeta;
                armorMeta.setTrim(new ArmorTrim(trimMaterial, trimPattern));
            }
        });
        return (T)this;
    }

    @NotNull
    public T applyColor() {
        if (this.isCustom) {
            return (T)this;
        }
        if (this.color == null) {
            return (T)this;
        }
        if (this.isArrow() || this.isPotion()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta potion = (PotionMeta)itemMeta;
                    potion.setColor(this.color);
                }
            });
        } else if (this.isLeather()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta armor = (LeatherArmorMeta)itemMeta;
                    armor.setColor(this.color);
                }
            });
        } else if (this.isMap()) {
            this.itemStack.editMeta(itemMeta -> {
                if (itemMeta instanceof MapMeta) {
                    MapMeta map = (MapMeta)itemMeta;
                    map.setScaling(true);
                    map.setColor(this.color);
                }
            });
        }
        return (T)this;
    }

    @NotNull
    public String getStrippedName() {
        return PlainTextComponentSerializer.plainText().serialize(this.itemStack.displayName());
    }

    @NotNull
    public List<String> getStrippedLore() {
        ArrayList<String> lore = new ArrayList<String>();
        this.displayComponentLore.forEach(line -> lore.add(PlainTextComponentSerializer.plainText().serialize(line)));
        return lore;
    }

    @NotNull
    public List<String> getDisplayLore() {
        return this.displayLore;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    public final boolean hasItemMeta() {
        return !this.itemStack.hasItemMeta();
    }

    @NotNull
    public Material getType() {
        return this.itemStack.getType();
    }

    public final boolean isBanner() {
        return BANNERS.contains(this.getType());
    }

    public final boolean isArmor() {
        return ARMOR.contains(this.getType());
    }

    public final boolean isShulker() {
        return SHULKERS.contains(this.getType());
    }

    public final boolean isLeather() {
        return LEATHER_ARMOR.contains(this.getType());
    }

    public final boolean isPotion() {
        return POTIONS.contains(this.getType());
    }

    public final boolean isEnchantedBook() {
        return this.getType().equals((Object)Material.ENCHANTED_BOOK);
    }

    public final boolean isPlayerHead() {
        return this.getType().equals((Object)Material.PLAYER_HEAD);
    }

    public final boolean isFireworkStar() {
        return this.getType().equals((Object)Material.FIREWORK_STAR);
    }

    public final boolean isFirework() {
        return this.getType().equals((Object)Material.FIREWORK_ROCKET);
    }

    public final boolean isSpawner() {
        return this.getType().equals((Object)Material.SPAWNER);
    }

    public final boolean isShield() {
        return this.getType().equals((Object)Material.SHIELD);
    }

    public final boolean isArrow() {
        return this.getType().equals((Object)Material.ARROW);
    }

    public final boolean isMap() {
        return this.getType().equals((Object)Material.MAP);
    }

    public final boolean isHidingItemFlags() {
        return this.isHidingItemFlags;
    }

    public final boolean isHidingToolTips() {
        return this.isHidingToolTips;
    }

    @NotNull
    private T addPlaceholder(@NotNull String placeholder, @NotNull String value, boolean isLore) {
        if (isLore) {
            this.displayLorePlaceholders.put(placeholder, value);
            return (T)this;
        }
        this.displayNamePlaceholders.put(placeholder, value);
        return (T)this;
    }

    @NotNull
    private OfflinePlayer getOfflinePlayer(@NotNull UUID uuid) {
        return this.server.getOfflinePlayer(uuid);
    }

    @Nullable
    private Player getPlayer(@NotNull UUID uuid) {
        return this.server.getPlayer(uuid);
    }

    @NotNull
    private CustomModelData.Builder populateData() {
        CustomModelData component;
        CustomModelData.Builder data = CustomModelData.customModelData();
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (component = (CustomModelData)this.itemStack.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
            data.addFloats(component.floats()).addStrings(component.strings()).addFlags(component.flags()).addColors(component.colors());
        }
        return data;
    }

    private void getItemsAdder(@NotNull String item) {
        if (!CustomStack.isInRegistry((String)item)) {
            return;
        }
        CustomStack builder = CustomStack.getInstance((String)item);
        if (builder == null) {
            throw new FusionException(String.format("The id %s is not a valid ItemsAdder item!", item));
        }
        this.itemStack = builder.getItemStack();
    }

    private void getOraxen(@NotNull String item) {
        if (!OraxenItems.exists((String)item)) {
            return;
        }
        io.th0rgal.oraxen.items.ItemBuilder builder = OraxenItems.getItemById((String)item);
        if (builder == null) {
            throw new FusionException(String.format("The id %s is not a valid Oraxen item!", item));
        }
        this.itemStack = builder.build();
    }

    private void getNexo(@NotNull String item) {
        if (!NexoItems.exists((String)item)) {
            return;
        }
        com.nexomc.nexo.items.ItemBuilder builder = NexoItems.itemFromId((String)item);
        if (builder == null) {
            throw new FusionException(String.format("The id %s is not a valid Nexo item!", item));
        }
        this.itemStack = builder.build();
    }
}

