/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builders.items;

import com.nexomc.nexo.api.NexoItems;
import dev.lone.itemsadder.api.CustomStack;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.MapItemColor;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.enums.Support;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.utils.StringUtils;
import libs.com.ryderbelserion.fusion.paper.FusionPaper;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiAction;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.PatternBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.PotionBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.SkullBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.SpawnerBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.fireworks.FireworkBuilder;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.types.fireworks.FireworkStarBuilder;
import libs.com.ryderbelserion.fusion.paper.utils.ColorUtils;
import libs.com.ryderbelserion.fusion.paper.utils.ItemUtils;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public abstract class BaseItemBuilder<B extends BaseItemBuilder<B>> {
    protected final FusionPaper fusion = (FusionPaper)FusionProvider.get();
    private Map<String, String> placeholders = new HashMap<String, String>();
    private List<String> displayLore = new ArrayList<String>();
    private String displayName = null;
    private boolean isStatic = false;
    private ItemType itemType;
    private ItemStack item;
    private static final Set<String> armor = new HashSet<String>(){
        {
            this.add(ItemType.LEATHER_HELMET.key().asString());
            this.add(ItemType.LEATHER_CHESTPLATE.key().asString());
            this.add(ItemType.LEATHER_LEGGINGS.key().asString());
            this.add(ItemType.LEATHER_BOOTS.key().asString());
            this.add(ItemType.LEATHER_HORSE_ARMOR.key().asString());
            this.add(ItemType.CHAINMAIL_HELMET.key().asString());
            this.add(ItemType.CHAINMAIL_CHESTPLATE.key().asString());
            this.add(ItemType.CHAINMAIL_LEGGINGS.key().asString());
            this.add(ItemType.CHAINMAIL_BOOTS.key().asString());
            this.add(ItemType.IRON_HELMET.key().asString());
            this.add(ItemType.IRON_CHESTPLATE.key().asString());
            this.add(ItemType.IRON_LEGGINGS.key().asString());
            this.add(ItemType.IRON_BOOTS.key().asString());
            this.add(ItemType.DIAMOND_HELMET.key().asString());
            this.add(ItemType.DIAMOND_CHESTPLATE.key().asString());
            this.add(ItemType.DIAMOND_LEGGINGS.key().asString());
            this.add(ItemType.DIAMOND_BOOTS.key().asString());
            this.add(ItemType.GOLDEN_HELMET.key().asString());
            this.add(ItemType.GOLDEN_CHESTPLATE.key().asString());
            this.add(ItemType.GOLDEN_LEGGINGS.key().asString());
            this.add(ItemType.GOLDEN_BOOTS.key().asString());
            this.add(ItemType.NETHERITE_HELMET.key().asString());
            this.add(ItemType.NETHERITE_CHESTPLATE.key().asString());
            this.add(ItemType.NETHERITE_LEGGINGS.key().asString());
            this.add(ItemType.NETHERITE_BOOTS.key().asString());
            this.add(ItemType.TURTLE_HELMET.key().asString());
        }
    };
    private static final Set<String> leather_items = new HashSet<String>(){
        {
            this.add(ItemType.LEATHER_HELMET.key().asString());
            this.add(ItemType.LEATHER_CHESTPLATE.key().asString());
            this.add(ItemType.LEATHER_LEGGINGS.key().asString());
            this.add(ItemType.LEATHER_BOOTS.key().asString());
            this.add(ItemType.LEATHER_HORSE_ARMOR.key().asString());
        }
    };
    private static final Set<String> potions = new HashSet<String>(){
        {
            this.add(ItemType.POTION.key().asString());
            this.add(ItemType.SPLASH_POTION.key().asString());
            this.add(ItemType.LINGERING_POTION.key().asString());
        }
    };

    public BaseItemBuilder(@NotNull ItemStack item) {
        this.itemType = item.getType().asItemType();
        this.item = item;
    }

    public BaseItemBuilder(@NotNull String item) {
        this.withCustomItem(item);
    }

    @NotNull
    public GuiItem asGuiItem(@Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        return new GuiItem(this.asItemStack(), action);
    }

    @NotNull
    public GuiItem asGuiItem() {
        return new GuiItem(this.asItemStack(), null);
    }

    @NotNull
    public GuiItem asGuiItem(@NotNull Audience audience, @Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        return new GuiItem(this.asItemStack(audience), action);
    }

    @NotNull
    public GuiItem asGuiItem(@NotNull Audience audience) {
        return new GuiItem(this.asItemStack(audience), null);
    }

    @NotNull
    public ItemStack asItemStack(@NotNull Audience audience) {
        List<String> lore;
        if (this.displayName != null) {
            Component component = this.fusion.color(audience, this.displayName, this.placeholders);
            this.item.setData(this.isStatic ? DataComponentTypes.ITEM_NAME : DataComponentTypes.CUSTOM_NAME, (Object)component);
        }
        if (!(lore = this.displayLore).isEmpty()) {
            ArrayList components = new ArrayList(lore.size());
            lore.forEach(line -> components.add(this.fusion.color(audience, (String)line, this.placeholders)));
            this.item.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(components));
        }
        this.build();
        return this.item;
    }

    @NotNull
    public ItemStack asItemStack() {
        return this.asItemStack(Audience.empty());
    }

    @NotNull
    public B build() {
        return (B)this;
    }

    @NotNull
    public B withCustomItem(@NotNull String item) {
        switch (this.fusion.getItemsPlugin().toLowerCase()) {
            case "nexo": {
                if (Support.nexo.isEnabled()) {
                    this.getNexo(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "oraxen": {
                if (Support.oraxen.isEnabled()) {
                    this.getOraxen(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "itemsadder": {
                if (Support.items_adder.isEnabled()) {
                    this.getItemsAdder(item);
                    return (B)this;
                }
                this.setItem(item);
                break;
            }
            case "none": {
                this.setItem(item);
                break;
            }
            default: {
                if (Support.nexo.isEnabled()) {
                    this.getNexo(item);
                    return (B)this;
                }
                if (Support.items_adder.isEnabled()) {
                    this.getItemsAdder(item);
                    return (B)this;
                }
                if (Support.oraxen.isEnabled()) {
                    this.getOraxen(item);
                    return (B)this;
                }
                this.setItem(item);
            }
        }
        return (B)this;
    }

    @NotNull
    public B withBase64(@NotNull String base64) {
        if (base64.isEmpty()) {
            return (B)this;
        }
        try {
            this.item = ItemUtils.fromBase64(base64);
        }
        catch (Exception exception) {
            this.item = ItemType.STONE.createItemStack(1);
        }
        this.itemType = this.item.getType().asItemType();
        return (B)this;
    }

    @NotNull
    public B withType(@Nullable ItemType type, int amount) {
        if (type == null) {
            throw new FusionException("The item type cannot be null!");
        }
        ItemStack itemStack = type.createItemStack(Math.max(amount, 1));
        this.setItemStack(this.item == null ? itemStack : this.item.withType(itemStack.getType()));
        this.item.setAmount(itemStack.getAmount());
        return (B)this;
    }

    @NotNull
    public B withType(@Nullable ItemType type) {
        return this.withType(type, 1);
    }

    @NotNull
    public B addEnchantments(@NotNull Map<String, Integer> enchantments) {
        for (Map.Entry<String, Integer> entry : enchantments.entrySet()) {
            this.addEnchantment(entry.getKey(), entry.getValue());
        }
        return (B)this;
    }

    @NotNull
    public B addEnchantment(@NotNull String enchant, int level) {
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        ItemEnchantments.Builder builder = ItemEnchantments.itemEnchantments();
        if (this.isBook() && this.item.hasData((DataComponentType)DataComponentTypes.STORED_ENCHANTMENTS)) {
            ItemEnchantments enchantments = (ItemEnchantments)this.item.getData(DataComponentTypes.STORED_ENCHANTMENTS);
            if (enchantments != null) {
                builder.addAll(enchantments.enchantments());
            }
        } else {
            Map enchantments = this.item.getEnchantments();
            if (!enchantments.isEmpty()) {
                builder.addAll(enchantments);
            }
        }
        builder.add(enchantment, level);
        this.item.setData(this.isBook() ? DataComponentTypes.STORED_ENCHANTMENTS : DataComponentTypes.ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        return (B)this;
    }

    @NotNull
    public B removeEnchantment(@NotNull String enchant) {
        if (enchant.isEmpty()) {
            return (B)this;
        }
        Enchantment enchantment = ItemUtils.getEnchantment(enchant);
        if (enchantment == null) {
            return (B)this;
        }
        this.item.removeEnchantment(enchantment);
        return (B)this;
    }

    @NotNull
    public B setAmount(int amount) {
        this.item.setAmount(Math.max(amount, 1));
        return (B)this;
    }

    @NotNull
    public B setDisplayName(@Nullable String displayName, boolean isStatic) {
        this.displayName = displayName;
        this.isStatic = isStatic;
        return (B)this;
    }

    @NotNull
    public B setDisplayName(@Nullable String displayName) {
        return this.setDisplayName(displayName, false);
    }

    @NotNull
    public String getPlainName() {
        Component customName;
        TextComponent component = Component.empty();
        if (this.item.hasData((DataComponentType)DataComponentTypes.ITEM_NAME)) {
            Component itemName = (Component)this.item.getData(DataComponentTypes.ITEM_NAME);
            if (itemName != null) {
                component = itemName;
            }
        } else if (this.item.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME) && (customName = (Component)this.item.getData(DataComponentTypes.CUSTOM_NAME)) != null) {
            component = customName;
        }
        return (String)PlainTextComponentSerializer.plainText().serializeOr((Component)component, (Object)"");
    }

    @NotNull
    public B withDisplayLore(@NotNull List<String> displayLore) {
        this.displayLore = displayLore;
        return (B)this;
    }

    @NotNull
    public B addDisplayLore(@NotNull String displayLore) {
        if (displayLore.isEmpty()) {
            return (B)this;
        }
        this.displayLore.add(displayLore);
        return (B)this;
    }

    @NotNull
    public List<String> getPlainLore() {
        ItemLore lore;
        ArrayList<String> plainLore = new ArrayList<String>();
        if (this.item.hasData((DataComponentType)DataComponentTypes.LORE) && (lore = (ItemLore)this.item.getData(DataComponentTypes.LORE)) != null) {
            lore.lines().forEach(line -> plainLore.add(PlainTextComponentSerializer.plainText().serialize(line)));
        }
        return plainLore;
    }

    @NotNull
    public B setEnchantGlint(boolean isGlowing) {
        if (isGlowing && !this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            this.item.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            return (B)this;
        }
        if (this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            this.item.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        }
        return (B)this;
    }

    @NotNull
    public B removeEnchantGlint() {
        if (!this.item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            return (B)this;
        }
        this.item.unsetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        return (B)this;
    }

    @NotNull
    public B hideToolTip() {
        this.item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)this.builder().hideTooltip(true).build()));
        return (B)this;
    }

    @NotNull
    public B showToolTip() {
        if (!this.item.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY)) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)this.builder().hideTooltip(false).build()));
        return (B)this;
    }

    @NotNull
    public B hideComponents(@NotNull List<String> components) {
        for (String component : components) {
            this.hideComponent(component);
        }
        return (B)this;
    }

    @NotNull
    public B hideComponent(@NotNull String component) {
        TooltipDisplay components;
        if (component.isEmpty()) {
            return (B)this;
        }
        Optional<DataComponentType> type = ItemUtils.getDataComponentType(component);
        if (type.isEmpty()) {
            return (B)this;
        }
        TooltipDisplay.Builder display = TooltipDisplay.tooltipDisplay();
        if (this.item.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) && (components = (TooltipDisplay)this.item.getData(DataComponentTypes.TOOLTIP_DISPLAY)) != null) {
            display.hiddenComponents(components.hiddenComponents());
        }
        display.addHiddenComponents(new DataComponentType[]{type.get()});
        this.item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (DataComponentBuilder)display);
        return (B)this;
    }

    @NotNull
    public B setUnbreakable(boolean isUnbreakable) {
        if (isUnbreakable && !this.item.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.item.setData(DataComponentTypes.UNBREAKABLE);
            return (B)this;
        }
        if (this.item.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE)) {
            this.item.unsetData((DataComponentType)DataComponentTypes.UNBREAKABLE);
        }
        return (B)this;
    }

    @NotNull
    public B setCustomModelData(int customModelData) {
        if (customModelData == -1) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)this.populateData().addFloat((float)customModelData).build()));
        return (B)this;
    }

    @NotNull
    public B setCustomModelData(@NotNull String customModelData) {
        if (customModelData.isEmpty()) {
            return (B)this;
        }
        Optional<Number> integer = StringUtils.tryParseInt(customModelData);
        if (integer.isPresent()) {
            return this.setCustomModelData(integer.orElse(-1).intValue());
        }
        CustomModelData.Builder data = this.populateData();
        this.item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)data.addString(customModelData).build()));
        return (B)this;
    }

    @NotNull
    public B setItemModel(@NotNull String itemModel) {
        if (itemModel.isEmpty()) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.ITEM_MODEL, (Object)NamespacedKey.minecraft((String)itemModel));
        return (B)this;
    }

    @NotNull
    public B setItemModel(@NotNull String namespace, @NotNull String itemModel) {
        if (namespace.isEmpty() || itemModel.isEmpty()) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.ITEM_MODEL, (Object)new NamespacedKey(namespace, itemModel));
        return (B)this;
    }

    @NotNull
    public B setTrim(@NotNull String pattern, @NotNull String material) {
        if (pattern.isEmpty() || material.isEmpty()) {
            return (B)this;
        }
        TrimMaterial trimMaterial = ItemUtils.getTrimMaterial(material);
        if (trimMaterial == null) {
            return (B)this;
        }
        TrimPattern trimPattern = ItemUtils.getTrimPattern(pattern);
        if (trimPattern == null) {
            return (B)this;
        }
        ItemArmorTrim.Builder builder = ItemArmorTrim.itemArmorTrim((ArmorTrim)new ArmorTrim(trimMaterial, trimPattern));
        this.item.setData(DataComponentTypes.TRIM, (Object)((ItemArmorTrim)builder.build()));
        return (B)this;
    }

    @NotNull
    public B setColor(@NotNull String value) {
        if (value.isEmpty()) {
            return (B)this;
        }
        if (this.isMap()) {
            Color color;
            Color color2 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.item.setData(DataComponentTypes.MAP_COLOR, (Object)((MapItemColor)MapItemColor.mapItemColor().color(color).build()));
            }
        } else if (this.isLeather()) {
            Color color;
            Color color3 = color = value.contains(",") ? ColorUtils.getRGB(value) : ColorUtils.getColor(value);
            if (color != null) {
                this.item.setData(DataComponentTypes.DYED_COLOR, (Object)((DyedItemColor)DyedItemColor.dyedItemColor().color(color).build()));
            }
        } else if (this.isShield()) {
            DyeColor color = ColorUtils.getDyeColor(value);
            this.item.setData(DataComponentTypes.BASE_COLOR, (Object)color);
        }
        return (B)this;
    }

    @NotNull
    public B setItemDamage(int damage) {
        if (damage == -1) {
            return (B)this;
        }
        this.item.setData(DataComponentTypes.DAMAGE, (Object)Math.min(damage, this.getType().getMaxDurability()));
        return (B)this;
    }

    @NotNull
    public B addPlaceholder(@NotNull String placeholder, @NotNull String value) {
        this.placeholders.put(placeholder, value);
        return (B)this;
    }

    @NotNull
    public B setPlaceholders(@NotNull Map<String, String> placeholders) {
        this.placeholders = placeholders;
        return (B)this;
    }

    public boolean hasPlaceholder(@NotNull String placeholder) {
        return this.placeholders.containsKey(placeholder);
    }

    @NotNull
    public B removePlaceholder(@NotNull String placeholder) {
        this.placeholders.remove(placeholder);
        return (B)this;
    }

    @NotNull
    public B withSkull(@NotNull String skull) {
        HeadDatabaseAPI api;
        if (skull.isEmpty()) {
            return (B)this;
        }
        @NotNull Optional<HeadDatabaseAPI> key = this.fusion.getHeadDatabaseAPI();
        ItemStack item = ItemType.PLAYER_HEAD.createItemStack();
        if (key.isPresent() && (api = key.get()).isHead(skull)) {
            item = api.getItemHead(skull);
        }
        this.item = item;
        return (B)this;
    }

    @NotNull
    public final B setPersistentDouble(@NotNull NamespacedKey key, double value) {
        this.item.editPersistentDataContainer(container -> container.set(key, PersistentDataType.DOUBLE, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentInteger(@NotNull NamespacedKey key, int value) {
        this.item.editPersistentDataContainer(container -> container.set(key, PersistentDataType.INTEGER, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentBoolean(@NotNull NamespacedKey key, boolean value) {
        this.item.editPersistentDataContainer(container -> container.set(key, PersistentDataType.BOOLEAN, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentString(@NotNull NamespacedKey key, @NotNull String value) {
        this.item.editPersistentDataContainer(container -> container.set(key, PersistentDataType.STRING, (Object)value));
        return (B)this;
    }

    @NotNull
    public final B setPersistentList(@NotNull NamespacedKey key, @NotNull List<String> values) {
        this.item.editPersistentDataContainer(container -> container.set(key, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)values));
        return (B)this;
    }

    public final boolean getBoolean(@NotNull NamespacedKey key) {
        return (Boolean)this.item.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BOOLEAN, (Object)false);
    }

    public final double getDouble(@NotNull NamespacedKey key) {
        return (Double)this.item.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
    }

    public final int getInteger(@NotNull NamespacedKey key) {
        return (Integer)this.item.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    @NotNull
    public final List<String> getList(@NotNull NamespacedKey key) {
        return (List)this.item.getPersistentDataContainer().getOrDefault(key, (PersistentDataType)PersistentDataType.LIST.strings(), Collections.emptyList());
    }

    @NotNull
    public final String getString(@NotNull NamespacedKey key) {
        return (String)this.item.getPersistentDataContainer().getOrDefault(key, PersistentDataType.STRING, (Object)"");
    }

    @NotNull
    public final B removePersistentKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return (B)this;
        }
        this.item.editPersistentDataContainer(container -> {
            if (container.has(key)) {
                container.remove(key);
            }
        });
        return (B)this;
    }

    public final boolean hasKey(@NotNull NamespacedKey key) {
        return this.item.getPersistentDataContainer().has(key);
    }

    @NotNull
    public final FireworkBuilder asFireworkBuilder() {
        if (!this.isFirework()) {
            throw new FusionException("This item type is not a firework rocket.");
        }
        return new FireworkBuilder(this.item);
    }

    @NotNull
    public final FireworkStarBuilder asFireworkStarBuilder() {
        if (!this.isFireworkStar()) {
            throw new FusionException("This item type is not a firework star.");
        }
        return new FireworkStarBuilder(this.item);
    }

    @NotNull
    public final PatternBuilder asPatternBuilder() {
        if (this.isShield() || this.isBanner()) {
            return new PatternBuilder(this.item);
        }
        throw new FusionException("This item type is not a shield/banner.");
    }

    @NotNull
    public final SkullBuilder asSkullBuilder() {
        if (!this.isPlayerHead()) {
            throw new FusionException("This item type is not a skull.");
        }
        return new SkullBuilder(this.item);
    }

    @NotNull
    public final PotionBuilder asPotionBuilder() {
        if (this.isPotion() || this.isTippedArrow()) {
            return new PotionBuilder(this.item);
        }
        throw new FusionException("This item type is not a potion / tipped arrow.");
    }

    @NotNull
    public final SpawnerBuilder asSpawnerBuilder() {
        if (!this.isSpawner()) {
            throw new FusionException("This item type is not a spawner.");
        }
        return new SpawnerBuilder(this.item);
    }

    public void setItemToInventory(@NotNull Audience audience, @NotNull Inventory inventory, int slot) {
        inventory.setItem(slot, this.asItemStack(audience));
    }

    public void addItemToInventory(@NotNull Audience audience, @NotNull Inventory inventory) {
        inventory.addItem(new ItemStack[]{this.asItemStack(audience)});
    }

    public void setItemToInventory(@NotNull Inventory inventory, int slot) {
        this.setItemToInventory(Audience.empty(), inventory, slot);
    }

    public void addItemToInventory(@NotNull Inventory inventory) {
        this.addItemToInventory(Audience.empty(), inventory);
    }

    public final boolean isDyeable() {
        return this.isTippedArrow() || this.isShield() || this.isLeather() || this.isMap();
    }

    public final boolean isPlayerHead() {
        return this.asString().equalsIgnoreCase(ItemType.PLAYER_HEAD.key().asString());
    }

    public final boolean isFireworkStar() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_STAR.key().asString());
    }

    public final boolean isTippedArrow() {
        return this.asString().equalsIgnoreCase(ItemType.TIPPED_ARROW.key().asString());
    }

    public final boolean isFirework() {
        return this.asString().equalsIgnoreCase(ItemType.FIREWORK_ROCKET.key().asString());
    }

    public final boolean isSpawner() {
        return this.asString().equalsIgnoreCase(ItemType.SPAWNER.key().asString());
    }

    public final boolean isShield() {
        return this.asString().equalsIgnoreCase(ItemType.SHIELD.key().asString());
    }

    public final boolean isEdible() {
        return this.itemType.isEdible();
    }

    public final boolean isArmor() {
        return armor.contains(this.asString());
    }

    public final boolean isLeather() {
        return leather_items.contains(this.asString());
    }

    public final boolean isPotion() {
        return potions.contains(this.asString());
    }

    public final boolean isBanner() {
        return this.getId().endsWith("_banner");
    }

    public final boolean isBook() {
        return this.asString().equalsIgnoreCase(ItemType.ENCHANTED_BOOK.key().asString());
    }

    public final boolean isMap() {
        return this.asString().equalsIgnoreCase(ItemType.FILLED_MAP.key().asString());
    }

    public final String getNamespace() {
        return this.getKey().namespace();
    }

    public final String asString() {
        return this.getKey().asString();
    }

    public final String getId() {
        return this.getKey().value();
    }

    @NotNull
    public final String getTranslationKey() {
        return this.itemType.translationKey();
    }

    @NotNull
    public final Key getKey() {
        return this.itemType.key();
    }

    protected final void setItemStack(@NotNull ItemStack item) {
        this.item = item;
        this.itemType = this.item.getType().asItemType();
    }

    @NotNull
    protected final ItemStack getItem() {
        return this.item;
    }

    @NotNull
    protected final ItemType getType() {
        return this.itemType;
    }

    @NotNull
    private CustomModelData.Builder populateData() {
        CustomModelData component;
        CustomModelData.Builder data = CustomModelData.customModelData();
        if (this.item.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA) && (component = (CustomModelData)this.item.getData(DataComponentTypes.CUSTOM_MODEL_DATA)) != null) {
            data.addFloats(component.floats()).addStrings(component.strings()).addFlags(component.flags()).addColors(component.colors());
        }
        return data;
    }

    private void getItemsAdder(@NotNull String item) {
        if (!CustomStack.isInRegistry((String)item)) {
            return;
        }
        CustomStack builder = CustomStack.getInstance((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid ItemsAdder item!");
        }
        this.setItemStack(builder.getItemStack());
    }

    private void getOraxen(@NotNull String item) {
        if (!OraxenItems.exists((String)item)) {
            return;
        }
        ItemBuilder builder = OraxenItems.getItemById((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid Oraxen item!");
        }
        this.setItemStack(builder.build());
    }

    private void getNexo(@NotNull String item) {
        if (!NexoItems.exists((String)item)) {
            return;
        }
        com.nexomc.nexo.items.ItemBuilder builder = NexoItems.itemFromId((String)item);
        if (builder == null) {
            throw new FusionException("The id " + item + " is not a valid Nexo item!");
        }
        this.setItemStack(builder.build());
    }

    @NotNull
    private TooltipDisplay.Builder builder() {
        TooltipDisplay display;
        TooltipDisplay.Builder builder = TooltipDisplay.tooltipDisplay();
        if (this.item.hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) && (display = (TooltipDisplay)this.item.getData(DataComponentTypes.TOOLTIP_DISPLAY)) != null) {
            builder.hideTooltip(display.hideTooltip());
            builder.hiddenComponents(display.hiddenComponents());
        }
        return builder;
    }

    private void setItem(@NotNull String item) {
        ItemType itemType = ItemUtils.getItemType(item);
        if (itemType != null) {
            this.withType(itemType);
        } else {
            this.withBase64(item);
        }
    }
}

