/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper.api.builders;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public record PlayerBuilder(Server server, String name) {
    @Nullable
    public PlayerProfile getOfflineProfile() {
        if (this.name.isEmpty()) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> this.server.createProfile(this.name)).join();
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> this.server.getOfflinePlayer(this.name)).join();
    }

    @Nullable
    public Player getPlayer() {
        if (this.name.isEmpty()) {
            return null;
        }
        return this.server.getPlayerExact(this.name);
    }

    @Nullable
    public UUID getUniqueId() {
        if (this.name.isEmpty()) {
            return null;
        }
        Player player = this.getPlayer();
        if (player == null) {
            PlayerProfile profile = this.getOfflineProfile();
            if (profile != null) {
                return profile.getId();
            }
            OfflinePlayer offlinePlayer = this.getOfflinePlayer();
            if (offlinePlayer != null) {
                return offlinePlayer.getUniqueId();
            }
            return null;
        }
        return player.getUniqueId();
    }
}

