/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.core.api.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.enums.Support;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.utils.keys.ConfigKeys;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.listeners.GuiListener;
import libs.com.ryderbelserion.fusion.paper.api.commands.PaperCommandManager;
import libs.com.ryderbelserion.fusion.paper.api.structure.StructureRegistry;
import libs.com.ryderbelserion.fusion.paper.files.FileManager;
import libs.com.ryderbelserion.fusion.paper.utils.keys.PluginKeys;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionPaper
extends FusionCore {
    private PaperCommandManager commandManager;
    private StructureRegistry registry;
    private FileManager fileManager;
    private HeadDatabaseAPI api;
    private JavaPlugin plugin;
    private Server server;
    private PluginManager pluginManager;

    public FusionPaper(@NotNull ComponentLogger logger, @NotNull Path path) {
        super(logger, path, consumer -> consumer.useDefaultMigrationService().configurationData(ConfigKeys.class, PluginKeys.class));
    }

    public FusionPaper(@NotNull JavaPlugin plugin) {
        this(plugin.getComponentLogger(), plugin.getDataPath());
    }

    public void enable(@NotNull JavaPlugin plugin) {
        super.enable();
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.pluginManager = this.server.getPluginManager();
        this.registry = new StructureRegistry(this.plugin);
        if (this.fileManager == null) {
            this.fileManager = new FileManager();
        }
        this.commandManager = new PaperCommandManager(this.plugin);
        if (Support.head_database.isEnabled() && this.api == null) {
            this.api = new HeadDatabaseAPI();
        }
        this.pluginManager.registerEvents((Listener)new GuiListener(), (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        super.disable();
        this.commandManager.disable();
    }

    @Override
    @NotNull
    public final String parsePlaceholders(@NotNull Audience audience, @NotNull String message) {
        String string;
        if (Support.placeholder_api.isEnabled() && audience instanceof Player) {
            Player player = (Player)audience;
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        } else {
            string = message;
        }
        return string;
    }

    @Override
    @NotNull
    public final PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    @NotNull
    public final String chomp(@NotNull String message) {
        return StringUtils.chomp((String)message);
    }

    @Override
    public final boolean isPluginEnabled(@NotNull String name) {
        return this.pluginManager.isPluginEnabled(name);
    }

    @NotNull
    public final PlayerProfile createProfile(@NotNull UUID uuid, @Nullable String name) {
        return this.server.createProfile(uuid, name);
    }

    @Override
    @NotNull
    public final FileManager getFileManager() {
        if (this.fileManager == null) {
            throw new FusionException("An error occurred while trying to get the file manager instance.");
        }
        return this.fileManager;
    }

    @NotNull
    public final String getItemsPlugin() {
        return this.config.getProperty(PluginKeys.items_plugin);
    }

    @NotNull
    public final StructureRegistry getRegistry() {
        if (this.registry == null) {
            throw new FusionException("An error occurred while trying to get the structure registry instance.");
        }
        return this.registry;
    }

    @NotNull
    public final Optional<HeadDatabaseAPI> getHeadDatabaseAPI() {
        return Optional.ofNullable(this.api);
    }
}

