/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.FusionCore;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final Pattern ANGLE_PATTERN = Pattern.compile("[<>]");
    private static final FusionCore fusion = FusionProvider.get();

    @NotNull
    public static String toString(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder(list.size());
        for (String line : list) {
            message.append(line).append("\n");
        }
        return fusion.chomp(message.toString());
    }

    @NotNull
    public static Optional<Number> tryParseInt(@NotNull String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<Boolean> tryParseBoolean(@NotNull String value) {
        try {
            return Optional.of(Boolean.parseBoolean(value));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    @NotNull
    public static String replaceAllBrackets(@NotNull String input) {
        return StringUtils.replaceAngle(StringUtils.replaceBrackets(input));
    }

    @NotNull
    public static String replaceBrackets(@NotNull String input) {
        return BRACKET_PATTERN.matcher(input).replaceAll("<$1>");
    }

    @NotNull
    public static String replaceAngle(@NotNull String input) {
        return ANGLE_PATTERN.matcher(input).replaceAll("");
    }

    @NotNull
    public static String fromInteger(int number) {
        return NumberFormat.getIntegerInstance(Locale.US).format(number);
    }

    @NotNull
    public static String fromDouble(double number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    @NotNull
    public static String format(double value) {
        DecimalFormat decimalFormat = new DecimalFormat(fusion.getNumberFormat());
        decimalFormat.setRoundingMode(StringUtils.mode());
        return decimalFormat.format(value);
    }

    @NotNull
    public static RoundingMode mode() {
        return RoundingMode.valueOf(fusion.getRoundingFormat().toUpperCase());
    }
}

