/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.interfaces.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import libs.com.ryderbelserion.fusion.core.FusionProvider;
import libs.com.ryderbelserion.fusion.core.api.FusionCore;
import libs.com.ryderbelserion.fusion.core.api.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.api.enums.FileType;
import org.jetbrains.annotations.NotNull;

public abstract class ICustomFile<A extends ICustomFile<A>> {
    protected final FusionCore fusion = FusionProvider.get();
    private final List<FileAction> actions;
    private final Path path;

    protected ICustomFile(@NotNull Path path, @NotNull List<FileAction> actions) {
        this.actions = actions;
        this.path = path;
    }

    @NotNull
    public abstract A load();

    @NotNull
    public A save(@NotNull String content, @NotNull List<FileAction> actions) {
        return this.save();
    }

    @NotNull
    public A save() {
        return (A)this;
    }

    @NotNull
    public A delete() {
        try {
            Files.deleteIfExists(this.getPath());
            this.fusion.log("info", "Successfully deleted {}!", this.getFileName());
        }
        catch (IOException exception) {
            this.fusion.log("error", "Failed to delete {}! Exception: {}", this.getFileName(), exception.getMessage());
        }
        return (A)this;
    }

    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @NotNull
    public String getFileName() {
        return this.path.getFileName().toString();
    }

    @NotNull
    public String getPrettyName() {
        return this.getFileName().replace(this.getFileType().getExtension(), "");
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    public boolean isLoaded() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public boolean isStatic() {
        return this.actions.contains((Object)FileAction.STATIC_FILE);
    }

    @NotNull
    public List<FileAction> getActions() {
        return this.actions;
    }

    @NotNull
    public FileType getFileType() {
        return FileType.NONE;
    }
}

