/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.interfaces.files;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import libs.com.ryderbelserion.fusion.core.api.enums.FileAction;
import libs.com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import libs.com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import org.jetbrains.annotations.NotNull;

public abstract class IConfigFile<A extends IConfigFile<A, C, L>, C, L>
extends ICustomFile<A> {
    protected C configuration;
    protected final L loader;

    protected IConfigFile(@NotNull Path path, @NotNull List<FileAction> actions, @NotNull L loader) {
        super(path, actions);
        this.loader = loader;
    }

    @NotNull
    public abstract C loadConfig() throws IOException;

    public abstract void saveConfig() throws IOException;

    @NotNull
    public String getStringValueWithDefault(@NotNull String defaultValue, Object ... path) {
        return "";
    }

    @NotNull
    public String getStringValue(Object ... path) {
        return this.getStringValueWithDefault("", path);
    }

    public boolean getBooleanValueWithDefault(boolean defaultValue, Object ... path) {
        return false;
    }

    public boolean getBooleanValue(Object ... path) {
        return this.getBooleanValueWithDefault(false, path);
    }

    public double getDoubleValueWithDefault(double defaultValue, Object ... path) {
        return -1.0;
    }

    public double getDoubleValue(Object ... path) {
        return this.getDoubleValueWithDefault(0.0, path);
    }

    public long getLongValueWithDefault(long defaultValue, Object ... path) {
        return -1L;
    }

    public long getLongValue(Object ... path) {
        return this.getLongValueWithDefault(0L, path);
    }

    public int getIntValueWithDefault(int defaultValue, Object ... path) {
        return -1;
    }

    public int getIntValue(Object ... path) {
        return this.getIntValueWithDefault(0, path);
    }

    @NotNull
    public List<String> getStringList(@NotNull List<String> defaultValue, Object ... path) {
        return List.of();
    }

    @NotNull
    public List<String> getStringList(Object ... path) {
        return this.getStringList(List.of(), path);
    }

    @Override
    @NotNull
    public A load() {
        if (this.isDirectory()) {
            this.fusion.log("warn", "Cannot load configuration, as {} is a directory.", this.getFileName());
            return (A)this;
        }
        this.configuration = CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadConfig();
            }
            catch (IOException exception) {
                throw new FusionException(String.format("Failed to load configuration file %s!", this.getFileName()), exception);
            }
        }).join();
        return (A)this;
    }

    @Override
    @NotNull
    public A save() {
        if (this.isDirectory()) {
            this.fusion.log("warn", "Cannot save configuration, as {} is a directory.", this.getFileName());
            return (A)this;
        }
        if (this.configuration == null) {
            this.fusion.log("error", "Configuration is null, cannot save {}!", this.getFileName());
            return (A)this;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.saveConfig();
            }
            catch (IOException exception) {
                throw new FusionException(String.format("Failed to save configuration file %s!", this.getFileName()), exception);
            }
        }).thenAccept(v -> this.fusion.log("info", "Successfully saved {}!", this.getFileName()));
        return (A)this;
    }

    @NotNull
    public C getConfiguration() {
        return this.configuration;
    }
}

