/*
 * Decompiled with CFR 0.152.
 */
package libs.com.ryderbelserion.fusion.core.api.commands.objects;

import com.mojang.brigadier.context.CommandContext;
import org.jetbrains.annotations.NotNull;

public abstract class ICommandContext<S, P> {
    private final CommandContext<S> context;

    public ICommandContext(@NotNull CommandContext<S> context) {
        this.context = context;
    }

    public abstract P getPlayer();

    public abstract boolean isPlayer();

    @NotNull
    public final String getStringArgument(@NotNull String key) {
        return (String)this.context.getArgument(key, String.class);
    }

    public final double getDoubleArgument(@NotNull String key) {
        return (Double)this.context.getArgument(key, Double.class);
    }

    public final int getIntegerArgument(@NotNull String key) {
        return (Integer)this.context.getArgument(key, Integer.class);
    }

    public final float getFloatArgument(@NotNull String key) {
        return ((Float)this.context.getArgument(key, Float.class)).floatValue();
    }

    public CommandContext<S> getContext() {
        return this.context;
    }

    public S getSource() {
        return (S)this.context.getSource();
    }
}

