/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.suggestion.SuggestionContext;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface SimpleSuggestionHolder<S, ST> {
    @NotNull
    public List<ST> getSuggestions(@NotNull SuggestionContext<S> var1);

    public static class RichStatic<ST>
    implements Static<ST> {
        private final List<ST> suggestions;
        private final List<String> backwardsMapped;

        public RichStatic(@NotNull List<ST> suggestions, @NotNull List<String> backwardsMapped) {
            this.suggestions = suggestions;
            this.backwardsMapped = backwardsMapped;
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<Object> context) {
            return this.getSuggestions();
        }

        @Override
        public boolean contains(@NotNull String suggestion) {
            return this.backwardsMapped.contains(suggestion);
        }

        @Override
        @NotNull
        public List<ST> getSuggestions() {
            return this.suggestions;
        }
    }

    public static class SimpleStatic<ST>
    implements Static<ST> {
        private final List<String> suggestions;
        private final List<ST> mapped;

        public SimpleStatic(@NotNull List<String> suggestions, @NotNull List<ST> mapped) {
            this.suggestions = suggestions;
            this.mapped = mapped;
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<Object> context) {
            return this.getSuggestions();
        }

        @Override
        public boolean contains(@NotNull String suggestion) {
            return this.suggestions.contains(suggestion);
        }

        @Override
        @NotNull
        public List<ST> getSuggestions() {
            return this.mapped;
        }
    }

    public static class RichLocal<S, ST>
    extends AbstractLocal<S, ST> {
        public RichLocal(@NotNull Object invocationInstance, @NotNull Method method, boolean needsContext) {
            super(invocationInstance, method, needsContext);
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<S> context) {
            return (List)this.invoke(context);
        }
    }

    public static class SimpleLocal<S, ST>
    extends AbstractLocal<S, ST> {
        private final SuggestionMapper<ST> mapper;

        public SimpleLocal(@NotNull SuggestionMapper<ST> mapper, @NotNull Object invocationInstance, @NotNull Method method, boolean needsContext) {
            super(invocationInstance, method, needsContext);
            this.mapper = mapper;
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<S> context) {
            return this.mapper.map((List)this.invoke(context));
        }
    }

    public static abstract class AbstractLocal<S, ST>
    implements SimpleSuggestionHolder<S, ST> {
        private final Object invocationInstance;
        private final Method method;
        private final boolean needsContext;

        public AbstractLocal(@NotNull Object invocationInstance, @NotNull Method method, boolean needsContext) {
            this.invocationInstance = invocationInstance;
            this.method = method;
            this.needsContext = needsContext;
        }

        @NotNull
        protected Object invoke(@NotNull SuggestionContext<S> context) {
            try {
                if (this.needsContext) {
                    return this.method.invoke(this.invocationInstance, context);
                }
                return this.method.invoke(this.invocationInstance, new Object[0]);
            }
            catch (Exception e) {
                throw new CommandExecutionException("Failed to create suggestions for method '" + this.method + "'.");
            }
        }
    }

    public static class SimpleResolver<S, ST>
    implements SimpleSuggestionHolder<S, ST> {
        private final SuggestionResolver.Simple<S> resolver;
        private final SuggestionMapper<ST> mapper;

        public SimpleResolver(@NotNull SuggestionResolver.Simple<S> resolver, @NotNull SuggestionMapper<ST> mapper) {
            this.resolver = resolver;
            this.mapper = mapper;
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<S> context) {
            return this.mapper.map(this.resolver.resolve(context));
        }
    }

    public static class RichResolver<S, ST>
    implements SimpleSuggestionHolder<S, ST> {
        private final SuggestionResolver<S, ST> resolver;

        public RichResolver(@NotNull SuggestionResolver<S, ST> resolver) {
            this.resolver = resolver;
        }

        @Override
        @NotNull
        public List<ST> getSuggestions(@NotNull SuggestionContext<S> context) {
            return this.resolver.resolve(context);
        }
    }

    public static interface Static<ST>
    extends SimpleSuggestionHolder<Object, ST> {
        public boolean contains(@NotNull String var1);

        @NotNull
        public List<ST> getSuggestions();
    }
}

