/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.keyed.Flag;
import dev.triumphteam.cmd.core.argument.keyed.FlagValidator;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FlagOptions
implements Flag {
    private final String flag;
    private final String longFlag;
    private final String description;
    private final Class<?> argument;
    private final SuggestionKey suggestionKey;

    FlagOptions(@NotNull Flag.Builder builder) {
        String flag = builder.getFlag();
        String longFlag = builder.getLongFlag();
        this.flag = flag.isEmpty() ? null : flag;
        this.longFlag = longFlag.isEmpty() ? null : longFlag;
        this.description = builder.getDescription();
        this.argument = builder.getArgument();
        this.suggestionKey = builder.getSuggestionKey();
        if (this.flag == null && this.longFlag == null) {
            throw new CommandRegistrationException("Flag can't have both normal and long flag empty!");
        }
        FlagValidator.validate(flag);
        FlagValidator.validate(longFlag);
    }

    @Override
    @Nullable
    public String getFlag() {
        return this.flag;
    }

    @Override
    @Nullable
    public String getLongFlag() {
        return this.longFlag;
    }

    @Override
    @NotNull
    public String getKey() {
        if (this.flag == null && this.longFlag == null) {
            throw new CommandExecutionException("Both flag and long flag can't be null.");
        }
        return this.flag == null ? this.longFlag : this.flag;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public SuggestionKey getSuggestion() {
        return this.suggestionKey;
    }

    @Override
    public boolean hasArgument() {
        return this.argument != null && this.argument != Void.TYPE;
    }

    @Override
    @NotNull
    public Class<?> getArgument() {
        return this.argument;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagOptions that = (FlagOptions)o;
        return Objects.equals(this.flag, that.flag) && Objects.equals(this.longFlag, that.longFlag) && Objects.equals(this.argument, that.argument);
    }

    public int hashCode() {
        return Objects.hash(this.flag, this.longFlag, this.argument);
    }

    public String toString() {
        return "FlagOptions{flag='" + this.getKey() + '\'' + '}';
    }
}

