/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.keyed;

import dev.triumphteam.cmd.core.argument.keyed.ArgumentGroup;
import dev.triumphteam.cmd.core.argument.keyed.Flag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FlagGroup
implements ArgumentGroup<Flag> {
    private final Map<String, Flag> flags = new HashMap<String, Flag>();
    private final Map<String, Flag> longFlags = new HashMap<String, Flag>();
    private final Map<String, Flag> allFlags = new HashMap<String, Flag>();

    public FlagGroup(@NotNull List<Flag> flags) {
        flags.forEach(this::addArgument);
    }

    public void addArgument(@NotNull Flag argument) {
        String key = argument.getKey();
        String longFlag = argument.getLongFlag();
        if (longFlag != null) {
            this.allFlags.put("--" + longFlag, argument);
            this.longFlags.put(longFlag, argument);
        }
        this.allFlags.put("-" + key, argument);
        this.flags.put(key, argument);
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        return this.allFlags.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.flags.isEmpty() && this.longFlags.isEmpty();
    }

    @Override
    @Nullable
    public Flag matchExact(@NotNull String token) {
        String stripped = this.stripLeadingHyphens(token);
        Flag flag = this.flags.get(stripped);
        return flag != null ? flag : this.longFlags.get(stripped);
    }

    @Override
    @Nullable
    public Flag matchPartialSingle(@NotNull String token) {
        return null;
    }

    @Override
    @NotNull
    public Set<Flag> getAll() {
        return new HashSet<Flag>(this.flags.values());
    }

    @NotNull
    private String stripLeadingHyphens(@NotNull String token) {
        if (token.startsWith("--")) {
            return token.substring(2);
        }
        if (token.startsWith("-")) {
            return token.substring(1);
        }
        return token;
    }

    public String toString() {
        return "FlagGroup{allFlags=" + this.allFlags + '}';
    }
}

