/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.ArgumentResolver;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolverInternalArgument<S, ST>
extends StringInternalArgument<S, ST> {
    private final ArgumentResolver<S> resolver;

    public ResolverInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull Class<?> type, @NotNull ArgumentResolver<S> resolver, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        super(meta, name, description, type, suggestion, defaultValue, optional);
        this.resolver = resolver;
    }

    @Override
    @NotNull
    public InternalArgumentResult resolve(@NotNull S sender, @NotNull ArgumentInput input) {
        String value = input.getInput();
        if (!this.canUseInput(value)) {
            return InternalArgument.invalid((commands, syntax) -> new InvalidArgumentContext((CommandMeta)commands, (String)syntax, value, this.getName(), this.getType()));
        }
        Object result = this.resolver.resolve(sender, value);
        if (result == null) {
            return InternalArgument.invalid((commands, syntax) -> new InvalidArgumentContext((CommandMeta)commands, (String)syntax, value, this.getName(), this.getType()));
        }
        return InternalArgument.valid(result);
    }

    @Override
    @NotNull
    public String toString() {
        return "ResolverArgument{resolver=" + this.resolver + ", super=" + super.toString() + "}";
    }
}

