/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.utils;

import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.Permissions;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.fusion.paper.api.builders.items.ItemBuilder;
import libs.com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiscUtils {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final Path dataPath = plugin.getDataPath();
    private static final ComponentLogger logger = plugin.getComponentLogger();
    private static final PluginManager pluginManager = plugin.getServer().getPluginManager();

    public static void sendCommand(@Nullable CommandSender sender, @NotNull String command, @NotNull Map<String, String> placeholders) {
        if (command.isEmpty()) {
            return;
        }
        final Server server = plugin.getServer();
        final String result = MiscUtils.populatePlaceholders(sender, command, placeholders);
        new FoliaScheduler((JavaPlugin)plugin, Scheduler.global_scheduler){

            @Override
            public void run() {
                server.dispatchCommand((CommandSender)server.getConsoleSender(), result);
            }
        }.runNow();
    }

    public static void sendCommand(@NotNull String command, @NotNull Map<String, String> placeholders) {
        MiscUtils.sendCommand(null, command, placeholders);
    }

    public static void dropBuilders(@NotNull List<ItemBuilder> builders, @NotNull Player player) {
        if (builders.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemBuilder builder : builders) {
            items.add(builder.asItemStack((Audience)player));
        }
        MiscUtils.dropItems(items, player);
    }

    public static void dropLegacyBuilders(@NotNull List<LegacyItemBuilder> builders, @NotNull Player player) {
        if (builders.isEmpty()) {
            return;
        }
        boolean isPlaceholderAPIEnabled = Plugins.placeholder_api.isEnabled();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (LegacyItemBuilder builder : builders) {
            if (isPlaceholderAPIEnabled) {
                List<String> displayLore;
                String displayName = builder.getDisplayName();
                if (!displayName.isEmpty()) {
                    builder.setDisplayName(PlaceholderAPI.setPlaceholders((Player)player, (String)displayName));
                }
                if (!(displayLore = builder.getDisplayLore()).isEmpty()) {
                    ArrayList<String> lore = new ArrayList<String>();
                    displayLore.forEach(line -> lore.add(PlaceholderAPI.setPlaceholders((Player)player, (String)line)));
                    builder.setDisplayLore(lore);
                }
            }
            items.add(builder.asItemStack());
        }
        MiscUtils.dropItems(items, player);
    }

    public static void dropItems(final @NotNull List<ItemStack> items, final @NotNull Player player) {
        final Location location = player.getLocation();
        new FoliaScheduler(plugin, location){

            @Override
            public void run() {
                for (ItemStack item : items) {
                    MiscUtils.dropItem(player, item, location, false);
                }
            }
        }.runNow();
    }

    public static void dropItem(final @NotNull Player player, final @NotNull ItemStack itemStack, final @NotNull Location location, boolean execute) {
        final boolean isInventoryEmpty = MiscUtils.isInventoryFull(player);
        final World world = player.getWorld();
        if (execute) {
            new FoliaScheduler(plugin, location){

                @Override
                public void run() {
                    if (!isInventoryEmpty) {
                        MiscUtils.addItem(player, itemStack);
                    } else {
                        world.dropItemNaturally(location, itemStack.clone());
                    }
                }
            }.runNow();
            return;
        }
        if (!isInventoryEmpty) {
            MiscUtils.addItem(player, itemStack);
        } else {
            world.dropItemNaturally(location, itemStack.clone());
        }
    }

    public static void sendCommand(@NotNull String command) {
        MiscUtils.sendCommand(command, new HashMap<String, String>());
    }

    public static String populatePlaceholders(@Nullable CommandSender sender, @NotNull String line, @NotNull Map<String, String> placeholders) {
        if (sender != null && Plugins.placeholder_api.isEnabled() && sender instanceof Player) {
            Player player = (Player)sender;
            line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
        }
        if (!placeholders.isEmpty()) {
            for (Map.Entry<String, String> placeholder : placeholders.entrySet()) {
                if (placeholder == null) continue;
                String key = placeholder.getKey();
                String value = placeholder.getValue();
                if (key == null || value == null) continue;
                line = line.replace(key, value).replace(key.toLowerCase(), value);
            }
        }
        return line;
    }

    public static void janitor() {
        if (!Files.exists(dataPath.resolve("logs"), new LinkOption[0]) || !ConfigManager.getConfig().getProperty(ConfigKeys.log_to_file).booleanValue()) {
            return;
        }
        FileKeys.crate_log.save();
        FileKeys.key_log.save();
    }

    public static double calculateWeight(int chance, int maxRange) {
        return new BigDecimal((double)chance / (double)maxRange * 100.0).setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public static void spawnFirework(@NotNull Location location, @Nullable Color color) {
        final Firework firework = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK_ROCKET);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull FireworkEffect.Builder effect = FireworkEffect.builder().with(FireworkEffect.Type.BALL).trail(false).flicker(false);
        if (color != null) {
            effect.withColor(color);
        } else {
            effect.withColor(Color.RED).withColor(Color.AQUA).withColor(Color.ORANGE).withColor(Color.YELLOW);
        }
        fireworkMeta.addEffects(new FireworkEffect[]{effect.build()});
        fireworkMeta.setPower(0);
        firework.setFireworkMeta(fireworkMeta);
        PersistentDataContainer fireworkData = firework.getPersistentDataContainer();
        fireworkData.set(ItemKeys.no_firework_damage.getNamespacedKey(), PersistentDataType.BOOLEAN, (Object)true);
        new FoliaScheduler((JavaPlugin)plugin, null, (Entity)firework){

            @Override
            public void run() {
                firework.detonate();
            }
        }.runDelayed(3L);
    }

    @NotNull
    public static String location(@NotNull Location location, boolean getName) {
        String name = getName ? location.getWorld().getName() : String.valueOf(location.getWorld().getUID());
        return name + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    @NotNull
    public static String location(@NotNull Location location) {
        return MiscUtils.location(location, false);
    }

    public static boolean isInventoryFull(@NotNull Player player) {
        return player.getInventory().firstEmpty() == -1;
    }

    public static void save() {
        YamlConfiguration data = FileKeys.data.getConfiguration();
        YamlConfiguration location = FileKeys.locations.getConfiguration();
        boolean isSave = false;
        if (!location.contains("Locations")) {
            location.set("Locations.Clear", null);
            isSave = true;
        }
        if (!data.contains("Players")) {
            data.set("Players.Clear", null);
            isSave = true;
        }
        if (!data.contains("Prizes")) {
            data.set("Prizes.Clear", null);
            isSave = true;
        }
        if (isSave) {
            FileKeys.data.save();
        }
    }

    @Nullable
    public static Map<Integer, ItemStack> removeMultipleItemStacks(@NotNull Inventory inventory, ItemStack ... items) {
        if (items != null) {
            HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
            block0: for (int i = 0; i < items.length; ++i) {
                ItemStack item = items[i];
                int toDelete = item.getAmount();
                do {
                    ItemStack[] toSearch;
                    int first;
                    if ((first = MiscUtils.getFirstItem(item, false, toSearch = inventory.getContents())) == -1) {
                        item.setAmount(toDelete);
                        leftover.put(i, item);
                        continue block0;
                    }
                    ItemStack itemStack = inventory.getItem(first);
                    if (itemStack == null) continue;
                    int amount = itemStack.getAmount();
                    if (amount <= toDelete) {
                        toDelete -= amount;
                        inventory.clear(first);
                        continue;
                    }
                    itemStack.setAmount(amount - toDelete);
                    inventory.setItem(first, itemStack);
                    toDelete = 0;
                } while (toDelete > 0);
            }
            return leftover;
        }
        if (MiscUtils.isLogging()) {
            logger.warn("Items cannot be null.");
        }
        return null;
    }

    private static int getFirstItem(@Nullable ItemStack item, boolean getAmount, @Nullable ItemStack[] inventory) {
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack inventoryItem = inventory[i];
            if (inventoryItem == null || (!getAmount || !item.equals((Object)inventoryItem)) && (getAmount || !item.isSimilar(inventoryItem))) continue;
            return i;
        }
        return -1;
    }

    public static void failedToTakeKey(@NotNull CommandSender player, @NotNull String crateName) {
        if (MiscUtils.isLogging()) {
            List.of("An error has occurred while trying to take a key from a player.", "Player: " + player.getName(), "Key: " + crateName).forEach(arg_0 -> ((ComponentLogger)logger).warn(arg_0));
            List.of("=== === === === === === Crates === === === === === ===", "<red>An issue has occurred when trying to take a key.", "<red>A list of potential reasons", "", " <yellow>-> <light_purple>Not enough keys.", " <yellow>-> <light_purple>Key is in off hand.", "=== === === === === === Crates === === === === === ===").forEach(arg_0 -> ((CommandSender)player).sendRichMessage(arg_0));
        }
    }

    public static long pickNumber(long min, long max) {
        ++max;
        try {
            return min + MiscUtils.getRandom().nextLong(max - min);
        }
        catch (IllegalArgumentException exception) {
            return min;
        }
    }

    public static int randomNumber(int min, int max) {
        return min + MiscUtils.getRandom().nextInt(max - min);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    public static Random getRandom() {
        return MiscUtils.useDifferentRandom() ? ThreadLocalRandom.current() : new Random();
    }

    public static LegacyItemBuilder getRandomPaneColor() {
        List<ItemType> panes = Arrays.asList(ItemType.LIGHT_BLUE_STAINED_GLASS_PANE, ItemType.MAGENTA_STAINED_GLASS_PANE, ItemType.YELLOW_STAINED_GLASS_PANE, ItemType.PURPLE_STAINED_GLASS_PANE, ItemType.ORANGE_STAINED_GLASS_PANE, ItemType.GREEN_STAINED_GLASS_PANE, ItemType.BROWN_STAINED_GLASS_PANE, ItemType.BLACK_STAINED_GLASS_PANE, ItemType.BLUE_STAINED_GLASS_PANE, ItemType.CYAN_STAINED_GLASS_PANE, ItemType.GRAY_STAINED_GLASS_PANE, ItemType.LIME_STAINED_GLASS_PANE, ItemType.PINK_STAINED_GLASS_PANE, ItemType.RED_STAINED_GLASS_PANE);
        return new LegacyItemBuilder(plugin, panes.get(ThreadLocalRandom.current().nextInt(panes.size())));
    }

    public static void addItem(@NotNull Player player, ItemStack ... items) {
        PlayerInventory inventory = player.getInventory();
        inventory.setMaxStackSize(64);
        Arrays.asList(items).forEach(arg_0 -> MiscUtils.lambda$addItem$1((Inventory)inventory, arg_0));
    }

    public static List<Integer> slowSpin(int full, int cut) {
        ArrayList<Integer> slow = new ArrayList<Integer>();
        int index = full;
        while (cut > 0) {
            if (full <= index - cut || full >= index - cut) {
                slow.add(index);
                index -= cut;
                --cut;
            }
            --full;
        }
        return slow;
    }

    public static boolean useDifferentRandom() {
        return ConfigManager.getConfig().getProperty(ConfigKeys.use_different_random);
    }

    public static void registerPermission(@NotNull String permission, @NotNull String description, boolean isDefault) {
        if (permission.isEmpty()) {
            return;
        }
        if (pluginManager.getPermission(permission) != null) {
            if (MiscUtils.isLogging()) {
                logger.warn("Permission {} is already on the server. Pick a different name", (Object)permission);
            }
            return;
        }
        if (MiscUtils.isLogging()) {
            logger.warn("Permission {} is registered", (Object)permission);
        }
        pluginManager.addPermission(new Permission(permission, description, isDefault ? PermissionDefault.TRUE : PermissionDefault.OP));
    }

    public static void unregisterPermission(String permission) {
        if (permission.isEmpty()) {
            return;
        }
        if (pluginManager.getPermission(permission) == null) {
            if (MiscUtils.isLogging()) {
                logger.warn("Permission {} is not registered", (Object)permission);
            }
            return;
        }
        if (MiscUtils.isLogging()) {
            logger.warn("Permission {} is unregistered", (Object)permission);
        }
        pluginManager.removePermission(permission);
    }

    public static void registerPermissions() {
        Arrays.stream(Permissions.values()).toList().forEach(permission -> {
            Permission newPermission = new Permission(permission.getPermission(), permission.getDescription(), permission.isDefault(), permission.getChildren());
            pluginManager.addPermission(newPermission);
        });
    }

    public static boolean isLogging() {
        return plugin.getFusion().isVerbose();
    }

    public static boolean isExcellentCratesEnabled() {
        return pluginManager.isPluginEnabled("ExcellentCrates");
    }

    private static /* synthetic */ void lambda$addItem$1(Inventory inventory, ItemStack item) {
        inventory.addItem(new ItemStack[]{item.clone()});
    }
}

