/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.menus;

import com.badbones69.crazycrates.paper.api.builders.gui.DynamicInventoryBuilder;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiFiller;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import libs.com.ryderbelserion.fusion.paper.api.builders.gui.types.PaginatedGui;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class CratePreviewMenu
extends DynamicInventoryBuilder {
    private final Tier tier;
    private final Player player = this.getPlayer();
    private final PaginatedGui gui = this.getGui();

    public CratePreviewMenu(@NotNull Player player, @NotNull Crate crate, @NotNull Tier tier) {
        super(player, crate, crate.getPreviewName(), crate.getPreviewRows());
        this.tier = tier;
    }

    @Override
    public void open() {
        Crate crate = this.getCrate();
        if (crate == null) {
            return;
        }
        GuiFiller guiFiller = this.gui.getFiller();
        if (crate.isBorderToggle()) {
            GuiItem guiItem = new GuiItem(crate.getBorderItem().asItemStack());
            guiFiller.fillTop(guiItem);
            guiFiller.fillBottom(guiItem);
        } else {
            guiFiller.fillBottom(new GuiItem(ItemType.AIR.createItemStack()));
        }
        UUID uuid = this.player.getUniqueId();
        crate.getPreviewItems(this.player, this.tier).forEach(itemStack -> this.gui.addItem(new GuiItem((ItemStack)itemStack)));
        this.gui.setOpenGuiAction(event -> this.inventoryManager.addPreviewViewer(uuid));
        this.gui.setCloseGuiAction(event -> this.inventoryManager.removePreviewViewer(uuid));
        this.gui.open(this.player, gui -> {
            this.addBackButton(true);
            this.addNextButton(true);
            this.addMenuButton(this.player, crate, this.gui);
        });
    }
}

