/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class WheelCrate
extends CrateBuilder {
    private final Inventory inventory = this.getInventory();
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();
    private Map<Integer, ItemStack> rewards;

    public WheelCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, @Nullable EventType eventType) {
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        final boolean isGlassBorderToggled = this.crate.isGlassBorderToggled();
        if (isGlassBorderToggled) {
            for (int index = 0; index < this.getSize(); ++index) {
                this.setCustomGlassPane(index);
            }
        }
        this.rewards = new HashMap<Integer, ItemStack>();
        for (int number : this.getBorder()) {
            Prize prize = this.crate.pickPrize(this.player);
            this.setItem(number, prize.getDisplayItem(this.player, this.crate));
            this.rewards.put(number, prize.getDisplayItem(this.player, this.crate));
        }
        this.player.openInventory(this.inventory);
        final Material material = Material.LIME_STAINED_GLASS_PANE;
        this.addCrateTask(new FoliaScheduler(this.plugin, null, (Entity)this.player){
            final List<Integer> slots;
            int uh;
            int what;
            int full;
            final int timer;
            int slower;
            int open;
            int slow;
            {
                super(arg0, arg1, arg2);
                this.slots = WheelCrate.this.getBorder();
                this.uh = 0;
                this.what = 17;
                this.full = 0;
                this.timer = MiscUtils.randomNumber(42, 68);
                this.slower = 0;
                this.open = 0;
                this.slow = 0;
            }

            @Override
            public void run() {
                if (this.uh >= 18) {
                    this.uh = 0;
                }
                if (this.what >= 18) {
                    this.what = 0;
                }
                if (this.full < this.timer) {
                    this.populateMenu();
                }
                if (this.full >= this.timer) {
                    if (MiscUtils.slowSpin(46, 9).contains(this.slower)) {
                        this.populateMenu();
                    }
                    if (isGlassBorderToggled && this.full >= this.timer + 47) {
                        ++this.slow;
                        if (this.slow >= 2) {
                            for (int slot = 0; slot < WheelCrate.this.getSize(); ++slot) {
                                if (WheelCrate.this.getBorder().contains(slot)) continue;
                                WheelCrate.this.setCustomGlassPane(slot);
                            }
                            this.slow = 0;
                        }
                    }
                    if (this.full >= this.timer + 55 + 47) {
                        Prize prize = null;
                        if (WheelCrate.this.crateManager.isInOpeningList(WheelCrate.this.player)) {
                            prize = WheelCrate.this.crate.getPrize(WheelCrate.this.rewards.get(this.slots.get(this.what)));
                        }
                        if (WheelCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(WheelCrate.this.crate, WheelCrate.this.player)) {
                            new CrateSpinMenu(WheelCrate.this.player, new GuiSettings(WheelCrate.this.crate, prize, FileKeys.respin_gui.getConfiguration())).open();
                            return;
                        }
                        WheelCrate.this.userManager.removeRespinPrize(WheelCrate.this.uuid, fileName);
                        if (!WheelCrate.this.crate.isCyclePersistRestart()) {
                            WheelCrate.this.userManager.removeRespinCrate(WheelCrate.this.uuid, fileName, WheelCrate.this.userManager.getCrateRespin(WheelCrate.this.uuid, fileName));
                        }
                        PrizeManager.givePrize(WheelCrate.this.player, WheelCrate.this.crate, prize);
                        WheelCrate.this.playSound("stop-sound", Sound.Source.MASTER, "entity.player.levelup");
                        WheelCrate.this.player.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                        WheelCrate.this.crateManager.removePlayerFromOpeningList(WheelCrate.this.player);
                        WheelCrate.this.crateManager.endCrate(WheelCrate.this.player);
                        WheelCrate.this.rewards.clear();
                    }
                    ++this.slower;
                }
                ++this.full;
                ++this.open;
                if (this.open > 5) {
                    WheelCrate.this.player.openInventory(WheelCrate.this.inventory);
                    this.open = 0;
                }
            }

            private void populateMenu() {
                @NotNull ItemStack itemStack = WheelCrate.this.rewards.get(this.slots.get(this.uh));
                WheelCrate.this.setItem(this.slots.get(this.uh), itemStack.withType(material));
                int otherSlot = this.slots.get(this.what);
                WheelCrate.this.setItem(this.slots.get(this.what), WheelCrate.this.rewards.get(otherSlot));
                WheelCrate.this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                ++this.uh;
                ++this.what;
            }
        }.runAtFixedRate(1L, 1L));
    }

    private List<Integer> getBorder() {
        return Arrays.asList(10, 11, 12, 13, 14, 15, 16, 25, 34, 43, 42, 41, 40, 39, 38, 37, 28, 19);
    }
}

