/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import libs.com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class FireCrackerCrate
extends CrateBuilder {
    private final Player player = this.getPlayer();
    private final Location location = this.getLocation();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public FireCrackerCrate(@NotNull Crate crate, @NotNull Player player, int size, @NotNull Location location) {
        super(crate, player, size, location);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, @NotNull EventType eventType) {
        CrateLocation crateLocation;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        final String fileName = this.crate.getFileName();
        this.crateManager.addCrateInUse(this.player, this.location);
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand);
        if (!keyCheck) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        HologramManager manager = this.crateManager.getHolograms();
        if (manager != null && this.crate.getHologram().isEnabled() && (crateLocation = this.crateManager.getCrateLocation(this.location)) != null) {
            manager.removeHologram(crateLocation.getID());
        }
        final List<Color> colors = Arrays.asList(Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE, Color.BLACK, Color.AQUA, Color.MAROON, Color.PURPLE);
        this.addCrateTask(new FoliaScheduler(this.plugin, null, (Entity)this.player){
            final int random;
            final Location clonedLocation;
            int length;
            {
                super(arg0, arg1, arg2);
                this.random = ThreadLocalRandom.current().nextInt(colors.size());
                this.clonedLocation = FireCrackerCrate.this.location.clone().add(0.5, 25.0, 0.5);
                this.length = 0;
            }

            @Override
            public void run() {
                this.clonedLocation.subtract(0.0, 1.0, 0.0);
                MiscUtils.spawnFirework(this.clonedLocation, (Color)colors.get(this.random));
                ++this.length;
                if (this.length == 25) {
                    FireCrackerCrate.this.crateManager.endCrate(FireCrackerCrate.this.player);
                    Prize prize = FireCrackerCrate.this.crate.pickPrize(FireCrackerCrate.this.player);
                    if (FireCrackerCrate.this.crate.isCyclePrize() && !PrizeManager.isCapped(FireCrackerCrate.this.crate, FireCrackerCrate.this.player)) {
                        new CrateSpinMenu(FireCrackerCrate.this.player, new GuiSettings(FireCrackerCrate.this.crate, prize, FileKeys.respin_gui.getConfiguration())).open();
                        FireCrackerCrate.this.crateManager.removePlayerFromOpeningList(FireCrackerCrate.this.player);
                        FireCrackerCrate.this.crateManager.removeCrateInUse(FireCrackerCrate.this.player);
                        return;
                    }
                    FireCrackerCrate.this.userManager.removeRespinPrize(FireCrackerCrate.this.uuid, fileName);
                    if (!FireCrackerCrate.this.crate.isCyclePersistRestart()) {
                        FireCrackerCrate.this.userManager.removeRespinCrate(FireCrackerCrate.this.uuid, fileName, FireCrackerCrate.this.userManager.getCrateRespin(FireCrackerCrate.this.uuid, fileName));
                    }
                    FireCrackerCrate.this.displayItem(prize);
                    PrizeManager.givePrize(FireCrackerCrate.this.player, FireCrackerCrate.this.crate, prize);
                    FireCrackerCrate.this.addCrateTask(new FoliaScheduler(FireCrackerCrate.this.plugin, null, (Entity)FireCrackerCrate.this.player){

                        @Override
                        public void run() {
                            CrateLocation crateLocation;
                            FireCrackerCrate.this.crateManager.removePlayerFromOpeningList(FireCrackerCrate.this.player);
                            FireCrackerCrate.this.crateManager.removeCrateInUse(FireCrackerCrate.this.player);
                            FireCrackerCrate.this.crateManager.removeReward(FireCrackerCrate.this.player);
                            HologramManager hologramManager = FireCrackerCrate.this.crateManager.getHolograms();
                            if (hologramManager != null && FireCrackerCrate.this.crate.getHologram().isEnabled() && (crateLocation = FireCrackerCrate.this.crateManager.getCrateLocation(FireCrackerCrate.this.location)) != null) {
                                hologramManager.createHologram(FireCrackerCrate.this.location, FireCrackerCrate.this.crate, crateLocation.getID());
                            }
                        }
                    }.runDelayed(40L));
                }
            }
        }.runAtFixedRate(0L, 2L));
    }
}

